/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodReferenceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

public abstract class Usages {
    public static void processUsages(SourceElement sourceElement, final Usages usages) {
        SourceVisitor visitor = new SourceVisitor(){

            @Override
            protected boolean enter(SourceElement sym) {
                if (!usages.shouldTraverse(sym)) {
                    return false;
                }
                return super.enter(sym);
            }

            @Override
            public void whenEnterClass(SourceClass sourceClass) {
                usages.declareClass(sourceClass);
            }

            @Override
            public void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
                usages.declareConstructor(sourceMethod);
            }

            @Override
            public void whenEnterEnumConstantDeclaration(SourceEnumConstant sourceEnumConstant) {
                usages.declareEnumConstant(sourceEnumConstant);
            }

            @Override
            public void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
                usages.declareField(sourceFieldVariable);
            }

            @Override
            public void whenEnterLocalVariable(SourceLocalVariable sourceLocalVariable) {
                usages.declareLocalVariable(sourceLocalVariable);
            }

            @Override
            public void whenEnterCatchParameter(SourceCatchParameter sourceCatchParameter) {
                usages.declareCatchParameter(sourceCatchParameter);
            }

            @Override
            public void whenEnterLambdaParameter(SourceLambdaParameter sourceLambdaParameter) {
                usages.declareLambdaParameter(sourceLambdaParameter);
            }

            @Override
            public void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
                usages.declareMethod(sourceMethod);
            }

            @Override
            public void whenEnterFormalParameter(SourceFormalParameter sourceVariable) {
                usages.declareParameter(sourceVariable);
            }

            @Override
            public void whenEnterTypeParameter(SourceTypeParameter sourceTypeParameter) {
                usages.declareTypeParameter(sourceTypeParameter);
            }

            @Override
            public void whenEnterName(SourceName sourceName) {
                JavaMethod javaMethod;
                SourceElement parent = sourceName.getParent();
                if (parent != null && parent.getSymbolKind() == 66 && (javaMethod = ((SourceMethodReferenceExpression)parent).getResolvedMethod()) != null) {
                    usages.useMethodInExpression((SourceMethodReferenceExpression)parent, javaMethod);
                }
            }

            @Override
            public void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
                this.handleSourceExpression(sourceSimpleNameExpression);
            }

            @Override
            public void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
                this.handleSourceExpression(sourceDotExpression);
            }

            private void handleSourceExpression(SourceExpression sourceExpression) {
                JavaHasType hasType = sourceExpression.getResolvedObject();
                boolean isField = hasType instanceof JavaField;
                boolean isMethod = hasType instanceof JavaMethod;
                boolean isParameter = hasType instanceof SourceFormalParameter;
                boolean isType = hasType instanceof JavaType;
                System.out.println();
                if (isField) {
                    usages.useFieldInExpression(sourceExpression, (JavaField)hasType);
                } else if (isParameter) {
                    usages.useParameterInExpression(sourceExpression, (SourceFormalParameter)hasType);
                } else {
                    if (hasType instanceof SourceLocalVariable) {
                        usages.useLocalVariableInExpression(sourceExpression, (SourceLocalVariable)hasType);
                        return;
                    }
                    if (isType) {
                        usages.useTypeInExpression(sourceExpression, (JavaType)hasType);
                    }
                }
                for (SourceElement parent = sourceExpression; parent != null; parent = parent.getParent()) {
                    int kind = parent.getSymbolKind();
                    switch (kind) {
                        case 57: 
                        case 59: {
                            if (isMethod) {
                                usages.useMethodInExpression((SourceInvokeExpression)parent, (JavaMethod)hasType);
                            }
                            return;
                        }
                        case 66: {
                            SourceMethodReferenceExpression methodRef = (SourceMethodReferenceExpression)parent;
                            if (isMethod) {
                                usages.useMethodInExpression(methodRef, (JavaMethod)hasType);
                            } else if (isType) {
                                usages.useTypeInMethodReference(methodRef.getQualifier(), (JavaType)hasType);
                            }
                            return;
                        }
                    }
                    if (!(parent instanceof SourceStatement) && !(parent instanceof SourceMember)) continue;
                    return;
                }
            }

            @Override
            public void whenEnterImportDeclaration(SourceImport sourceImport) {
                if (sourceImport.isStatic() || sourceImport.getName().endsWith(".*")) {
                    return;
                }
                if (sourceImport.getImportedElementCount() == 0) {
                    return;
                }
                JavaHasType javaHasType = sourceImport.getImportedElementAt(0);
                JavaType javaType = javaHasType.getResolvedType();
                if (javaType != null) {
                    usages.useTypeInNarrowImport(sourceImport, javaType);
                }
            }

            @Override
            public void whenEnterTypeRef(SourceTypeReference sourceType) {
                SourceElement parent = sourceType.getParent();
                if (parent == null) {
                    return;
                }
                JavaType javaType = sourceType.getResolvedType();
                if (javaType == null) {
                    return;
                }
                if (javaType.isArray()) {
                    javaType = javaType.getBaseComponentType();
                }
                if (javaType == null) {
                    return;
                }
                while (parent != null) {
                    int kind = parent.getSymbolKind();
                    switch (kind) {
                        case 1: {
                            usages.useTypeInAnnotation((SourceAnnotation)parent, javaType);
                            return;
                        }
                        case 9: {
                            usages.useTypeInFieldDecl(sourceType, javaType);
                            return;
                        }
                        case 28: {
                            usages.useTypeInCatchParameter(sourceType, javaType);
                            return;
                        }
                        case 13: {
                            usages.useTypeInParameter(sourceType, javaType);
                            return;
                        }
                        case 31: {
                            usages.useTypeInLambdaParameter(sourceType, javaType);
                            return;
                        }
                        case 15: {
                            usages.useTypeInClassExtends(sourceType, javaType);
                            return;
                        }
                        case 19: {
                            usages.useTypeInReturnType(sourceType, javaType);
                            return;
                        }
                        case 18: {
                            usages.useTypeInLocalVariableDecl(sourceType, javaType);
                            return;
                        }
                        case 22: {
                            usages.useTypeInClassExtends(sourceType, javaType);
                            return;
                        }
                        case 24: {
                            usages.useTypeInThrows(sourceType, javaType);
                            return;
                        }
                        case 58: {
                            usages.useTypeInCreator(sourceType, javaType);
                            return;
                        }
                        case 59: {
                            usages.useTypeInCreator(sourceType, javaType);
                            SourceNewClassExpression newClassExpr = (SourceNewClassExpression)parent;
                            JavaMethod constructor = newClassExpr.getResolvedMethod();
                            if (constructor != null) {
                                usages.useMethodInExpression(newClassExpr, constructor);
                            }
                            return;
                        }
                        case 74: {
                            usages.useTypeInDocComment((SourceDocReference)parent, javaType);
                            return;
                        }
                        case 54: {
                            if (((SourceInfixExpression)parent).getOperatorCode() != 23) break;
                            usages.useTypeInInstanceof(sourceType, javaType);
                            return;
                        }
                        case 63: {
                            usages.useTypeInTypecast(sourceType, javaType);
                            return;
                        }
                    }
                    if (parent instanceof SourceMember || parent instanceof SourceStatement) break;
                    parent = parent.getParent();
                }
                usages.useTypeInMiscellaneous(sourceType, javaType);
            }

            @Override
            public void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
                JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
                if (javaMethod != null) {
                    usages.useMethodInExpression(sourceMethodCallExpression, javaMethod);
                }
            }

            @Override
            public void whenEnterDocReference(SourceDocReference sourceDocReference) {
                SourceFormalParameter resolvedParameter;
                JavaMember resolvedMember;
                JavaType resolvedClass = sourceDocReference.getResolvedClass();
                if (resolvedClass != null) {
                    usages.useTypeInDocComment(sourceDocReference, resolvedClass);
                }
                if ((resolvedMember = sourceDocReference.getResolvedMember()) != null) {
                    int kind = resolvedMember.getElementKind();
                    if (kind == 5) {
                        usages.useFieldInDocComment(sourceDocReference, (JavaField)resolvedMember);
                    } else if (kind == 8) {
                        usages.useMethodInDocComment(sourceDocReference, (JavaMethod)resolvedMember);
                    }
                }
                if ((resolvedParameter = sourceDocReference.getResolvedParameter()) != null) {
                    usages.useParameterInDocComment(sourceDocReference, resolvedParameter);
                }
            }
        };
        visitor.visit(sourceElement);
    }

    public boolean shouldTraverse(SourceElement element) {
        return true;
    }

    public void declareClass(SourceClass s) {
    }

    public void declareConstructor(SourceMethod s) {
    }

    public void declareEnumConstant(SourceEnumConstant s) {
    }

    public void declareField(SourceFieldVariable s) {
    }

    public void declareLocalVariable(SourceLocalVariable s) {
    }

    public void declareCatchParameter(SourceCatchParameter s) {
    }

    public void declareLambdaParameter(SourceLambdaParameter s) {
    }

    public void declareMethod(SourceMethod s) {
    }

    public void declareParameter(SourceFormalParameter s) {
    }

    public void declareTypeParameter(SourceTypeParameter s) {
    }

    public void useFieldInDocComment(SourceDocReference s, JavaField field) {
    }

    public void useFieldInExpression(SourceExpression s, JavaField field) {
    }

    public void useLocalVariableInExpression(SourceExpression s, JavaLocalVariable local) {
    }

    public void useMethodInDocComment(SourceDocReference s, JavaMethod method) {
    }

    public void useMethodInExpression(SourceInvokeExpression s, JavaMethod method) {
    }

    public void useMethodInExpression(SourceMethodReferenceExpression s, JavaMethod method) {
    }

    public void useParameterInDocComment(SourceDocReference s, JavaLocalVariable parameter) {
    }

    public void useParameterInExpression(SourceExpression s, JavaLocalVariable parameter) {
    }

    public void useTypeInAnnotation(SourceAnnotation s, JavaType type) {
    }

    public void useTypeInDocComment(SourceDocReference s, JavaType type) {
    }

    public void useTypeInExpression(SourceExpression s, JavaType type) {
    }

    public void useTypeInClassExtends(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInFieldDecl(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInInstanceof(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInLocalVariableDecl(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInMiscellaneous(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInNarrowImport(SourceImport s, JavaType type) {
    }

    public void useTypeInCreator(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInParameter(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInCatchParameter(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInLambdaParameter(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInMethodReference(SourceExpression s, JavaType type) {
    }

    public void useTypeInReturnType(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInThrows(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInTypecast(SourceTypeReference s, JavaType type) {
    }
}

