/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.feedback.FeedbackLogOptions;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;

public class BindingContext {
    private JavaIsGeneric sourceContext;
    private JavaType targetContext;
    private JavaProvider provider;

    public BindingContext(JavaProvider provider) {
        this.provider = provider;
    }

    public BindingContext(JavaProvider provider, JavaType targetContext) {
        this.provider = provider;
        this.setTargetContext(targetContext);
    }

    public BindingContext(JavaProvider provider, JavaIsGeneric sourceContext, JavaType targetContext) {
        this(provider);
        this.setContext(sourceContext, targetContext);
    }

    public JavaProvider getProvider() {
        return this.provider;
    }

    public void setContext(JavaIsGeneric sourceContext, JavaType targetContext) {
        this.setSourceContext(sourceContext);
        this.setTargetContext(targetContext);
    }

    public void setTargetContext(JavaType targetContext) {
        this.targetContext = targetContext;
    }

    public void setSourceContext(JavaIsGeneric sourceContext) {
        this.sourceContext = sourceContext;
    }

    public JavaMember getSourceContext() {
        return this.sourceContext;
    }

    public JavaType getTargetContext() {
        return this.targetContext;
    }

    public JavaType bind(JavaType type) {
        JavaType boundElementType;
        if (type == null) {
            return null;
        }
        if (this.isRaw()) {
            return type.getTypeErasure();
        }
        JavaType elementType = type;
        int dimensions = 0;
        while (elementType.isArray()) {
            if ((elementType = elementType.getComponentType()) == null) {
                return type;
            }
            ++dimensions;
        }
        switch (elementType.getElementKind()) {
            case 10: {
                JavaType boundValue = null;
                JavaTypeVariable variable = (JavaTypeVariable)elementType;
                JavaMember variableOwner = variable.getOwningMember();
                int variableOwnerElementKind = variableOwner.getElementKind();
                if (variableOwner != null) {
                    JavaMember context = this.getTargetContext();
                    while (context != null && !context.isStatic()) {
                        int contextElementKind = context.getElementKind();
                        if (contextElementKind == variableOwnerElementKind) {
                            boolean equals = false;
                            switch (contextElementKind) {
                                case 3: {
                                    equals = ((JavaClass)context).getDescriptor().equals(((JavaClass)variableOwner).getDescriptor());
                                    break;
                                }
                                case 8: {
                                    equals = ((JavaMethod)context).getDescriptor().equals(((JavaMethod)variableOwner).getDescriptor());
                                }
                            }
                            if (equals) {
                                boundValue = variable;
                                break;
                            }
                        }
                        context = BindingContext.getOwningMember(context);
                    }
                    if (boundValue == null) {
                        String variableName = variable.getName();
                        String variableOwnerName = variableOwner.getUniqueIdentifier();
                        JavaIsGeneric context2 = this.sourceContext;
                        block11: while (context2 != null) {
                            if (context2.hasTypeParameters()) {
                                if (context2 instanceof JavaMethod) {
                                    if (variableOwnerElementKind == 8 && ((JavaMethod)context2).getDescriptor().equals(((JavaMethod)variableOwner).getDescriptor())) {
                                        boundValue = variable;
                                        break;
                                    }
                                } else if (context2.hasActualTypeArguments()) {
                                    Collection<JavaTypeVariable> parameters = context2.getTypeParameters();
                                    Collection<JavaType> arguments = context2.getActualTypeArguments();
                                    Iterator<JavaTypeVariable> p = parameters.iterator();
                                    Iterator<JavaType> a = arguments.iterator();
                                    while (p.hasNext()) {
                                        JavaTypeVariable nextParam = p.next();
                                        JavaMember paramOwner = nextParam.getOwningMember();
                                        if (!variableOwnerName.equals(paramOwner.getUniqueIdentifier())) continue;
                                        String name = nextParam.getName();
                                        JavaType value = a.next();
                                        if (!variableName.equals(name)) continue;
                                        boundValue = value;
                                        break block11;
                                    }
                                }
                            }
                            context2 = BindingContext.getOwningGeneric(context2);
                        }
                    }
                }
                if (boundValue == null) {
                    boundValue = variable.getTypeErasure();
                }
                boundElementType = boundValue;
                break;
            }
            case 3: {
                if (elementType.hasTypeParameters()) {
                    if (elementType.hasActualTypeArguments()) {
                        Collection<JavaType> parameters = elementType.getActualTypeArguments();
                        if (parameters.isEmpty()) {
                            boundElementType = elementType;
                            break;
                        }
                        JavaType[] arguments = new JavaType[parameters.size()];
                        int p = 0;
                        for (JavaType parameterType : parameters) {
                            JavaType boundParameterType = parameterType != type ? this.bind(parameterType) : parameterType.getTypeErasure();
                            arguments[p++] = boundParameterType;
                        }
                        boundElementType = CommonUtilities.createParameterizedType(this.provider, elementType.getTypeErasure(), arguments);
                        break;
                    }
                    boundElementType = elementType.getTypeErasure();
                    break;
                }
                boundElementType = elementType;
                break;
            }
            case 11: {
                JavaType boundBound;
                JavaType bound;
                byte boundType;
                JavaWildcardType wildcard = (JavaWildcardType)elementType;
                Collection<JavaType> upper = wildcard.getUpperBounds();
                Collection<JavaType> lower = wildcard.getLowerBounds();
                if (!upper.isEmpty()) {
                    boundType = 1;
                    bound = upper.iterator().next();
                    boundBound = this.bind(bound);
                } else if (!lower.isEmpty()) {
                    boundType = 2;
                    bound = lower.iterator().next();
                    boundBound = this.bind(bound);
                } else {
                    boundType = 0;
                    boundBound = null;
                    bound = null;
                }
                if (bound != boundBound) {
                    boundElementType = CommonUtilities.createWildcardType(boundType, boundBound, this.getProvider());
                    break;
                }
                boundElementType = elementType;
                break;
            }
            default: {
                boundElementType = elementType;
            }
        }
        if (dimensions == 0) {
            return boundElementType;
        }
        if (elementType == boundElementType) {
            return type;
        }
        return CommonUtilities.createArrayType(this.getProvider(), boundElementType, dimensions);
    }

    public boolean isRaw() {
        return this.isRaw(this.sourceContext instanceof JavaType ? (JavaType)this.sourceContext : this.sourceContext.getOwningClass());
    }

    private boolean isRaw(JavaType type) {
        return type != null && type.hasTypeParameters() && !type.hasActualTypeArguments();
    }

    public String getSimplifiedDescription(JavaMethod method) {
        StringBuffer buffer = new StringBuffer();
        this.appendDescription(method, true, null, null, buffer, null);
        return buffer.toString();
    }

    public boolean appendDescription(JavaMethod method, boolean simplified, String unresolvedPrefix, String unresolvedSuffix, StringBuffer buffer, StringBuffer erased) {
        Collection<JavaVariable> parameters;
        if (unresolvedPrefix == null) {
            unresolvedPrefix = "";
        }
        if (unresolvedSuffix == null) {
            unresolvedSuffix = "";
        }
        boolean resolved = true;
        buffer.append(method.getName());
        buffer.append('(');
        if (erased != null) {
            erased.append(buffer);
        }
        if (!(parameters = method.getParameters()).isEmpty()) {
            String delimiter = "";
            Iterator<JavaVariable> i = parameters.iterator();
            while (i.hasNext()) {
                buffer.append(delimiter);
                JavaVariable parameter = i.next();
                JavaType type = parameter.getResolvedType();
                if (type != null) {
                    boolean bl = resolved = resolved && this.appendDescription(type, simplified, buffer);
                    if (erased != null) {
                        erased.append(BindingContext.getName(type.getTypeErasure(), simplified));
                    }
                } else {
                    resolved = false;
                    String name = parameter.getUnresolvedType().getSimplifiedName();
                    buffer.append(unresolvedPrefix);
                    buffer.append(name);
                    buffer.append(unresolvedSuffix);
                    if (erased != null) {
                        erased.append(unresolvedPrefix);
                        erased.append(name);
                        erased.append(unresolvedSuffix);
                    }
                }
                delimiter = ", ";
            }
        }
        buffer.append(')');
        if (erased != null) {
            erased.append(')');
        }
        return resolved;
    }

    public String getSimplifiedDescription(JavaHasType hasType) {
        StringBuffer buffer = new StringBuffer();
        this.appendDescription(hasType, true, buffer);
        return buffer.toString();
    }

    public boolean appendDescription(JavaHasType hasType, boolean simplified, StringBuffer buffer) {
        if (hasType == null) {
            if (simplified) {
                buffer.append("Object");
            } else {
                buffer.append("java.lang.Object");
            }
            return false;
        }
        boolean resolved = true;
        JavaType type = hasType.getResolvedType();
        if (type != null) {
            if (this.isRaw()) {
                buffer.append(BindingContext.getName(type.getTypeErasure(), simplified));
                return resolved;
            }
            type = this.bind(type);
            int dimensions = 0;
            while (type != null && type.isArray()) {
                type = type.getComponentType();
                ++dimensions;
            }
            if (type != null) {
                switch (type.getElementKind()) {
                    case 3: {
                        if (type.hasTypeParameters()) {
                            if (type.hasActualTypeArguments()) {
                                buffer.append(BindingContext.getName(type, simplified));
                                buffer.append('<');
                                Collection<JavaType> parameters = type.getActualTypeArguments();
                                String separator = "";
                                Iterator<JavaType> i = parameters.iterator();
                                while (i.hasNext()) {
                                    buffer.append(separator);
                                    JavaType parameterType = i.next();
                                    resolved = resolved && this.appendDescription(parameterType, simplified, buffer);
                                    separator = ",";
                                }
                                buffer.append('>');
                                break;
                            }
                            buffer.append(BindingContext.getName(type.getTypeErasure(), simplified));
                            break;
                        }
                        buffer.append(BindingContext.getName(type, simplified));
                        break;
                    }
                    case 11: {
                        JavaWildcardType wildcard = (JavaWildcardType)type;
                        Collection<JavaType> upper = wildcard.getUpperBounds();
                        Collection<JavaType> lower = wildcard.getLowerBounds();
                        if (!upper.isEmpty()) {
                            buffer.append("? extends ");
                            resolved = this.appendDescription(upper.iterator().next(), simplified, buffer);
                            break;
                        }
                        if (!lower.isEmpty()) {
                            buffer.append("? super ");
                            resolved = this.appendDescription(lower.iterator().next(), simplified, buffer);
                            break;
                        }
                        buffer.append('?');
                        break;
                    }
                    default: {
                        buffer.append(BindingContext.getName(type, simplified));
                    }
                }
                while (--dimensions >= 0) {
                    buffer.append("[]");
                }
                return resolved;
            }
        }
        buffer.append(hasType.getUnresolvedType().getSimplifiedName());
        return false;
    }

    private static String getName(JavaType type, boolean simplified) {
        return simplified ? type.getName() : type.getRawName();
    }

    private static JavaMember getOwningMember(JavaElement element) {
        while (element != null) {
            if (!((element = element.getOwner()) instanceof JavaMember)) continue;
            return (JavaMember)element;
        }
        return null;
    }

    private static JavaIsGeneric getOwningGeneric(JavaElement element) {
        int sentinel = 1000;
        for (JavaElement owner = element.getOwner(); owner != null; owner = owner.getOwner()) {
            if (owner instanceof JavaIsGeneric) {
                return (JavaIsGeneric)owner;
            }
            if (--sentinel > 0) continue;
            BindingContext.reportCycle(element);
            break;
        }
        return null;
    }

    private static void reportCycle(JavaElement element) {
        String from = element instanceof JavaMember ? ((JavaMember)element).getUniqueIdentifier() : String.valueOf(element);
        String file = String.valueOf(element.getFile().getURL());
        String text = "detected owning generic cycle from " + from + " in " + file;
        FeedbackLogOptions options = new FeedbackLogOptions(new StackOverflowError(text));
        if (element.isSourceElement()) {
            TextBuffer buffer = element.getSourceElement().getOwningSourceFile().getTextBuffer();
            options.addAdditionalData(text, buffer.getString(0, Math.min(buffer.getLength(), 256000)));
        }
        Logger.getLogger(BindingContext.class.getName()).log(Level.SEVERE, text, options);
    }
}

