/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.model;

import oracle.javatools.parser.java.v2.JavaTokens;

public class SourceToken {
    private int tokenStart;
    private int tokenEnd;
    private short tokenValue;

    public SourceToken(int tokenStart, int tokenEnd, short tokenValue) {
        this.tokenStart = tokenStart;
        this.tokenEnd = tokenEnd;
        this.tokenValue = tokenValue;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public short getTokenValue() {
        return this.tokenValue;
    }

    public String toString() {
        String s;
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(this.getTokenStart());
        buf.append('-');
        buf.append(this.getTokenEnd() - 1);
        buf.append("] ");
        buf.append(this.tokenValue);
        buf.append(" (");
        if (this.tokenValue >= 0 && this.tokenValue < 27) {
            s = JavaTokens.TK_words[this.tokenValue - 0];
        } else if (this.tokenValue >= 96 && this.tokenValue < 146) {
            s = JavaTokens.KW_words[this.tokenValue - 96];
        } else if (this.tokenValue >= 32 && this.tokenValue < 83) {
            s = JavaTokens.OP_words[this.tokenValue - 32];
        } else {
            assert (false) : "No token String representation defined";
            s = "";
        }
        if (s.trim().length() == 0) {
            s = "Unknown token";
        }
        buf.append(s);
        buf.append(')');
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceToken)) {
            return false;
        }
        SourceToken other = (SourceToken)o;
        return this.tokenEnd == other.tokenEnd && this.tokenStart == other.tokenStart && this.tokenValue == other.tokenValue;
    }

    public int hashCode() {
        int base = 19;
        int hashcode = base * this.tokenStart;
        hashcode = hashcode * base + this.tokenEnd;
        return hashcode * base + this.tokenValue;
    }
}

