/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public class ImportHelper
implements InternalConstants {
    private final FileSym fileSym;
    private final Set importNames;
    private final SourcePreferences preferences;
    private ArrayList<TypeSym> typeSyms = new ArrayList();
    private ArrayList<DotExpr> dotExprs = new ArrayList();
    private ArrayList<DocReferenceSym> docReferenceSyms = new ArrayList();
    private ArrayList<AnnotateSym> annotateSyms = new ArrayList();
    private String addImportName;
    private String simplifiedName;

    public ImportHelper(FileSym fileSym) {
        this.fileSym = fileSym;
        this.importNames = fileSym.getSourceImportNames();
        this.preferences = fileSym.getPreferences();
    }

    public String getSimplifiedName() {
        return this.simplifiedName;
    }

    public String getAddImportName() {
        return this.addImportName;
    }

    public void process() {
        ImportHelperTraversal iht = new ImportHelperTraversal();
        this.processImpl(iht, null, null);
    }

    public void process(Sym subtree) {
        ImportHelperTraversal iht = new ImportHelperTraversal(false);
        this.processImpl(iht, subtree, null);
    }

    public void process(int[][] ranges) {
        ImportHelperTraversal iht = new ImportHelperTraversal(false);
        this.processImpl(iht, null, ranges);
    }

    private void processImpl(ImportHelperTraversal iht, Sym sym, int[][] ranges) {
        if (sym != null) {
            sym.traverseSelf(iht);
        } else {
            this.fileSym.traverseSelf(iht);
        }
        ImportHelper.checkList(this.typeSyms, ranges);
        ImportHelper.checkList(this.dotExprs, ranges);
        ImportHelper.checkList(this.docReferenceSyms, ranges);
        ImportHelper.checkList(this.annotateSyms, ranges);
        this.performAutoImports(this.typeSyms, false);
        this.performAutoImports(this.dotExprs, true);
        this.performAutoImports(this.docReferenceSyms, false);
        this.performAutoImports(this.annotateSyms, false);
    }

    private void performAutoImports(List<? extends Sym> list, boolean checkNullParent) {
        if (!list.isEmpty()) {
            Iterator<? extends Sym> iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Sym sym = iterator.next();
                    if (checkNullParent && sym.getParent() == null) continue;
                    switch (sym.symKind) {
                        case 1: {
                            this.performAutoImport((AnnotateSym)sym);
                            break;
                        }
                        case 74: {
                            this.performAutoImport((DocReferenceSym)sym);
                            break;
                        }
                        case 53: {
                            this.performAutoImport((DotExpr)sym);
                            break;
                        }
                        case 27: {
                            this.performAutoImport((TypeSym)sym);
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    e.printStackTrace();
                }
            }
            list.clear();
        }
    }

    private static void checkList(List<? extends Sym> list, int[][] ranges) {
        if (!list.isEmpty()) {
            Iterator<? extends Sym> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (ImportHelper.isInsideRanges(iterator.next(), ranges)) continue;
                iterator.remove();
            }
        }
    }

    private static boolean isInsideRanges(Sym sym, int[][] ranges) {
        if (ranges == null) {
            return true;
        }
        int start = sym.getStartOffset();
        int end = sym.getEndOffset();
        for (int x = 0; x < ranges.length; ++x) {
            if (start < ranges[x][0] || end > ranges[x][1]) continue;
            return true;
        }
        return false;
    }

    public final void performAutoImport(TypeSym typeSym) {
        this.performAutoImport(typeSym, typeSym.getName());
        if (this.addImportName != null) {
            this.importNames.add(this.addImportName);
        }
        if (this.simplifiedName != null) {
            this.dropPrefix(typeSym, this.simplifiedName);
        }
    }

    public final void performAutoImport(DotExpr dotExpr) {
        String name = dotExpr.getQualifiedName();
        this.performAutoImport(dotExpr, name);
        if (this.addImportName != null) {
            this.importNames.add(this.addImportName);
        }
        if (this.simplifiedName != null) {
            this.dropPrefix(dotExpr, this.simplifiedName);
        }
    }

    public final void performAutoImport(DocReferenceSym docReferenceSym) {
        String name = docReferenceSym.refClassName;
        this.performAutoImport(docReferenceSym, name);
        if (this.addImportName == null && this.simplifiedName != null) {
            this.dropPrefix(docReferenceSym, this.simplifiedName);
        }
    }

    public final void performAutoImport(AnnotateSym annotateSym) {
        this.performAutoImport(annotateSym, annotateSym.getName());
        if (this.addImportName != null) {
            this.importNames.add(this.addImportName);
        }
        if (this.simplifiedName != null) {
            this.dropPrefix(annotateSym, this.simplifiedName);
        }
    }

    public final void performAutoImport(Sym sym, String typeName) {
        JavaType resolvedType;
        JavaType targetType;
        String targetName;
        this.addImportName = null;
        this.simplifiedName = null;
        int typeLastDot = typeName.lastIndexOf(46);
        if (typeLastDot == -1) {
            return;
        }
        String prefix = typeName.substring(0, typeLastDot);
        String importName = targetName = typeName.substring(typeLastDot + 1);
        JavaProvider provider = this.fileSym.getProvider();
        if (provider == null) {
            return;
        }
        CompilerDriver compiler = new CompilerDriver(provider, this.fileSym.getJdkVersion(), false, this.fileSym);
        JavaType prefixResult = compiler.resolveType(sym, prefix);
        if (prefixResult != null) {
            boolean importInnerClassName = this.preferences.getBoolean(64);
            String fullPrefix = prefixResult.getRawName();
            if (!prefix.equals(fullPrefix)) {
                if (!importInnerClassName) {
                    return;
                }
                prefix = fullPrefix;
            } else if (!importInnerClassName) {
                prefix = prefixResult.getPackageName();
                importName = prefixResult.getName();
                for (JavaClass outerClass = prefixResult.getOwningClass(); outerClass != null; outerClass = outerClass.getOwningClass()) {
                    importName = outerClass.getName();
                }
                targetName = typeName.substring(prefix.length() > 0 ? prefix.length() + 1 : 0);
            }
        }
        boolean needsImport = true;
        boolean requiresNarrow = false;
        JavaType result = compiler.resolveType(sym, importName);
        if (result != null) {
            String resultPrefix;
            String resultQualified = result.getRawName();
            int lastDot = resultQualified.lastIndexOf(46);
            String string = resultPrefix = lastDot > -1 ? resultQualified.substring(0, lastDot) : "";
            if (!prefix.equals(resultPrefix)) {
                requiresNarrow = true;
                if (!this.isSafeToAddNarrowImport(importName)) {
                    return;
                }
            } else {
                needsImport = false;
            }
        }
        if ((targetType = compiler.resolveType(sym, targetName)) != null && !targetType.getRawName().equals(typeName)) {
            return;
        }
        if (!(prefixResult != null || result != null || (resolvedType = compiler.resolveType(sym, typeName)) != null && this.isSafeToAddNarrowImport(importName))) {
            return;
        }
        if (needsImport) {
            this.addImportName = prefix + '.' + importName;
        }
        this.simplifiedName = targetName;
    }

    private void dropPrefix(TypeSym sym, String targetName) {
        TypeSym typeSym = sym;
        typeSym.setName(targetName);
    }

    private void dropPrefix(DotExpr sym, String targetName) {
        DotExpr dotExpr = sym;
        FileSym fileSym = dotExpr.symFile;
        SymFactory factory = fileSym.getSymFactory();
        try {
            Expr e = (Expr)factory.createExpression(targetName);
            dotExpr.replaceSelf(e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void dropPrefix(DocReferenceSym sym, String targetName) {
        try {
            DocReferenceSym clone = (DocReferenceSym)sym.cloneSelf(this.fileSym);
            clone.refClassName = targetName;
            sym.replaceSelf(clone);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void dropPrefix(AnnotateSym sym, String targetName) {
        sym.setName(targetName);
    }

    private boolean isSafeToAddNarrowImport(String name) {
        if (name.length() == 0) {
            return false;
        }
        String dotName = "." + name;
        for (String imported : this.importNames) {
            if (!imported.endsWith(dotName)) continue;
            return false;
        }
        SourceClass c = this.fileSym.getSourceClass(name);
        return c == null;
    }

    private class ImportHelperTraversal
    extends Sym.SymTraversal {
        private final boolean onlyNew;

        ImportHelperTraversal() {
            this(true);
        }

        ImportHelperTraversal(boolean onlyNew) {
            this.onlyNew = onlyNew;
        }

        @Override
        protected boolean enter(Sym sym) {
            if (this.onlyNew && (sym.symFormat & 2) == 0) {
                return true;
            }
            if ((sym.symFormat & 0x10) != 0) {
                return true;
            }
            switch (sym.symKind) {
                case 27: {
                    ImportHelper.this.typeSyms.add((TypeSym)sym);
                    break;
                }
                case 53: {
                    DotExpr dotExpr = (DotExpr)sym;
                    if (!dotExpr.isQualifiedName()) break;
                    while (dotExpr != null) {
                        DotExpr e = dotExpr;
                        dotExpr = null;
                        JavaHasType result = e.getResolvedObject();
                        if (result != null && result.getElementKind() == 3) {
                            ImportHelper.this.dotExprs.add(e);
                            continue;
                        }
                        Expr lhs = e.getLhsOperandSym();
                        if (lhs == null || lhs.symKind != 53) continue;
                        dotExpr = (DotExpr)lhs;
                    }
                    break;
                }
                case 74: {
                    DocReferenceSym docReferenceSym = (DocReferenceSym)sym;
                    String className = docReferenceSym.refClassName;
                    if (className == null || className.length() <= 0) break;
                    ImportHelper.this.docReferenceSyms.add(docReferenceSym);
                    break;
                }
                case 1: {
                    ImportHelper.this.annotateSyms.add((AnnotateSym)sym);
                }
            }
            return true;
        }
    }
}

