/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;

public class DocTextFragmentSym
extends DocSym
implements SourceDocTextFragment {
    public static final DocTextFragmentSym[] EMPTY_ARRAY = new DocTextFragmentSym[0];
    public String textString = "";

    @Override
    public String getText() {
        return this.textString;
    }

    @Override
    public boolean isBlank() {
        int length = this.textString.length();
        for (int i = 0; i < length; ++i) {
            char ch = this.textString.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        DocTextFragmentSym sym = (DocTextFragmentSym)super.cloneSelf(targetFile);
        sym.textString = this.textString;
        return sym;
    }

    @Override
    protected void verboseSelf(StringBuilder stringBuffer) {
        stringBuffer.append('\"');
        stringBuffer.append(this.getText().replace('\n', '$').replace('\r', '$'));
        stringBuffer.append('\"');
        if (this.isBlank()) {
            stringBuffer.append(" (blank)");
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

