/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocDescriptionSym;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public class DocSym
extends TreeSym
implements SourceDocElement {
    public DocCommentSym docOwning;
    public int docStart;
    public int docEnd;

    @Override
    public int getStartOffset() {
        if (this.docOwning == this) {
            return super.getStartOffset();
        }
        int docOffset = this.docStart;
        if (this.docOwning == null) {
            return docOffset;
        }
        int owningStart = this.docOwning.getStartOffset();
        if (this.docStart == -1) {
            return owningStart;
        }
        if (owningStart == -1) {
            return docOffset;
        }
        return owningStart + docOffset;
    }

    @Override
    public int getEndOffset() {
        if (this.docOwning == this) {
            return super.getEndOffset();
        }
        int docOffset = this.docEnd;
        if (docOffset == -1) {
            return this.getStartOffset();
        }
        if (this.docOwning == null) {
            return docOffset;
        }
        int owningStart = this.docOwning.getStartOffset();
        if (owningStart == -1) {
            return docOffset;
        }
        return owningStart + docOffset;
    }

    public final boolean flag_newlineEnd() {
        return this.testSymFlag((byte)-128);
    }

    @Override
    public SourceMember getOwningMember() {
        return (SourceMember)((Object)this.getOwningMemberSym());
    }

    @Override
    public SourceDocComment getOwningDocComment() {
        return this.getOwningDocCommentSym();
    }

    public final DocCommentSym getOwningDocCommentSym() {
        return this.docOwning;
    }

    public final SourceDocDescription getDescription() {
        return this.getDescriptionSym();
    }

    public final void setDescription(SourceDocDescription description) {
        this.setDescriptionSym((DocDescriptionSym)description);
    }

    public final DocDescriptionSym getDescriptionSym() {
        return (DocDescriptionSym)this.getChild((byte)72);
    }

    public final void setDescriptionSym(DocDescriptionSym sym) {
        this.setSym((byte)72, sym);
    }

    @Override
    public String getDocText() {
        StringBuilder buffer = new StringBuilder();
        this.appendDocText(buffer);
        return buffer.toString();
    }

    void appendDocText(StringBuilder buffer) {
        List children = this.getChildren();
        if (children.isEmpty() && this.symKind != 71) {
            buffer.append(this.getText());
        } else {
            Iterator i = children.iterator();
            while (i.hasNext()) {
                int length = buffer.length();
                if (length > 0 && !Character.isWhitespace(buffer.charAt(length - 1))) {
                    buffer.append(' ');
                }
                SourceDocElement child = (SourceDocElement)i.next();
                buffer.append(child.getDocText());
            }
        }
    }

    public Collection getInlineTags() {
        return this.getChildrenRecursive((byte)73);
    }

    public Collection getReferences() {
        return this.getChildrenRecursive((byte)74);
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    protected int indexSelf(Sym[] index, int pos, TokenArray tokens) {
        if (this.symKind == 71) {
            return super.indexSelf(index, pos, tokens);
        }
        return pos;
    }

    @Override
    protected Sym cloneSelfImpl(FileSym targetFile) {
        if (this.symKind == 71) {
            return super.cloneSelfImpl(targetFile);
        }
        DocSym sym = SymFactory.createDocElement(null, this.symKind);
        sym.symFile = targetFile;
        return sym;
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        DocSym sym = (DocSym)super.cloneSelf(targetFile);
        sym.docStart = -1;
        sym.docEnd = -1;
        return sym;
    }

    @Override
    protected void adjustSelfImpl(Sym sym) {
        if (sym.isFilter((byte)94)) {
            DocSym docSym = (DocSym)sym;
            this.docStart = docSym.docStart;
            this.docEnd = docSym.docEnd;
        } else {
            this.docStart = -1;
            this.docEnd = -1;
        }
        super.adjustSelfImpl(sym);
    }

    protected final void setOwningRecursive(DocCommentSym sym) {
        if (this.docOwning == sym) {
            return;
        }
        this.docOwning = sym;
        List<Sym> children = this.getTreeChildren(null);
        for (Sym child : children) {
            ((DocSym)child).setOwningRecursive(sym);
        }
    }

    @Override
    public final void hookupChildren() {
        this.setOwningRecursive(this.docOwning);
        super.hookupChildren();
    }

    @Override
    protected final void linkChildTrigger(Sym child, byte filter) {
        DocSym docChild = (DocSym)child;
        docChild.setOwningRecursive(this.docOwning);
        super.linkChildTrigger(child, filter);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

