/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeBinding;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;

public class TypeArgumentSym
extends ObjectSym
implements SourceTypeArgument {
    public byte argBound;

    @Override
    public int getBound() {
        return this.argBound;
    }

    private JavaType getArgResolved() {
        TypeBinding binding = (TypeBinding)this.getInternalBinding(12);
        if (binding != null) {
            return binding.getResolvedType();
        }
        return null;
    }

    private void setArgResolved(JavaType argResolved) {
        TypeBinding binding = new TypeBinding(argResolved);
        this.setInternalBinding(binding);
    }

    @Override
    public JavaElement getCompiledObject() {
        return this.getResolvedType();
    }

    @Override
    public JavaType getResolvedType() {
        JavaType currentArgResolved = this.getArgResolved();
        if (currentArgResolved == null) {
            currentArgResolved = (JavaType)this.resolve();
            this.setArgResolved(currentArgResolved);
        }
        return currentArgResolved;
    }

    @Override
    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "refers to " + resolvedType.getDescriptor();
        }
        return "refers to <unknown>";
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 27: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected synchronized JavaElement resolveImpl(CompilerDriver compiler) {
        JavaType currentArgResolved = this.getArgResolved();
        if (currentArgResolved == null && !this.isProcessed()) {
            currentArgResolved = compiler.resolve(this);
            this.setArgResolved(currentArgResolved);
        }
        return currentArgResolved;
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        TypeArgumentSym sym = (TypeArgumentSym)super.cloneSelf(targetFile);
        sym.argBound = this.argBound;
        return sym;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int ignored) {
        switch (this.argBound) {
            default: {
                out.print('?');
                break;
            }
            case 1: {
                out.print("? extends ");
                TypeArgumentSym.print(this.getTypeSym(), out);
                break;
            }
            case 2: {
                out.print("? super ");
                TypeArgumentSym.print(this.getTypeSym(), out);
                break;
            }
            case 0: {
                TypeArgumentSym.print(this.getTypeSym(), out);
            }
        }
    }
}

