/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.parser;

import java.util.HashSet;
import java.util.Stack;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.internal.parser.ParserLayer1a;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.PlaceholderSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;

abstract class ParserLayer1b
extends ParserLayer1a {
    Sym stackTop;
    Sym[] stack;
    Sym lastPop;
    Sym stackRoot;
    WhitespaceSym lastWhitespace;
    SyntaxData errorData;
    HashSet possibleTypes;
    short stackHeight;
    int lastTokenIndex;
    int errorCount;
    int lastErrorIndex;

    ParserLayer1b() {
    }

    void initializeParserState(FileSym file) {
        this.stackTop = null;
        this.stack = new Sym[4];
        this.stackHeight = 0;
        if (file == null) {
            file = SymFactory.createFile();
        }
        this.symFile = file;
        this.symFile.symStart = 0;
        this.symFile.symData = new SyntaxData();
        this.symFile.setTokenArray(this.tokenArray);
        this.symFile.setJdkVersion(this.jdkVersion);
        this.errorData = new SyntaxData();
        this.errorData.flag_repushed = true;
        this.symFile.parseErrors.treeChildren = Sym.EMPTY_ARRAY;
        this.symFile.parseErrors.symData = this.errorData;
        if (this.textBuffer instanceof TextBuffer) {
            this.symFile.bufferChangeId = ((TextBuffer)this.textBuffer).getChangeId();
        }
        this.possibleTypes = new HashSet();
        this.errorCount = 0;
        this.lastErrorIndex = -1;
        this.lastWhitespace = null;
        this.skipToken();
        this.node((byte)80);
        this.stackRoot = this.stackTop;
        this.stackRoot.symParent = this.symFile;
    }

    final void simple_name() {
        if (this.curToken == 4) {
            this.node((byte)20);
            this.skipToken();
            NameSym nameSym = (NameSym)this.stackTop;
            nameSym.nameString = this.get_name_value();
            this.pop();
        } else if (ParserLayer1b.kw(this.curToken)) {
            this.node((byte)20);
            switch (this.curToken) {
                case 133: 
                case 136: 
                case 141: {
                    break;
                }
                default: {
                    if (ParserLayer1b.primitive(this.curToken)) break;
                    this.errorExpecting((short)4);
                }
            }
            NameSym nameSym = (NameSym)this.stackTop;
            nameSym.nameString = KW_words[this.curToken - 96];
            this.skipToken();
            this.pop();
        } else {
            this.errorExpecting((short)4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Sym expr_name() {
        Sym savedLastPop = this.lastPop;
        try {
            this.node((byte)20);
            this.skipToken();
            NameSym nameSym = (NameSym)this.stackTop;
            SyntaxData data = nameSym.symData;
            data.flag_noProcess = true;
            nameSym.nameString = this.get_name_value();
            this.pop();
            NameSym nameSym2 = nameSym;
            return nameSym2;
        }
        finally {
            this.lastPop = savedLastPop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Sym dummy_name() {
        Sym savedLastPop = this.lastPop;
        try {
            this.node((byte)20);
            NameSym nameSym = (NameSym)this.stackTop;
            SyntaxData data = nameSym.symData;
            data.flag_noProcess = true;
            nameSym.nameString = "";
            this.pop();
            NameSym nameSym2 = nameSym;
            return nameSym2;
        }
        finally {
            this.lastPop = savedLastPop;
        }
    }

    final Sym qualified_name() {
        String nameText;
        this.node((byte)20);
        this.nextToken((short)4);
        if (this.curToken == 43) {
            StringBuilder nameBuffer = new StringBuilder(this.get_name_value());
            while ((this.curToken != 43 || this.lookaheadToken() != 79 || !this.jdkVersion.isJdk8OrAbove()) && this.optionalToken((short)43)) {
                boolean hasIdentifier = this.curToken == 4;
                this.nextToken((short)4);
                nameBuffer.append('.');
                if (!hasIdentifier) continue;
                nameBuffer.append(this.get_name_value());
            }
            nameText = nameBuffer.toString();
        } else {
            nameText = this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = nameText;
        this.pop();
        return this.lastPop;
    }

    final void expr_qualified_name() {
        this.node((byte)20);
        this.nextToken((short)4);
        String nameText = this.get_name_value();
        while (this.curToken == 43 && this.lookaheadToken() == 4) {
            this.nextToken((short)43);
            this.nextToken((short)4);
            nameText = nameText + '.' + this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = nameText;
        this.pop();
    }

    final void import_qualified_name() {
        String nameText;
        this.node((byte)20);
        this.nextToken((short)4);
        if (this.curToken == 43) {
            StringBuilder nameBuffer = new StringBuilder(this.get_name_value());
            while (this.optionalToken((short)43)) {
                if (this.curToken == 63) {
                    this.skipToken();
                    nameBuffer.append(".*");
                    continue;
                }
                this.nextToken((short)4);
                nameBuffer.append('.');
                nameBuffer.append(this.get_name_value());
            }
            nameText = nameBuffer.toString();
        } else {
            nameText = this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = nameText;
        this.pop();
    }

    final void synthetic_name(String text) {
        this.synthetic_node((byte)20);
        NameSym nameSym = (NameSym)this.lastPop;
        nameSym.nameString = text;
        nameSym.buildSelf();
    }

    protected String getTokenValue(int index) {
        int end = this.tokenArray.tokenEnds[index];
        int start = this.tokenArray.tokenStarts[index];
        int length = end - start;
        if (length > 0) {
            return this.textBuffer.getString(start, length);
        }
        return "";
    }

    private String get_name_value() {
        return this.getTokenValue(this.lastTokenIndex);
    }

    private void set_whitespace_value() {
        WhitespaceSym sym = (WhitespaceSym)this.stackTop;
        int index = sym.symStart;
        int end = this.tokenArray.tokenEnds[index];
        int start = this.tokenArray.tokenStarts[index];
        int length = end - start;
        if (length > 0) {
            sym.tokenText = this.textBuffer.getString(start, length);
        }
    }

    final WhitespaceSym getPrecedingWhitespace(Sym sym) {
        SyntaxData data = sym.symData;
        if (data != null) {
            return data.precedingWhitespace;
        }
        return null;
    }

    final void setPrecedingWhitespace(Sym sym, WhitespaceSym preceding) {
        SyntaxData data = sym.symData;
        if (data != null) {
            data.precedingWhitespace = preceding;
        } else {
            this.internalError();
        }
    }

    final void attachWhitespaceChain(WhitespaceSym commentSym, Sym parent) {
        if (parent == null) {
            this.internalError();
        }
        WhitespaceSym currentCommentSym = commentSym;
        Stack<WhitespaceSym> commentSyms = new Stack<WhitespaceSym>();
        while (currentCommentSym != null && currentCommentSym.symData != null) {
            commentSyms.push(currentCommentSym);
            currentCommentSym = this.getPrecedingWhitespace(currentCommentSym);
        }
        while (!commentSyms.empty()) {
            currentCommentSym = (WhitespaceSym)commentSyms.pop();
            currentCommentSym.symParent = parent;
            if (currentCommentSym.symStart < parent.symStart) {
                parent.symStart = currentCommentSym.symStart;
            }
            this.processNode(currentCommentSym);
        }
    }

    final void handleWhitespace(WhitespaceSym whitespaceSym, Sym parent) {
        Sym attachedTo = parent;
        while (attachedTo.symParent != null && attachedTo.symParent.symKind != 80 && whitespaceSym.symStart <= attachedTo.symParent.symStart) {
            attachedTo = attachedTo.symParent;
        }
        Sym owner = attachedTo.symParent != null ? attachedTo.symParent : attachedTo;
        this.attachWhitespaceChain(whitespaceSym, owner);
    }

    private void handleOneWhitespaceToken() {
        boolean isComment;
        boolean bl = isComment = this.curToken != 6;
        if (isComment) {
            this.node((byte)77);
        } else {
            this.node((byte)79);
        }
        SyntaxData data = this.stackTop.symData;
        data.flag_noProcess = true;
        WhitespaceSym sym = (WhitespaceSym)this.stackTop;
        sym.tokenValue = this.curToken;
        if (isComment && this.newlineCount > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0x40);
        }
        super.skipToken();
        if (isComment && this.newlineCount > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0xFFFFFF80);
        }
        this.set_whitespace_value();
        this.pop();
        sym.symEnd = sym.symStart;
        if (this.lastWhitespace != null) {
            this.setPrecedingWhitespace(sym, this.lastWhitespace);
        }
        this.lastWhitespace = sym;
    }

    private void saveBlanklines() {
        while (this.newlineCount > 1) {
            this.node((byte)78);
            WhitespaceSym lexicalSym = (WhitespaceSym)this.stackTop;
            SyntaxData data = this.stackTop.symData;
            data.flag_noProcess = true;
            this.pop();
            lexicalSym.symEnd = lexicalSym.symStart;
            if (this.lastWhitespace != null) {
                this.setPrecedingWhitespace(lexicalSym, this.lastWhitespace);
            }
            this.lastWhitespace = lexicalSym;
            this.newlineCount = (byte)(this.newlineCount - 1);
        }
    }

    @Override
    final void skipToken() {
        this.handleLastWhitespace();
        this.lastTokenIndex = this.lexer.getTokenIndex();
        if (this.lastTokenIndex == -1) {
            this.lastTokenIndex = 0;
        }
        super.skipToken();
        int count = 0;
        block3: while (true) {
            switch (this.curToken) {
                case 6: 
                case 24: 
                case 25: 
                case 26: {
                    this.saveBlanklines();
                    this.handleOneWhitespaceToken();
                    ++count;
                    continue block3;
                }
            }
            break;
        }
        this.saveBlanklines();
    }

    final void handleLastWhitespace() {
        if (this.lastWhitespace != null) {
            if (this.lastWhitespace.symParent == this.stackTop || this.stackTop.symStart < this.lastWhitespace.symStart) {
                this.attachWhitespaceChain(this.lastWhitespace, this.stackTop);
            } else {
                this.handleWhitespace(this.lastWhitespace, this.stackTop);
            }
            this.lastWhitespace = null;
        }
    }

    final void node(byte sy) {
        if (this.flag_frozenlexer) {
            this.internalError();
        }
        Sym sym = SymFactory.createNode(this.symFile, sy);
        sym.symKind = sy;
        if (this.flag_setnew) {
            sym.symFormat = (char)(sym.symFormat | 2);
        }
        this.push(sym);
    }

    final void push(Sym sym) {
        if (this.stack.length == this.stackHeight) {
            Sym[] newStack = new Sym[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        if (sym.symData != null) {
            this.internalError();
        }
        SyntaxData data = new SyntaxData();
        sym.symParent = this.stackTop;
        sym.symStart = this.lexer.getTokenIndex();
        sym.symData = data;
        data.stackDepth = this.stackHeight;
        this.lastPop = null;
        short s = this.stackHeight;
        this.stackHeight = (short)(s + 1);
        this.stack[s] = sym;
        this.stackTop = sym;
    }

    final void pop() {
        boolean empty;
        SyntaxData symData;
        if (this.stackTop != this.stack[this.stackHeight - 1]) {
            this.internalError();
        }
        if ((symData = this.stackTop.symData) == null) {
            this.internalError();
        }
        if (symData.stackDepth != this.stackHeight - 1) {
            this.internalError();
        }
        this.lastPop = this.stackTop;
        if (this.stackHeight == 0) {
            this.internalError();
        }
        this.stackHeight = (short)(this.stackHeight - 1);
        this.stack[this.stackHeight] = null;
        this.stackTop = this.stackHeight == 0 ? null : this.stack[this.stackHeight - 1];
        boolean bl = empty = this.lexer.getTokenIndex() == this.lastPop.symStart && this.lastPop.symKind != 78;
        if (empty && this.lastPop.symKind != 80) {
            this.lastPop = null;
            return;
        }
        this.lastPop.symEnd = this.lastTokenIndex;
        if (!symData.flag_noProcess) {
            this.processNode(this.lastPop);
        }
    }

    final void repush(Sym sym) {
        SyntaxData data;
        if (this.stack.length == this.stackHeight) {
            Sym[] newStack = new Sym[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        if (sym.symData != null) {
            this.internalError();
        }
        sym.symData = data = new SyntaxData();
        data.stackDepth = this.stackHeight;
        data.flag_repushed = true;
        this.lastPop = null;
        short s = this.stackHeight;
        this.stackHeight = (short)(s + 1);
        this.stack[s] = sym;
        this.stackTop = sym;
    }

    final void processNode(Sym sym) {
        try {
            SyntaxData data = sym.symData;
            boolean repushed = false;
            if (data != null) {
                repushed = data.flag_repushed;
            }
            sym.buildSelf();
            sym.symData = null;
            Sym parent = sym.symParent;
            if (parent != null && !repushed && sym.symKind != 0) {
                SyntaxData parentData = parent.symData;
                parentData.addKid(sym);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.error(27);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            this.error(27);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            this.error(27);
        }
    }

    final void synthetic_node(byte sy) {
        if (this.flag_frozenlexer) {
            this.internalError();
        }
        Sym sym = SymFactory.createNode(this.symFile, sy);
        sym.symKind = sy;
        if (this.flag_setnew) {
            sym.symFormat = (char)(sym.symFormat | 2);
        }
        sym.symParent = this.stackTop;
        sym.symStart = this.lexer.getTokenIndex();
        SyntaxData symData = this.stackTop.symData;
        if (symData == null) {
            this.internalError();
        }
        if (symData.stackDepth != this.stackHeight - 1) {
            this.internalError();
        }
        sym.symEnd = sym.symStart;
        Sym parent = this.stackTop;
        if (this.stackTop != null) {
            SyntaxData parentData = parent.symData;
            parentData.addKid(sym);
        }
        this.lastPop = sym;
    }

    final void swapChildren(Sym one, Sym two) {
        int i;
        SyntaxData oneData = one.symData;
        SyntaxData twoData = two.symData;
        if (oneData == null || twoData == null) {
            this.internalError();
        }
        Sym[] tmp = oneData.kids;
        int tmpCount = oneData.kidCount;
        oneData.kids = twoData.kids;
        oneData.kidCount = twoData.kidCount;
        twoData.kids = tmp;
        twoData.kidCount = tmpCount;
        for (i = 0; i < oneData.kidCount; ++i) {
            oneData.kids[i].symParent = one;
        }
        for (i = 0; i < twoData.kidCount; ++i) {
            twoData.kids[i].symParent = two;
        }
    }

    @Override
    void notImplementedYet(String message) {
        this.error(3, new String[]{message});
    }

    @Override
    void internalError() {
        String message = ParserLayer1b.error2message(2);
        this.error(2, null);
        ParserLayer1b.panic(message);
    }

    @Override
    void error(int code) {
        switch (code) {
            case 16: 
            case 20: {
                ClassSym classSym = this.stackTop instanceof ClassSym ? (ClassSym)this.stackTop : this.stackTop.getOwningClassSym();
                if (classSym != null) {
                    int tykind = classSym.getTypeKind();
                    ErrorSym sym = this.error(code, new String[]{TY_words[tykind]});
                    if (sym == null) break;
                    sym.errorIntData0 = tykind;
                    break;
                }
                this.error(code, null);
                break;
            }
            case 29: {
                this.error(29, new String[]{ParserLayer1b.tokenToString(this.curToken)});
                break;
            }
            default: {
                this.error(code, null);
            }
        }
    }

    ErrorSym error(int code, String[] errorMessageArguments) {
        return this.error(code, errorMessageArguments, this.curToken, this.lexer.getTokenIndex());
    }

    ErrorSym error(int code, String[] errorMessageArguments, short errorToken, int errorTokenIndex) {
        if (this.flag_frozenlexer && code != 2) {
            this.internalError();
        }
        if (this.errorCount++ < 32 && this.lastErrorIndex != errorTokenIndex) {
            String prefix;
            ErrorSym error = (ErrorSym)SymFactory.createNode(this.symFile, 8);
            error.symParent = this.symFile.parseErrors;
            error.symFile = this.symFile;
            error.symKind = (byte)8;
            error.symStart = errorTokenIndex;
            error.symEnd = errorTokenIndex;
            error.errorCode = (short)code;
            error.errorToken = errorToken;
            if (errorMessageArguments != null && errorMessageArguments.length == 2 && code >= 4 && code < 12) {
                try {
                    error.setStartOffset(Integer.decode(errorMessageArguments[0]));
                    error.setEndOffset(Integer.decode(errorMessageArguments[1]));
                }
                catch (NumberFormatException ex) {
                    assert (false) : "Invalid offset for literal error";
                    error.setStartOffset(-1);
                    error.setEndOffset(-1);
                }
            } else {
                error.setErrorMessageArguments(errorMessageArguments);
            }
            Sym errorSymbol = this.stackTop;
            while (errorSymbol != null && (errorSymbol instanceof PlaceholderSym || errorSymbol.symKind == 81)) {
                errorSymbol = errorSymbol.symParent;
            }
            byte symKind = this.stackTop.symKind;
            if (1 <= symKind && symKind < 80 && (prefix = ParserLayer1b.symbolToString(this.stackTop.symKind)).trim().length() > 0) {
                error.setErrorMessagePrefix(prefix + ": ");
            }
            error.buildSelf();
            this.errorData.addKid(error);
            this.lastErrorIndex = errorTokenIndex;
            return error;
        }
        return null;
    }

    @Override
    void errorExpecting(short a) {
        ErrorSym sym = this.error(14, new String[]{ParserLayer1b.tokenToString(a)});
        if (sym != null) {
            sym.errorIntData0 = a;
        }
    }

    @Override
    void errorExpecting(short a, short b) {
        ErrorSym sym = this.error(15, new String[]{ParserLayer1b.tokenToString(a), ParserLayer1b.tokenToString(b)});
        if (sym != null) {
            if (b < a) {
                short tmp = a;
                a = b;
                b = tmp;
            }
            sym.errorIntData0 = a;
            sym.errorIntData1 = b;
        }
    }

    private static String symbolToString(byte sy) {
        String word = SRC_words[sy - 1];
        if (word.length() == 0) {
            return word;
        }
        char ch = word.charAt(0);
        if (!Character.isLetter(ch)) {
            return word;
        }
        return Character.toUpperCase(ch) + word.substring(1);
    }

    protected static String tokenToString(short token) {
        if (32 <= token && token < 83) {
            return OP_words[token - 32];
        }
        if (96 <= token && token < 146) {
            return KW_words[token - 96];
        }
        switch (token) {
            case 4: {
                return "identifier";
            }
            case 0: {
                return "EOF";
            }
            case 6: {
                return "#sql clause";
            }
            case 8: {
                return "integer literal";
            }
            case 10: {
                return "floating-point literal";
            }
            case 12: {
                return "boolean literal";
            }
            case 13: {
                return "character literal";
            }
            case 14: {
                return "string literal";
            }
            case 15: {
                return "null";
            }
            case 24: {
                return "single-line comment";
            }
            case 25: {
                return "multi-line comment";
            }
            case 26: {
                return "javadoc comment";
            }
        }
        return "unknown token";
    }
}

