/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.Parameterization;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.WrapperLocalVariable;
import oracle.javatools.parser.java.v2.common.WrapperMethod;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

final class ParameterizedMethod
extends WrapperMethod {
    final Parameterization params;
    private JavaType type = null;
    private Collection parameters = null;
    private Collection exceptions = null;

    ParameterizedMethod(JavaProvider provider, JavaMethod baseMethod, JavaType[] arguments) {
        super(baseMethod);
        this.params = new Parameterization(provider, baseMethod, arguments);
    }

    @Override
    public boolean hasActualTypeArguments() {
        return this.params.boundArguments.length > 0;
    }

    @Override
    public Collection getActualTypeArguments() {
        if (this.params.boundArguments.length == 0) {
            return kEmptyCollection;
        }
        return Arrays.asList(this.params.boundArguments);
    }

    @Override
    public JavaType getResolvedType() {
        if (this.type == null) {
            this.type = this.params.bindNoWildcard(this.thing.getResolvedType());
            if (this.type == null) {
                this.type = PrimitiveType.getVoidType();
            }
        }
        return this.type;
    }

    @Override
    public JavaType getReturnType() {
        return this.getResolvedType();
    }

    @Override
    public Collection getParameters() {
        if (this.parameters == null) {
            Collection<JavaVariable> thingParameters = this.thing.getParameters();
            if (thingParameters.isEmpty()) {
                this.parameters = thingParameters;
            } else {
                BoundParameter[] array = new BoundParameter[thingParameters.size()];
                Iterator<JavaVariable> iterator = thingParameters.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaLocalVariable parameter = (JavaLocalVariable)iterator.next();
                    array[i++] = new BoundParameter(parameter);
                }
                this.parameters = Arrays.asList(array);
            }
        }
        return this.parameters;
    }

    @Override
    public Collection getExceptions() {
        if (this.exceptions == null) {
            this.exceptions = this.params.bind(this.thing.getExceptions());
        }
        return this.exceptions;
    }

    @Override
    public String getDescriptor() {
        return this.thing.getDescriptor();
    }

    @Override
    public String getTypeSignature() {
        return this.thing.getTypeSignature();
    }

    @Override
    public JavaMethod getMethodErasure() {
        return this.thing;
    }

    private class BoundParameter
    extends WrapperLocalVariable {
        private JavaType type;

        private BoundParameter(JavaLocalVariable thing) {
            super(thing);
            this.type = null;
        }

        @Override
        public JavaType getResolvedType() {
            if (this.type == null) {
                this.type = ParameterizedMethod.this.params.bind(this.thing.getResolvedType());
            }
            return this.type;
        }

        @Override
        public JavaElement getOwner() {
            return ParameterizedMethod.this;
        }

        @Override
        public JavaLocalVariable getLocalVariableErasure() {
            return this.thing;
        }
    }
}

