/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.common.ArrayType;
import oracle.javatools.parser.java.v2.common.IntersectionType;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.common.ParameterizedMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickSignatureParser;
import oracle.javatools.parser.java.v2.common.SignatureHasType;
import oracle.javatools.parser.java.v2.common.TypeErasedClass;
import oracle.javatools.parser.java.v2.common.WildcardType;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaClass;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaType;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaTypeVariable;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaWildcardType;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedPrimitiveType;
import oracle.javatools.parser.java.v2.internal.model.WrappedJavaType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceToken;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewArrayExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceAssertStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.util.BindingContext;
import oracle.javatools.parser.java.v2.util.Conversions;
import oracle.javatools.parser.java.v2.util.SourceVisitor;
import oracle.javatools.util.JavaHasNameSet;

public class CommonUtilities
extends Conversions
implements JavaConstants {
    private static byte OPTYPE_ASSIGNMENT = 0;
    private static byte OPTYPE_RELATIONAL = 1;
    private static byte OPTYPE_SHIFT = (byte)2;
    private static byte OPTYPE_INFIX = (byte)3;
    private static byte OPTYPE_PREFIX = (byte)4;
    private static byte OPTYPE_POSTFIX = (byte)5;
    private static byte OPTYPE_max = (byte)6;
    private static byte[][] op2optTable = new byte[OPTYPE_max][51];
    private static Map<String, Short> keywordToToken;
    private static Set<String> reservedLiterals;

    public static byte provider2jdkVersion(JavaProvider provider) {
        if (CommonUtilities.isClassPresent(provider, "java/lang/annotation/Repeatable") || CommonUtilities.isClassPresent(provider, "java/util/function/Function")) {
            if (CommonUtilities.isClassPresent(provider, "javax/swing/text/html/ResourceLoader") && CommonUtilities.isClassPresent(provider, "javax/swing/text/html/parser/ResourceLoader")) {
                return 6;
            }
            return 7;
        }
        if (CommonUtilities.isClassPresent(provider, "java/lang/AutoCloseable")) {
            return 5;
        }
        if (CommonUtilities.isClassPresent(provider, "java/util/Deque") || CommonUtilities.isClassPresent(provider, "java/util/ServiceLoader")) {
            return 4;
        }
        if (CommonUtilities.isClassPresent(provider, "java/lang/Enum") || CommonUtilities.isClassPresent(provider, "java/lang/annotation/Annotation")) {
            return 3;
        }
        return 2;
    }

    private static boolean isClassPresent(JavaProvider provider, String vmName) {
        return provider.getClassByVMName(vmName) != null;
    }

    public static boolean isInGuardedSection(SourceElement sourceElement) {
        TextBuffer buffer;
        SourceFile sourceFile;
        if (sourceElement == null) {
            throw new IllegalArgumentException("Null argument");
        }
        int startOffset = sourceElement.getStartOffset();
        int endOffset = sourceElement.getEndOffset();
        if (startOffset >= 0 && endOffset > startOffset && (sourceFile = sourceElement.getOwningSourceFile()) != null && (buffer = sourceFile.getTextBuffer()) instanceof GuardedTextBuffer) {
            int count = endOffset - startOffset;
            return ((GuardedTextBuffer)buffer).isOffsetRangeGuarded(startOffset, count);
        }
        return false;
    }

    public static PrimitiveType getPrimitiveType(String name) {
        return PrimitiveType.lookupPrimitive(name);
    }

    public static JavaType createArrayType(JavaProvider provider, JavaType component, int dimensions) {
        return CommonUtilities.createArrayType(provider, component, dimensions, null);
    }

    public static JavaType createArrayType(JavaProvider provider, JavaType component, int dimensions, List<List<JavaAnnotation>> typeAnnotations) {
        if (component == null) {
            return null;
        }
        if (dimensions == 0) {
            return component;
        }
        if (dimensions < 0) {
            throw new IllegalArgumentException("Negative dimensions");
        }
        if (typeAnnotations != null && !typeAnnotations.isEmpty() && typeAnnotations.size() != dimensions) {
            throw new IllegalArgumentException("Dimensions and typeAnnotations.size() don't match");
        }
        JavaType out = component;
        for (int i = 0; i < dimensions; ++i) {
            out = new ArrayType(provider, out);
            if (typeAnnotations == null || typeAnnotations.isEmpty()) continue;
            ((ArrayType)out).setTypeAnnotations(typeAnnotations.get(dimensions - 1 - i));
        }
        return out;
    }

    public static JavaType createTypeErasedClass(JavaProvider provider, JavaType type) {
        return new TypeErasedClass(provider, type);
    }

    public static JavaType createParameterizedType(JavaProvider provider, JavaType generic, JavaType[] typeArguments) {
        int argumentCount;
        if (!CommonUtilities.allowsParameterization(generic)) {
            return generic;
        }
        Collection<JavaTypeVariable> parameters = generic.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount != (argumentCount = typeArguments.length)) {
            String message = "Arguments mismatch: " + generic.getQualifiedName();
            throw new IllegalArgumentException(message);
        }
        try {
            JavaClass genericClass = (JavaClass)generic;
            return new ParameterizedClass(provider, genericClass, typeArguments);
        }
        catch (ClassCastException e) {
            return generic;
        }
    }

    private static boolean allowsParameterization(JavaType type) {
        if (type == null || type.getElementKind() != 3) {
            return false;
        }
        return type.getTypeParameters().size() > 0;
    }

    public static JavaType createDiamondParameterizedType(JavaProvider provider, JavaType type) {
        try {
            JavaClass genericClass = (JavaClass)type;
            return new ParameterizedClass(provider, genericClass, new JavaType[0]);
        }
        catch (ClassCastException e) {
            return type;
        }
    }

    public static JavaType createAnnotatedJavaType(JavaType javaType, List<JavaAnnotation> annotations) {
        switch (javaType.getElementKind()) {
            case 3: {
                if (javaType.isPrimitive()) {
                    javaType = new AnnotatedPrimitiveType(((PrimitiveType)javaType).primCode, annotations);
                    break;
                }
                if (javaType instanceof AnnotatedJavaType) {
                    ((AnnotatedJavaType)((Object)javaType)).setTypeAnnotations(annotations);
                    break;
                }
                javaType = new AnnotatedJavaClass((JavaClass)javaType, annotations);
                break;
            }
            case 10: {
                javaType = new AnnotatedJavaTypeVariable((JavaTypeVariable)javaType, annotations);
                break;
            }
            case 11: {
                javaType = new AnnotatedJavaWildcardType((JavaWildcardType)javaType, annotations);
                break;
            }
            default: {
                javaType = new WrappedJavaType(javaType, annotations);
            }
        }
        return javaType;
    }

    public static JavaMethod createParameterizedMethod(JavaProvider provider, JavaMethod generic, JavaType[] typeArguments) {
        Collection<JavaTypeVariable> parameters = generic.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount == 0) {
            throw new IllegalArgumentException("Not a generic type");
        }
        int argumentCount = typeArguments.length;
        if (parameterCount != argumentCount) {
            throw new IllegalArgumentException("Arguments mismatch");
        }
        return new ParameterizedMethod(provider, generic, typeArguments);
    }

    public static JavaType createWildcardType(byte bound, JavaType t, JavaProvider provider) {
        switch (bound) {
            case 0: {
                return t;
            }
            case 2: {
                if (t != null) {
                    return new WildcardType(null, t, provider);
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                return new WildcardType(t, null, provider);
            }
            case 3: {
                if (t != null) break;
                return new WildcardType(null, null, provider);
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isFunctionalInterface(JavaType javaType) {
        return CommonUtilities.getFunctionalInterfaceMethod(javaType) != null;
    }

    public static boolean isMarkerInterface(JavaType javaType) {
        if (javaType == null || !javaType.isInterface()) {
            return false;
        }
        List<JavaType> hierarchy = CommonUtilities.getClassHierarchy(javaType);
        hierarchy.add(javaType);
        for (JavaType type : hierarchy) {
            if (type == null || !type.isInterface()) continue;
            Collection<JavaMethod> methods = type.getDeclaredMethods();
            for (JavaMethod method : methods) {
                if (method.isSynthetic()) continue;
                return false;
            }
            if (type.getDeclaredFields().size() > 0) {
                return false;
            }
            if (type.getDeclaredClasses().size() <= 0) continue;
            return false;
        }
        return true;
    }

    private static JavaMethod getFunctionalInterfaceMethod(IntersectionType intersectionType) {
        JavaType sam = null;
        for (JavaType type : intersectionType.getTypes()) {
            if (CommonUtilities.isFunctionalInterface(type)) {
                if (sam != null) {
                    return null;
                }
                sam = type;
                continue;
            }
            if (CommonUtilities.isMarkerInterface(type)) continue;
            return null;
        }
        return CommonUtilities.getFunctionalInterfaceMethod(sam);
    }

    public static JavaMethod getFunctionalInterfaceMethod(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        if (javaType.getElementKind() == 12) {
            return CommonUtilities.getFunctionalInterfaceMethod((IntersectionType)javaType);
        }
        if (!javaType.isInterface()) {
            return null;
        }
        ArrayList<JavaMethod> foundMethods = new ArrayList<JavaMethod>();
        String foundName = null;
        ArrayList<JavaMethod> methodsToSkip = new ArrayList<JavaMethod>();
        Collection<JavaMethod> methods = javaType.getMethods();
        String[] objectMethodDescriptors = new String[]{"getClass()Ljava/lang/Class;", "hashCode()I", "equals(Ljava/lang/Object;)Z", "toString()Ljava/lang/String;", "notify()V", "notifyAll()V", "wait(J)V", "wait(JI)V", "wait()V"};
        block0: for (JavaMethod method : methods) {
            if (methodsToSkip.contains(method)) continue;
            if (!method.isAbstract()) {
                methodsToSkip.addAll(method.getOverriddenMethods());
                continue;
            }
            String nameDescriptor = method.getName() + method.getDescriptor();
            for (int x = 0; x < objectMethodDescriptors.length; ++x) {
                if (nameDescriptor.equals(objectMethodDescriptors[x])) continue block0;
            }
            String methodName = method.getName();
            if (foundName == null) {
                foundName = methodName;
            } else if (!foundName.equals(methodName)) {
                return null;
            }
            foundMethods.add(method);
        }
        if (foundMethods.isEmpty()) {
            return null;
        }
        JavaMethod foundMethod = (JavaMethod)foundMethods.get(0);
        for (int x = 1; x < foundMethods.size(); ++x) {
            JavaMethod otherMethod = (JavaMethod)foundMethods.get(x);
            if (CommonUtilities.isFunctionallyEquivalent(foundMethod, otherMethod)) continue;
            if (CommonUtilities.isFunctionallyEquivalent(otherMethod, foundMethod)) {
                foundMethod = otherMethod;
                continue;
            }
            return null;
        }
        return foundMethod;
    }

    private static boolean isFunctionallyEquivalent(JavaMethod subject, JavaMethod target) {
        return Conversions.hasSubsignatureOf(subject, target) && Conversions.isReturnTypeSubstitutable(subject, target);
    }

    public static Collection<JavaType> getTargetType(SourceExpression expression, Collection<JavaType> exceptions) {
        SourceElement parent = expression.getParent();
        switch (parent.getSymbolKind()) {
            case 7: 
            case 10: 
            case 17: {
                return CommonUtilities.singletonOrEmptyList(((SourceVariable)parent).getResolvedType());
            }
            case 32: {
                SourceAssertStatement asser = (SourceAssertStatement)parent;
                if (expression == asser.getExpression()) {
                    return CommonUtilities.singletonOrEmptyList(CommonUtilities.getPrimitiveType("boolean"));
                }
                return Collections.emptyList();
            }
            case 37: 
            case 43: 
            case 49: {
                return CommonUtilities.singletonOrEmptyList(CommonUtilities.getPrimitiveType("boolean"));
            }
            case 42: {
                SourceForStatement loop = (SourceForStatement)parent;
                if (expression == loop.getForConditional()) {
                    return CommonUtilities.singletonOrEmptyList(CommonUtilities.getPrimitiveType("boolean"));
                }
                return Collections.emptyList();
            }
            case 44: {
                SourceMethod method = CommonUtilities.getEnclosingMethod(parent);
                if (method != null) {
                    JavaType type = method.getReturnType();
                    if (type == null || "void".equals(type.getName())) {
                        return Collections.emptyList();
                    }
                    return CommonUtilities.singletonOrEmptyList(type);
                }
                return Collections.emptyList();
            }
            case 47: {
                return exceptions != null ? exceptions : CommonUtilities.getHandledExceptions(parent);
            }
            case 52: {
                SourceAssignmentExpression assignment = (SourceAssignmentExpression)parent;
                SourceExpression lhs = assignment.getFirstOperand();
                if (expression == lhs) {
                    Collection<JavaType> expectedTypes = CommonUtilities.getTargetType(assignment, exceptions);
                    if (expectedTypes.isEmpty()) {
                        expectedTypes = CommonUtilities.singletonOrEmptyList(assignment.getSecondOperand().getResolvedType());
                    }
                    return expectedTypes;
                }
                JavaType type = lhs.getResolvedType();
                if (type != null) {
                    SourceAssignmentExpression assignExprRhs;
                    SourceExpression secondOperand;
                    SourceExpression rhs = expression;
                    if (rhs.getSymbolKind() == 52 && (secondOperand = (assignExprRhs = (SourceAssignmentExpression)rhs).getSecondOperand()) != null) {
                        rhs = secondOperand;
                    }
                    if (rhs.getSymbolKind() != 55 && rhs.getSymbolKind() != 58 && type.isArray()) {
                        SourceElement greatGrandParent;
                        SourceElement grandParent = parent.getParent();
                        SourceElement sourceElement = greatGrandParent = grandParent == null ? null : grandParent.getParent();
                        if (greatGrandParent != null && greatGrandParent.getSymbolKind() == 1 && grandParent.getSymbolKind() == 55) {
                            type = type.getComponentType();
                        }
                    }
                }
                return CommonUtilities.singletonOrEmptyList(type);
            }
            case 53: {
                SourceDotExpression dotExpression = (SourceDotExpression)parent;
                SourceExpression lhs = dotExpression.getLhsOperand();
                if (expression == lhs) {
                    return CommonUtilities.singletonOrEmptyList(lhs.getResolvedType());
                }
                return CommonUtilities.getTargetType((SourceExpression)parent, exceptions);
            }
            case 54: {
                SourceInfixExpression infix = (SourceInfixExpression)parent;
                switch (infix.getOperatorCode()) {
                    case 20: {
                        SourceExpression other = expression == infix.getFirstOperand() ? infix.getSecondOperand() : infix.getFirstOperand();
                        if (other.getText().equals("null")) {
                            return Collections.emptyList();
                        }
                        return CommonUtilities.singletonOrEmptyList(other.getResolvedType());
                    }
                }
                return Collections.emptyList();
            }
            case 55: {
                SourceListExpression list = (SourceListExpression)parent;
                int index = list.getOperands().indexOf(expression);
                if (index < 0) {
                    return Collections.emptyList();
                }
                SourceElement grandParent = parent.getParent();
                switch (grandParent.getSymbolKind()) {
                    case 7: {
                        return CommonUtilities.getExpectedTypesFromConstructors(((SourceEnumConstant)grandParent).getResolvedType(), index);
                    }
                    case 57: {
                        SourceMethodCallExpression invocation = (SourceMethodCallExpression)grandParent;
                        if (CommonUtilities.isMethodReferenceOrLambda(expression)) {
                            return CommonUtilities.getFunctionalInterfaceTargetTypes(invocation, index);
                        }
                        JavaMethod method = invocation.getResolvedMethod();
                        if (method != null) {
                            JavaType[] parameterTypes = method.getParameterTypes();
                            if (index < parameterTypes.length && parameterTypes[index] != null) {
                                JavaType type = new BindingContext(expression.getOwningSourceFile().getProvider(), method, CommonUtilities.getTargetContext(invocation)).bind(parameterTypes[index]);
                                return CommonUtilities.singletonOrEmptyList(type);
                            }
                            return Collections.emptyList();
                        }
                        return Collections.emptyList();
                    }
                    case 59: {
                        SourceNewClassExpression invocation = (SourceNewClassExpression)grandParent;
                        if (CommonUtilities.isMethodReferenceOrLambda(expression)) {
                            return CommonUtilities.getFunctionalInterfaceTargetTypes(invocation, index);
                        }
                        JavaMethod method = invocation.getResolvedMethod();
                        if (method != null) {
                            JavaType[] parameterTypes = method.getParameterTypes();
                            if (index < parameterTypes.length && parameterTypes[index] != null) {
                                JavaType type = new BindingContext(expression.getOwningSourceFile().getProvider(), method, CommonUtilities.getTargetContext(invocation)).bind(parameterTypes[index]);
                                return CommonUtilities.singletonOrEmptyList(type);
                            }
                            return Collections.emptyList();
                        }
                        return CommonUtilities.getExpectedTypesFromConstructors(invocation.getResolvedType(), index);
                    }
                    case 1: {
                        JavaMethod method;
                        SourceAnnotation annotation = (SourceAnnotation)grandParent;
                        JavaType annotationType = annotation.getAnnotationType();
                        if (annotationType == null) {
                            return Collections.emptyList();
                        }
                        Collection<JavaMethod> methods = annotationType.getDeclaredMethods();
                        JavaType targetType = null;
                        if (annotation.getArgumentCount() == 1 && methods.size() == 1 && "value".equals((method = methods.iterator().next()).getName()) && (targetType = method.getReturnType()) != null) {
                            SourceAssignmentExpression assignExprRhs;
                            SourceExpression secondOperand;
                            SourceExpression rhs = expression;
                            if (rhs.getSymbolKind() == 52 && (secondOperand = (assignExprRhs = (SourceAssignmentExpression)rhs).getSecondOperand()) != null) {
                                rhs = secondOperand;
                            }
                            if (rhs.getSymbolKind() != 55 && rhs.getSymbolKind() != 58 && targetType.isArray()) {
                                targetType = targetType.getComponentType();
                            }
                        }
                        return CommonUtilities.singletonOrEmptyList(targetType);
                    }
                    case 42: {
                        return Collections.emptyList();
                    }
                    case 58: {
                        JavaType javaType = ((SourceNewArrayExpression)grandParent).getResolvedType();
                        if (javaType != null && javaType.isArray()) {
                            return CommonUtilities.singletonOrEmptyList(javaType.getComponentType());
                        }
                        return CommonUtilities.singletonOrEmptyList(javaType);
                    }
                }
                if (list.getStartOffset() >= 0 && '{' == list.getOwningSourceFile().getTextBuffer().getChar(list.getStartOffset())) {
                    Collection<JavaType> arrayTypes = CommonUtilities.getTargetType(list, exceptions);
                    if (arrayTypes.isEmpty()) {
                        return arrayTypes;
                    }
                    ArrayList<JavaType> types = new ArrayList<JavaType>(arrayTypes.size());
                    for (JavaType arrayType : arrayTypes) {
                        if (!arrayType.isArray()) continue;
                        types.add(arrayType.getComponentType());
                    }
                    return types;
                }
                return Collections.emptyList();
            }
            case 57: 
            case 59: {
                SourceInvokeExpression invocation = (SourceInvokeExpression)parent;
                JavaMethod method = invocation.getResolvedMethod();
                SourceExpression lhs = invocation.getLhsOperand();
                if (expression == lhs) {
                    if (method != null) {
                        Collection<JavaMethod> methods = method.getOverriddenMethods();
                        if (!methods.isEmpty()) {
                            method = methods.iterator().next();
                        }
                        return Collections.singletonList(method.getOwningClass());
                    }
                    return Collections.emptyList();
                }
                return Collections.emptyList();
            }
            case 60: {
                JavaType otherType;
                SourceQuestionExpression question = (SourceQuestionExpression)parent;
                if (expression == question.getFirstOperand()) {
                    return Collections.singletonList(CommonUtilities.getPrimitiveType("boolean"));
                }
                SourceExpression other = null;
                if (expression == question.getSecondOperand()) {
                    other = question.getThirdOperand();
                } else if (expression == question.getThirdOperand()) {
                    other = question.getSecondOperand();
                }
                if (other != null && (otherType = other.getResolvedType()) != null) {
                    return Collections.singletonList(otherType);
                }
                return CommonUtilities.getTargetType(question, exceptions);
            }
            case 63: {
                SourceExpression lhs = ((SourceTypecastExpression)parent).getOperandAt(0);
                return CommonUtilities.singletonOrEmptyList(lhs != null ? lhs.getResolvedType() : null);
            }
            case 64: {
                return CommonUtilities.getTargetType((SourceExpression)parent, exceptions);
            }
            case 65: {
                return CommonUtilities.getTargetType((SourceExpression)parent, exceptions);
            }
            case 67: {
                JavaMethod targetMethod = ((SourceLambdaExpression)parent).getTargetMethod();
                if (targetMethod != null) {
                    return CommonUtilities.singletonOrEmptyList(targetMethod.getResolvedType());
                }
                return Collections.emptyList();
            }
            case 58: {
                if (expression.getExpressionCode() == 5) {
                    return CommonUtilities.singletonOrEmptyList(((SourceNewArrayExpression)parent).getResolvedType());
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private static boolean isMethodReferenceOrLambda(SourceExpression expression) {
        while (expression != null && expression.getSymbolKind() == 65) {
            expression = expression.getFirstOperand();
        }
        return expression != null && (expression.getSymbolKind() == 66 || expression.getSymbolKind() == 67);
    }

    private static List<JavaType> getFunctionalInterfaceTargetTypes(SourceInvokeExpression invocation, int index) {
        JavaType[] typeArgumentTypes;
        String name;
        ArrayList<JavaType> classes;
        ArrayList<JavaType> targets;
        block15: {
            block14: {
                targets = new ArrayList<JavaType>();
                classes = new ArrayList<JavaType>();
                name = null;
                if (invocation.getSymbolKind() != 59) break block14;
                SourceNewClassExpression creator = (SourceNewClassExpression)invocation;
                JavaType creatorResolvedType = creator.getResolvedType();
                if (creatorResolvedType == null) break block15;
                if (creatorResolvedType.isAnonymousClass()) {
                    creatorResolvedType = creatorResolvedType.getSuperclass();
                }
                if (creatorResolvedType == null) break block15;
                classes.add(creatorResolvedType);
                break block15;
            }
            name = ((SourceMethodCallExpression)invocation).getName();
            if (name == null) {
                return targets;
            }
            SourceExpression expression = invocation.getLhsOperand();
            if (expression != null) {
                JavaType lhsType = expression.getResolvedType();
                if (lhsType != null) {
                    classes.add(lhsType);
                }
            } else {
                SourceClass cls = CommonUtilities.getEnclosingType(invocation);
                while (cls != null) {
                    classes.add(cls);
                    cls = CommonUtilities.getEnclosingType(cls);
                }
            }
        }
        if (invocation.isGeneric()) {
            List<SourceTypeArgument> typeArguments = invocation.getTypeArguments();
            typeArgumentTypes = new JavaType[typeArguments.size()];
            for (int x = 0; x < typeArguments.size(); ++x) {
                typeArgumentTypes[x] = typeArguments.get(x).getResolvedType();
                if (typeArgumentTypes[x] != null) continue;
                typeArgumentTypes = new JavaType[]{};
                break;
            }
        } else {
            typeArgumentTypes = new JavaType[]{};
        }
        for (int x = 0; x < classes.size(); ++x) {
            Collection<JavaMethod> methods = invocation.getSymbolKind() == 59 ? ((JavaType)classes.get(x)).getDeclaredConstructors() : ((JavaType)classes.get(x)).getMethods(name);
            for (JavaMethod lhsMethod : methods) {
                JavaType[] parameterTypes;
                if (typeArgumentTypes.length > 0) {
                    if (lhsMethod.getTypeParameters().size() != typeArgumentTypes.length) continue;
                    if (invocation.getOwningSourceFile() != null) {
                        lhsMethod = CommonUtilities.createParameterizedMethod(invocation.getOwningSourceFile().getProvider(), lhsMethod, typeArgumentTypes);
                    }
                }
                if (index >= (parameterTypes = lhsMethod.getParameterTypes()).length || CommonUtilities.getFunctionalInterfaceMethod(parameterTypes[index]) == null || targets.contains(parameterTypes[index])) continue;
                targets.add(parameterTypes[index]);
            }
        }
        return targets;
    }

    private static Collection<JavaType> getExpectedTypesFromConstructors(JavaType type, int index) {
        if (type == null) {
            return Collections.emptyList();
        }
        HashSet<JavaType> types = new HashSet<JavaType>();
        for (JavaMethod constructor : (List)type.getDeclaredConstructors()) {
            JavaType[] parameters = constructor.getParameterTypes();
            if (parameters.length <= index || parameters[index] == null) continue;
            types.add(parameters[index]);
        }
        return types;
    }

    private static JavaType getTargetContext(SourceInvokeExpression methodCall) {
        SourceExpression lhs;
        JavaType searchType = methodCall instanceof SourceNewClassExpression ? methodCall.getResolvedType() : ((lhs = methodCall.getLhsOperand()) != null ? lhs.getResolvedType() : CommonUtilities.getEnclosingType(methodCall));
        return searchType;
    }

    public static SourceClass getEnclosingType(SourceElement sourceElement) {
        for (SourceElement parent = sourceElement.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getSymbolKind() != 3) continue;
            return (SourceClass)parent;
        }
        return null;
    }

    public static SourceMethod getEnclosingMethod(SourceElement sourceElement) {
        for (SourceElement parent = sourceElement.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getSymbolKind()) {
                case 6: 
                case 19: {
                    return (SourceMethod)parent;
                }
            }
        }
        return null;
    }

    public static SourceMember getEnclosingMember(SourceElement sourceElement) {
        for (SourceElement parent = sourceElement.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getSymbolKind()) {
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 19: {
                    return (SourceMember)parent;
                }
            }
        }
        return null;
    }

    private static Collection<JavaType> singletonOrEmptyList(JavaType type) {
        return type == null ? Collections.emptyList() : Collections.singletonList(type);
    }

    public static boolean isTypeUseAnnotation(JavaAnnotation javaAnnotation, boolean strict) {
        boolean result = false;
        JavaType annotationType = javaAnnotation.getAnnotationType();
        if (annotationType != null) {
            result = !strict;
            Collection<JavaAnnotation> annotationAnnotations = annotationType.getAnnotations();
            for (JavaAnnotation annotationAnnotation : annotationAnnotations) {
                JavaType annotationAnnotationType = annotationAnnotation.getResolvedType();
                if (annotationAnnotationType == null || !"java.lang.annotation.Target".equals(annotationAnnotationType.getRawName())) continue;
                result = false;
                Map arguments = annotationAnnotation.getArguments();
                Collection values = arguments.values();
                if (values.isEmpty()) continue;
                Object value = values.iterator().next();
                if (value instanceof JavaField) {
                    if (!CommonUtilities.isTypeAnnotationTarget((JavaField)value)) continue;
                    return true;
                }
                if (!(value instanceof Object[])) continue;
                for (Object oneValue : (Object[])value) {
                    if (!(oneValue instanceof JavaField) || !CommonUtilities.isTypeAnnotationTarget((JavaField)oneValue)) continue;
                    return true;
                }
            }
        }
        return result;
    }

    private static boolean isTypeAnnotationTarget(JavaField field) {
        return "TYPE_USE".equals(field.getName());
    }

    public static boolean matchMethod(JavaMethod method, JavaType[] targetParameterTypes) {
        Collection<JavaVariable> parameterCollection = method.getParameters();
        int parameterSize = parameterCollection.size();
        Iterator<JavaVariable> iterator = parameterCollection.iterator();
        if (iterator.hasNext() && method.isSourceElement() && ((SourceMethod)method).getJdkVersion().isJdk8OrAbove()) {
            JavaVariable firstParameter = iterator.next();
            if ("this".equals(firstParameter.getName())) {
                --parameterSize;
            } else {
                iterator = parameterCollection.iterator();
            }
        }
        if (targetParameterTypes == null) {
            return parameterSize == 0;
        }
        if (targetParameterTypes.length != parameterSize) {
            return false;
        }
        int p = 0;
        while (iterator.hasNext()) {
            JavaType targetParameterType = targetParameterTypes[p++];
            JavaVariable parameter = iterator.next();
            if (targetParameterType == null) continue;
            JavaType parameterType = parameter.getResolvedType();
            if (parameterType == null) {
                return false;
            }
            if (targetParameterType.getTypeErasure().equals(parameterType.getTypeErasure())) continue;
            return false;
        }
        return true;
    }

    public static boolean isInheritedAnnotation(JavaAnnotation annotation) {
        if (annotation == null) {
            return false;
        }
        JavaType annotationType = annotation.getResolvedType();
        return CommonUtilities.isInheritedAnnotation(annotationType);
    }

    public static boolean isInheritedAnnotation(JavaType annotationType) {
        if (annotationType == null || !annotationType.isAnnotation()) {
            return false;
        }
        for (JavaAnnotation thing : annotationType.getDeclaredAnnotations()) {
            JavaType type = thing.getAnnotationType();
            if (type == null || !"java/lang/annotation/Inherited".equals(type.getVMName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isParameterizedMethod(JavaMethod method) {
        return method instanceof ParameterizedMethod;
    }

    protected static boolean classProcessed(Set processed, JavaType javaClass) {
        if (processed == null) {
            return false;
        }
        String targetClassName = javaClass.getTypeSignature();
        return !processed.add(targetClassName);
    }

    private static void set_op2opt(byte optype, short tk, byte opt) {
        CommonUtilities.op2optTable[optype][tk - 32] = opt;
    }

    protected static byte asg_op(int token) {
        if (32 <= token && token < 83) {
            return op2optTable[OPTYPE_ASSIGNMENT][token - 32];
        }
        return 0;
    }

    protected static byte rel_op(int token) {
        if (32 <= token && token < 83) {
            return op2optTable[OPTYPE_RELATIONAL][token - 32];
        }
        return 0;
    }

    protected static byte shift_op(int token) {
        if (32 <= token && token < 83) {
            return op2optTable[OPTYPE_SHIFT][token - 32];
        }
        return 0;
    }

    protected static byte infix_op(int token) {
        if (32 <= token && token < 83) {
            return op2optTable[OPTYPE_INFIX][token - 32];
        }
        return 0;
    }

    protected static byte prefix_op(int token) {
        if (32 <= token && token < 83) {
            return op2optTable[OPTYPE_PREFIX][token - 32];
        }
        return 0;
    }

    protected static byte postfix_op(int token) {
        if (32 <= token && token < 83) {
            return op2optTable[OPTYPE_POSTFIX][token - 32];
        }
        return 0;
    }

    public static String getDescriptor(JavaMethod input) {
        JavaVariable firstParameter;
        if (input == null) {
            return "";
        }
        JavaMethod erasedMethod = input.getMethodErasure();
        StringBuilder buffer = new StringBuilder();
        Collection<JavaVariable> parameters = erasedMethod.getParameters();
        buffer.append('(');
        Iterator<JavaVariable> iterator = parameters.iterator();
        if (iterator.hasNext() && input.isSourceElement() && ((SourceMethod)input).getJdkVersion().isJdk8OrAbove() && !"this".equals((firstParameter = iterator.next()).getName())) {
            iterator = parameters.iterator();
        }
        while (iterator.hasNext()) {
            JavaVariable parameter = iterator.next();
            JavaType parameterType = parameter.getResolvedType();
            if (parameterType != null) {
                parameterType = parameterType.getTypeErasure();
            }
            if (parameterType != null) {
                buffer.append(parameterType.getDescriptor());
                continue;
            }
            buffer.append("Ljava/lang/Object;");
        }
        buffer.append(')');
        JavaType returnType = erasedMethod.getReturnType();
        if (returnType != null) {
            returnType = returnType.getTypeErasure();
        }
        if (returnType != null) {
            buffer.append(returnType.getDescriptor());
        } else {
            buffer.append('V');
        }
        return buffer.toString();
    }

    public static String getTypeSignature(JavaMethod input) {
        JavaVariable firstParameter;
        if (input == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (input.hasActualTypeArguments()) {
            buffer.append('<');
            for (JavaType type : input.getActualTypeArguments()) {
                if (type != null) {
                    buffer.append(type.getTypeSignature());
                    continue;
                }
                buffer.append("*");
            }
            buffer.append('>');
        }
        Collection<JavaVariable> parameters = input.getParameters();
        buffer.append('(');
        Iterator<JavaVariable> iterator = parameters.iterator();
        if (iterator.hasNext() && input.isSourceElement() && ((SourceMethod)input).getJdkVersion().isJdk8OrAbove() && !"this".equals((firstParameter = iterator.next()).getName())) {
            iterator = parameters.iterator();
        }
        while (iterator.hasNext()) {
            JavaVariable parameter = iterator.next();
            JavaType parameterType = parameter.getResolvedType();
            if (parameterType != null) {
                buffer.append(parameterType.getTypeSignature());
                continue;
            }
            buffer.append('V');
        }
        buffer.append(')');
        JavaType returnType = input.getReturnType();
        if (returnType != null) {
            buffer.append(returnType.getTypeSignature());
        } else {
            buffer.append('V');
        }
        return buffer.toString();
    }

    public static String getSignature(JavaMethod input) {
        JavaVariable firstParameter;
        if (input == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (input.hasTypeParameters()) {
            buffer.append('<');
            for (JavaTypeVariable variable : input.getTypeParameters()) {
                buffer.append(variable.getSignature());
            }
            buffer.append('>');
        }
        Collection<JavaVariable> parameters = input.getParameters();
        buffer.append('(');
        Iterator<JavaVariable> iterator = parameters.iterator();
        if (iterator.hasNext() && input.isSourceElement() && ((SourceMethod)input).getJdkVersion().isJdk8OrAbove() && !"this".equals((firstParameter = iterator.next()).getName())) {
            iterator = parameters.iterator();
        }
        while (iterator.hasNext()) {
            JavaVariable parameter = iterator.next();
            JavaType parameterType = parameter.getResolvedType();
            if (parameterType != null) {
                buffer.append(parameterType.getTypeSignature());
                continue;
            }
            buffer.append('V');
        }
        buffer.append(')');
        JavaType returnType = input.getReturnType();
        if (returnType != null) {
            buffer.append(returnType.getTypeSignature());
        } else {
            buffer.append('V');
        }
        for (JavaType exception : input.getExceptions()) {
            buffer.append('^');
            buffer.append(exception.getTypeSignature());
        }
        return buffer.toString();
    }

    public static String getDescriptor(JavaField input) {
        if (input == null) {
            return "";
        }
        JavaField erasedField = input.getFieldErasure();
        JavaType type = erasedField.getResolvedType();
        if (type != null) {
            type = type.getTypeErasure();
        }
        if (type == null) {
            return "Ljava/lang/Object;";
        }
        return type.getDescriptor();
    }

    public static String getSignature(JavaField input) {
        if (input == null) {
            return "";
        }
        JavaType type = input.getResolvedType();
        if (type == null) {
            return "Ljava/lang/Object;";
        }
        return type.getTypeSignature();
    }

    public static String getDescriptor(JavaClass input) {
        if (input == null) {
            return "";
        }
        if (input.isPrimitive()) {
            String name = input.getName();
            if ("boolean".equals(name)) {
                return "Z";
            }
            if ("byte".equals(name)) {
                return "B";
            }
            if ("char".equals(name)) {
                return "C";
            }
            if ("short".equals(name)) {
                return "S";
            }
            if ("int".equals(name)) {
                return "I";
            }
            if ("long".equals(name)) {
                return "J";
            }
            if ("float".equals(name)) {
                return "F";
            }
            if ("double".equals(name)) {
                return "D";
            }
            if ("null".equals(name)) {
                return "*";
            }
            if ("void".equals(name)) {
                return "V";
            }
            assert (false) : "Primitive type name is unknown";
            return "";
        }
        if (input.getElementKind() == 11 || input.getElementKind() == 10) {
            JavaClass erasure = input.getTypeErasure();
            if (erasure != null) {
                return erasure.getDescriptor();
            }
            return "Ljava/lang/Object;";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('L');
        buffer.append(input.getVMName());
        buffer.append(';');
        return buffer.toString();
    }

    public static String getTypeSignature(JavaClass input) {
        if (input == null) {
            return "";
        }
        if (input.isPrimitive()) {
            return CommonUtilities.getDescriptor(input);
        }
        StringBuilder buffer = new StringBuilder();
        if (input.isMemberClass() && !input.isStatic()) {
            String owningTypeSignature;
            JavaClass owningClass = input.getOwningClass();
            String owningDescriptor = owningClass.getDescriptor();
            if (!owningDescriptor.equals(owningTypeSignature = owningClass.getTypeSignature())) {
                buffer.append(owningTypeSignature);
                buffer.setLength(buffer.length() - 1);
                buffer.append('.');
                buffer.append(input.getName());
            } else {
                buffer.append('L');
                buffer.append(input.getVMName());
            }
        } else {
            buffer.append('L');
            buffer.append(input.getVMName());
        }
        if (input.hasActualTypeArguments()) {
            buffer.append('<');
            for (JavaType type : input.getActualTypeArguments()) {
                if (type != null) {
                    buffer.append(type.getTypeSignature());
                    continue;
                }
                buffer.append("*");
            }
            buffer.append('>');
        }
        buffer.append(';');
        return buffer.toString();
    }

    public static String getSignature(JavaClass input) {
        JavaType superclass;
        if (input == null) {
            return "";
        }
        if (input.isPrimitive()) {
            return CommonUtilities.getDescriptor(input);
        }
        StringBuilder buffer = new StringBuilder();
        if (input.hasTypeParameters()) {
            buffer.append('<');
            for (JavaTypeVariable variable : input.getTypeParameters()) {
                buffer.append(variable.getSignature());
            }
            buffer.append('>');
        }
        if ((superclass = input.getSuperclass()) != null) {
            buffer.append(superclass.getTypeSignature());
        } else {
            buffer.append("Ljava/lang/Object;");
        }
        for (JavaType type : input.getInterfaces()) {
            buffer.append(type.getTypeSignature());
        }
        return buffer.toString();
    }

    public static String getDescriptor(JavaTypeVariable input) {
        if (input == null) {
            return "";
        }
        JavaClass erasure = input.getTypeErasure();
        if (erasure != null) {
            return erasure.getDescriptor();
        }
        return "Ljava/lang/Object;";
    }

    public static String getTypeSignature(JavaTypeVariable input) {
        if (input == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('T');
        buffer.append(input.getName());
        buffer.append(';');
        return buffer.toString();
    }

    public static String getSignature(JavaTypeVariable input) {
        if (input == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(input.getName());
        Collection<JavaType> bounds = input.getBounds();
        if (bounds.size() > 0) {
            for (JavaType bound : input.getBounds()) {
                buffer.append(':');
                buffer.append(bound.getTypeSignature());
            }
        } else {
            buffer.append(':');
            buffer.append("Ljava/lang/Object;");
        }
        return buffer.toString();
    }

    public static String getUniqueIdentifier(JavaPackage thing) {
        return 'p' + thing.getQualifiedName().replace('.', '/');
    }

    public static String getUniqueIdentifier(JavaClass thing) {
        return thing.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaTypeVariable thing) {
        JavaIsGeneric owner = (JavaIsGeneric)thing.getOwningMember();
        String prefix = owner != null ? owner.getUniqueIdentifier() : "<unknown>";
        return prefix + ':' + thing.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaWildcardType thing) {
        return thing.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaField thing) {
        JavaClass owner = thing.getOwningClass();
        String ownerUnique = owner != null ? owner.getUniqueIdentifier() : "class-unknown";
        return 'f' + ownerUnique + '.' + thing.getName() + ' ' + CommonUtilities.getSignature(thing);
    }

    public static String getUniqueIdentifier(JavaMethod thing) {
        if (thing == null) {
            return "";
        }
        JavaClass owner = thing.getOwningClass();
        String ownerUnique = owner != null ? owner.getUniqueIdentifier() : "class-unknown";
        String signature = thing.getSignature();
        int firstExp = signature.indexOf(94);
        String signatureToUse = firstExp >= 0 ? signature.substring(0, firstExp) : signature;
        return 'm' + ownerUnique + '.' + thing.getName() + ' ' + signatureToUse;
    }

    public static boolean equals(JavaPackage one, JavaPackage two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.getQualifiedName().equals(two.getQualifiedName());
    }

    public static boolean equals(JavaMember one, JavaMember two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        String oneName = one.getName();
        if (oneName != null && oneName.equals(two.getName())) {
            return one.getUniqueIdentifier().equals(two.getUniqueIdentifier());
        }
        return false;
    }

    public static boolean isSameDeclaration(JavaType one, JavaType two) {
        if (!CommonUtilities.isSameNameAndOwningClass(one, two)) {
            return false;
        }
        String oneDescriptor = one.getDescriptor();
        return oneDescriptor != null && oneDescriptor.equals(two.getDescriptor());
    }

    public static boolean isSameDeclaration(JavaMethod one, JavaMethod two) {
        if (!CommonUtilities.isSameNameAndOwningClass(one, two)) {
            return false;
        }
        String oneDescriptor = one.getDescriptor();
        return oneDescriptor != null && oneDescriptor.equals(two.getDescriptor());
    }

    public static boolean isSameDeclaration(JavaField one, JavaField two) {
        if (!CommonUtilities.isSameNameAndOwningClass(one, two)) {
            return false;
        }
        String oneDescriptor = one.getDescriptor();
        return oneDescriptor != null && oneDescriptor.equals(two.getDescriptor());
    }

    private static boolean isSameNameAndOwningClass(JavaMember one, JavaMember two) {
        if (one == null || two == null) {
            return false;
        }
        String oneName = one.getName();
        if (oneName == null || !oneName.equals(two.getName())) {
            return false;
        }
        JavaClass oneOwner = one.getOwningClass();
        JavaClass twoOwner = two.getOwningClass();
        if (oneOwner == null || twoOwner == null) {
            return oneOwner == twoOwner;
        }
        String oneOwnerDescriptor = oneOwner.getDescriptor();
        return oneOwnerDescriptor != null && oneOwnerDescriptor.equals(twoOwner.getDescriptor());
    }

    public static int hashCode(JavaPackage thing) {
        if (thing == null) {
            return 0;
        }
        return thing.getQualifiedName().hashCode();
    }

    public static int hashCode(JavaMember thing) {
        if (thing == null) {
            return 0;
        }
        return thing.getUniqueIdentifier().hashCode();
    }

    public static JavaField getDeclaredField(JavaType target, String name) {
        for (JavaField thing : target.getDeclaredFields()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static Collection<JavaMethod> getDeclaredMethods(JavaType target, String name) {
        ArrayList<JavaMethod> list = new ArrayList<JavaMethod>();
        for (JavaMethod thing : target.getDeclaredMethods()) {
            if (!name.equals(thing.getName())) continue;
            list.add(thing);
        }
        return list;
    }

    public static JavaMethod getDeclaredMethod(JavaType target, String name, JavaType[] targetTypes) {
        if (target == null) {
            return null;
        }
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod thing : target.getDeclaredMethods(name)) {
            if (!CommonUtilities.matchMethod(thing, targetTypes)) continue;
            return thing;
        }
        return null;
    }

    public static JavaMethod getDeclaredConstructor(JavaType target, JavaType[] targetTypes) {
        if (target == null) {
            return null;
        }
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod thing : target.getDeclaredConstructors()) {
            if (!CommonUtilities.matchMethod(thing, targetTypes)) continue;
            return thing;
        }
        return null;
    }

    public static JavaClass getDeclaredClass(JavaType target, String name) {
        for (JavaClass thing : target.getDeclaredClasses()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static JavaTypeVariable getTypeParameter(JavaIsGeneric target, String name) {
        if (!target.hasTypeParameters()) {
            return null;
        }
        for (JavaTypeVariable thing : target.getTypeParameters()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static JavaAnnotation getDeclaredAnnotation(JavaHasAnnotations target, JavaType annotationType) {
        if (annotationType == null) {
            return null;
        }
        for (JavaAnnotation thing : target.getDeclaredAnnotations()) {
            JavaType type = thing.getResolvedType();
            if (type == null || !type.equals(annotationType)) continue;
            return thing;
        }
        return null;
    }

    public static Collection<JavaField> getFields(JavaType target) {
        ArrayList<JavaField> list = new ArrayList<JavaField>();
        list.addAll(target.getDeclaredFields());
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            list.addAll(superType.getDeclaredFields());
        }
        return list;
    }

    public static JavaField getField(JavaType target, String name) {
        JavaField thing = target.getDeclaredField(name);
        if (thing != null) {
            return thing;
        }
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            thing = superType.getDeclaredField(name);
            if (thing == null) continue;
            return thing;
        }
        return null;
    }

    public static Collection<JavaMethod> getMethods(JavaType target) {
        return CommonUtilities.getMethodsImpl(target, null);
    }

    private static Collection<JavaMethod> getMethodsImpl(JavaType target, String name) {
        if (target == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaMethod> result = new ArrayList<JavaMethod>();
        if (name == null) {
            result.addAll(target.getDeclaredMethods());
        } else {
            result.addAll(target.getDeclaredMethods(name));
        }
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            if (name == null) {
                result.addAll(superType.getDeclaredMethods());
                continue;
            }
            result.addAll(superType.getDeclaredMethods(name));
        }
        return result;
    }

    public static Collection<JavaMethod> getMethods(JavaType target, String name) {
        return CommonUtilities.getMethodsImpl(target, name);
    }

    public static JavaMethod getMethod(JavaType target, String name, JavaType[] parameterTypes) {
        Collection<JavaMethod> methods = CommonUtilities.getMethods(target, name);
        for (JavaMethod javaMethod : methods) {
            if (!CommonUtilities.matchMethod(javaMethod, parameterTypes)) continue;
            return javaMethod;
        }
        return null;
    }

    public static boolean methodThrowsMoreCheckedExceptions(JavaMethod subject, JavaMethod target) {
        Collection<JavaType> targetExceptions = target.getExceptions();
        Collection<JavaType> subjectExceptions = subject.getExceptions();
        Iterator<JavaType> subjectIter = subjectExceptions.iterator();
        block0: while (subjectIter.hasNext()) {
            JavaType subjectException;
            for (JavaType superClass = subjectException = subjectIter.next(); superClass != null; superClass = superClass.getSuperclass()) {
                String name = superClass.getRawName();
                if ("java.lang.RuntimeException".equals(name) || "java.lang.Error".equals(name)) continue block0;
            }
            for (JavaType targetException : targetExceptions) {
                if (!subjectException.isSubtypeOf(targetException)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public static boolean hasOverrideCompatibleVisibility(JavaMethod method, JavaMethod otherMethod) {
        JavaClass owner;
        JavaClass otherOwner;
        if (method.isStatic() || otherMethod.isStatic()) {
            return false;
        }
        if (otherMethod.isFinal() || otherMethod.isPrivate() || method.isPrivate()) {
            return false;
        }
        boolean otherMethodIsPublic = otherMethod.isPublic();
        if (otherMethod.isPackagePrivate() && (otherOwner = otherMethod.getOwningClass()) != null && otherOwner.isInterface()) {
            otherMethodIsPublic = true;
        }
        boolean methodIsPublic = method.isPublic();
        if (method.isPackagePrivate() && (owner = method.getOwningClass()) != null && owner.isInterface()) {
            methodIsPublic = true;
        }
        if (otherMethodIsPublic && !methodIsPublic) {
            return false;
        }
        if (otherMethod.isProtected() && method.isPackagePrivate()) {
            return false;
        }
        return !otherMethod.isPackagePrivate() || otherMethod.getOwningClass().getPackage().equals(method.getOwningClass().getPackage());
    }

    public static Collection<JavaClass> getClasses(JavaType target) {
        ArrayList<JavaClass> list = new ArrayList<JavaClass>();
        list.addAll(target.getDeclaredClasses());
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            list.addAll(superType.getDeclaredClasses());
        }
        return list;
    }

    public static List<JavaType> getClassHierarchy(JavaType javaType) {
        ArrayList<JavaType> finalResults = new ArrayList<JavaType>();
        if (javaType == null) {
            return finalResults;
        }
        HashSet<String> processed = new HashSet<String>();
        boolean eraseTypes = javaType.isErasedType();
        CommonUtilities.getClassHierarchyImpl(javaType, true, eraseTypes, 0, processed, finalResults);
        ArrayList<JavaType> classes = new ArrayList<JavaType>(finalResults);
        classes.add(0, javaType);
        processed.clear();
        for (JavaType clazz : classes) {
            CommonUtilities.getClassHierarchyImpl(clazz, false, eraseTypes, 0, processed, finalResults);
        }
        return finalResults;
    }

    private static void getClassHierarchyImpl(JavaType type, boolean collectSupers, boolean eraseTypes, int depth, Set<String> processedTypes, List<JavaType> finalResults) {
        if (type == null) {
            return;
        }
        if (!processedTypes.add(type.getVMName())) {
            return;
        }
        if (depth > 0) {
            boolean hasTypeParameters = type.hasTypeParameters();
            if (hasTypeParameters && !type.hasActualTypeArguments()) {
                eraseTypes = true;
            } else if (!hasTypeParameters) {
                eraseTypes = false;
            }
            if (collectSupers != type.isInterface()) {
                JavaType normalizedType = eraseTypes ? type.getTypeErasure() : type;
                finalResults.add(normalizedType);
            }
        }
        if (collectSupers) {
            JavaType superType = type.getSuperclass();
            CommonUtilities.getClassHierarchyImpl(superType, collectSupers, eraseTypes, depth + 1, processedTypes, finalResults);
        } else {
            for (JavaType interfac : type.getInterfaces()) {
                CommonUtilities.getClassHierarchyImpl(interfac, collectSupers, eraseTypes, depth + 1, processedTypes, finalResults);
            }
        }
    }

    public static JavaClass getClass(JavaType target, String name) {
        JavaClass thing = target.getDeclaredClass(name);
        if (thing != null) {
            return thing;
        }
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            thing = superType.getDeclaredClass(name);
            if (thing == null) continue;
            return thing;
        }
        return null;
    }

    public static JavaClass getClass(JavaFile target, String name) {
        if (target == null || name == null) {
            return null;
        }
        for (JavaClass thing : target.getClasses()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static Collection<JavaAnnotation> getAnnotations(JavaType target) {
        ArrayList<JavaAnnotation> list = new ArrayList<JavaAnnotation>();
        list.addAll(target.getDeclaredAnnotations());
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            for (JavaAnnotation a : superType.getDeclaredAnnotations()) {
                if (!a.isInherited()) continue;
                list.add(a);
            }
        }
        return list;
    }

    public static JavaAnnotation getAnnotation(JavaType target, JavaType annotationType) {
        if (annotationType == null) {
            return null;
        }
        for (JavaAnnotation thing : target.getAnnotations()) {
            JavaType type = thing.getResolvedType();
            if (type == null || !type.equals(annotationType)) continue;
            return thing;
        }
        return null;
    }

    public static JavaType[] getParameterTypes(JavaMethod target) {
        if (target == null) {
            return JavaType.EMPTY_ARRAY;
        }
        Collection<JavaVariable> parameters = target.getParameters();
        Iterator<JavaVariable> iterator = parameters.iterator();
        int count = parameters.size();
        if (iterator.hasNext() && target.isSourceElement() && ((SourceMethod)target).getJdkVersion().isJdk8OrAbove()) {
            JavaVariable firstParameter = iterator.next();
            if ("this".equals(firstParameter.getName())) {
                --count;
            } else {
                iterator = parameters.iterator();
            }
        }
        JavaType[] out = new JavaType[count];
        int i = 0;
        while (iterator.hasNext()) {
            JavaVariable variable = iterator.next();
            out[i++] = variable.getResolvedType();
        }
        return out;
    }

    public static JavaElement locateByUniqueIdentifier(String uniqueIdentifier, JavaProvider provider) {
        int totalLength = uniqueIdentifier.length();
        if (totalLength == 0) {
            return null;
        }
        char first = uniqueIdentifier.charAt(0);
        switch (first) {
            case 'p': {
                if (totalLength == 1) {
                    return provider.getPackage("");
                }
                String packageName = uniqueIdentifier.substring(1).replace('/', '.');
                return provider.getPackage(packageName);
            }
            case 'f': {
                int dot = uniqueIdentifier.indexOf(46, 1);
                if (dot <= 1) {
                    return null;
                }
                String classIdentifier = uniqueIdentifier.substring(1, dot);
                JavaType classThing = CommonUtilities.getTypeByUniqueIdentifier0(classIdentifier, provider);
                if (classThing == null) {
                    return null;
                }
                int space = uniqueIdentifier.indexOf(32, dot + 1);
                if (space < 0 || space == dot + 1) {
                    return null;
                }
                String name = uniqueIdentifier.substring(dot + 1, space);
                return classThing.getDeclaredField(name);
            }
            case 'm': {
                int dot = uniqueIdentifier.indexOf(46, 1);
                if (dot <= 1) {
                    return null;
                }
                String classIdentifier = uniqueIdentifier.substring(1, dot);
                JavaType classThing = CommonUtilities.getTypeByUniqueIdentifier0(classIdentifier, provider);
                if (classThing == null) {
                    return null;
                }
                int space = uniqueIdentifier.indexOf(32, dot + 1);
                if (space < 0 || space == dot + 1) {
                    return null;
                }
                String name = uniqueIdentifier.substring(dot + 1, space);
                int lparen = uniqueIdentifier.indexOf(40, space + 1);
                if (lparen < 0) {
                    return null;
                }
                int rparen = uniqueIdentifier.indexOf(41, lparen + 1);
                if (rparen < 0) {
                    return null;
                }
                JavaType[] formals = JavaType.EMPTY_ARRAY;
                if (rparen != lparen + 1) {
                    String formalsString = uniqueIdentifier.substring(lparen + 1, rparen);
                    formals = CommonUtilities.getTypesByUniqueIdentifier0(formalsString, provider);
                }
                return classThing.getDeclaredMethod(name, formals);
            }
        }
        return CommonUtilities.getTypeByUniqueIdentifier0(uniqueIdentifier, provider);
    }

    private static JavaType getTypeByUniqueIdentifier0(String identifier, JavaProvider provider) {
        char first;
        int length = identifier.length();
        if (length == 1 && 'A' <= (first = identifier.charAt(0)) && first <= 'Z') {
            return PrimitiveType.PRIMITIVE_alpha[first - 65];
        }
        try {
            QuickSignatureParser parser = new QuickSignatureParser(identifier, null, provider);
            SignatureHasType hasType = (SignatureHasType)parser.parseTypeSignature0();
            if (hasType != null) {
                return hasType.getResolvedType();
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private static JavaType[] getTypesByUniqueIdentifier0(String identifier, JavaProvider provider) {
        try {
            SignatureHasType hasType;
            QuickSignatureParser parser = new QuickSignatureParser(identifier, null, provider);
            ArrayList<JavaType> list = new ArrayList<JavaType>();
            while (parser.curToken != 0 && (hasType = (SignatureHasType)parser.parseTypeSignature0()) != null) {
                list.add(hasType.getResolvedType());
            }
            int count = list.size();
            if (count == 0) {
                return JavaType.EMPTY_ARRAY;
            }
            return list.toArray(new JavaType[count]);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (IllegalStateException illegalStateException) {
            return JavaType.EMPTY_ARRAY;
        }
    }

    public static SourceElement getSourceElement(JavaElement target, SourceFile searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        switch (target.getElementKind()) {
            case 3: {
                JavaClass thing = (JavaClass)target;
                SourceClass found = CommonUtilities.getSourceElement(thing, searchSpace);
                if (found != null) {
                    return found;
                }
                JavaClass owning = thing.getOwningClass();
                if (owning == null) {
                    return null;
                }
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
            case 5: {
                JavaField thing = (JavaField)target;
                JavaClass owning = thing.getOwningClass();
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
            case 4: 
            case 8: {
                JavaMethod thing = (JavaMethod)target;
                JavaClass owning = thing.getOwningClass();
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
        }
        return null;
    }

    public static SourceClass getSourceElement(JavaClass target, SourceFile searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        SourceFile sourceFile = searchSpace;
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getDescriptor();
        for (SourceClass thing : sourceFile.getSourceClasses()) {
            if (!targetName.equals(thing.getDescriptor())) continue;
            return thing;
        }
        return null;
    }

    public static SourceClass getSourceElement(JavaClass target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        SourceClass sourceClass = searchSpace;
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getName();
        for (SourceClass thing : sourceClass.getSourceClasses()) {
            if (!targetName.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static SourceMemberVariable getSourceElement(JavaField target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        SourceClass sourceClass = searchSpace;
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getName();
        for (SourceMemberVariable thing : sourceClass.getSourceMemberVariables()) {
            if (!targetName.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static SourceMethod getSourceElement(JavaMethod target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        SourceClass sourceClass = searchSpace;
        if (target == null) {
            throw new IllegalArgumentException();
        }
        boolean isConstructor = target.isConstructor();
        String targetName = target.getName();
        Iterator<SourceMethod> methods = isConstructor ? sourceClass.getSourceConstructors().iterator() : sourceClass.getSourceMethods().iterator();
        boolean isVarargs = target.isVarargs();
        String descriptor = target.getDescriptor();
        while (methods.hasNext()) {
            SourceMethod method = methods.next();
            if (!isConstructor && (!targetName.equals(method.getName()) || isVarargs != method.isVarargs()) || !descriptor.equals(method.getDescriptor())) continue;
            return method;
        }
        return null;
    }

    public static SourceAnnotation getSourceElement(JavaAnnotation target, SourceHasModifiers searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        JavaType targetType = target.getResolvedType();
        if (targetType == null) {
            return null;
        }
        for (SourceAnnotation sourceThing : searchSpace.getSourceAnnotations()) {
            JavaType thingType;
            JavaAnnotation thing = (JavaAnnotation)sourceThing.getCompiledObject();
            if (thing == null || (thingType = thing.getResolvedType()) == null || !targetType.equals(thingType)) continue;
            return sourceThing;
        }
        return null;
    }

    public static JavaMethod getDeclaredMethodFromUniqueId(JavaFile javaFile, String uniqueIdentifier) {
        if (javaFile != null) {
            Collection<JavaClass> classes = javaFile.getClasses();
            Iterator<JavaClass> classIter = classes.iterator();
            while (classIter.hasNext()) {
                JavaMethod method = CommonUtilities.getDeclaredMethodFromUniqueId(classIter.next(), uniqueIdentifier);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    public static JavaMethod getDeclaredMethodFromUniqueId(JavaClass javaClass, String uniqueIdentifier) {
        if (javaClass != null) {
            JavaMethod method = CommonUtilities.getDeclaredMethodFromUniqueId(javaClass.getDeclaredMethods(), uniqueIdentifier);
            if (method != null) {
                return method;
            }
            method = CommonUtilities.getDeclaredMethodFromUniqueId(javaClass.getDeclaredConstructors(), uniqueIdentifier);
            if (method != null) {
                return method;
            }
            Iterator<JavaClass> iterator = javaClass.getDeclaredClasses().iterator();
            while (iterator.hasNext()) {
                method = CommonUtilities.getDeclaredMethodFromUniqueId(iterator.next(), uniqueIdentifier);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    private static JavaMethod getDeclaredMethodFromUniqueId(Collection methods, String uniqueIdentifier) {
        for (JavaMethod method : methods) {
            if (!method.getUniqueIdentifier().equals(uniqueIdentifier)) continue;
            return method;
        }
        return null;
    }

    public static JavaField getDeclaredFieldFromUniqueId(JavaFile javaFile, String uniqueIdentifier) {
        if (javaFile != null) {
            Collection<JavaClass> classes = javaFile.getClasses();
            Iterator<JavaClass> classIter = classes.iterator();
            while (classIter.hasNext()) {
                JavaField field = CommonUtilities.getDeclaredFieldFromUniqueId(classIter.next(), uniqueIdentifier);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    public static JavaField getDeclaredFieldFromUniqueId(JavaClass javaClass, String uniqueIdentifier) {
        if (javaClass != null) {
            for (JavaField field : javaClass.getDeclaredFields()) {
                if (!field.getUniqueIdentifier().equals(uniqueIdentifier)) continue;
                return field;
            }
            Iterator<JavaMember> iterator = javaClass.getDeclaredClasses().iterator();
            while (iterator.hasNext()) {
                JavaField field;
                field = CommonUtilities.getDeclaredFieldFromUniqueId((JavaClass)iterator.next(), uniqueIdentifier);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    public static List<SourceClass> getSourceAnonymousClasses(final SourceElement sourceElement) {
        if (sourceElement == null) {
            return Collections.emptyList();
        }
        final ArrayList<SourceClass> foundClasses = new ArrayList<SourceClass>();
        SourceVisitor visitor = new SourceVisitor(){

            @Override
            public void whenEnterClass(SourceClass sourceClass) {
                if (sourceClass == sourceElement) {
                    return;
                }
                if (sourceClass.isAnonymousClass()) {
                    foundClasses.add(sourceClass);
                }
                this.cancelSubtree();
            }
        };
        visitor.visit(sourceElement);
        return foundClasses;
    }

    public static List<SourceClass> getSourceLocalClasses(final SourceElement sourceElement) {
        if (sourceElement == null) {
            return Collections.emptyList();
        }
        final ArrayList<SourceClass> foundClasses = new ArrayList<SourceClass>();
        SourceVisitor visitor = new SourceVisitor(){

            @Override
            public void whenEnterClass(SourceClass sourceClass) {
                if (sourceClass == sourceElement) {
                    return;
                }
                if (sourceClass.isLocalClass()) {
                    foundClasses.add(sourceClass);
                }
                this.cancelSubtree();
            }
        };
        visitor.visit(sourceElement);
        return foundClasses;
    }

    @Deprecated
    public static boolean isKeyword(String word, byte j2se) {
        return CommonUtilities.isKeyword(word, JdkVersion.getJdkVersion(j2se));
    }

    public static boolean isKeyword(String word, JdkVersion jdkVersion) {
        if (word == null || jdkVersion == null || jdkVersion == JdkVersion.JDK_UNKNOWN) {
            return false;
        }
        Short kw = keywordToToken.get(word);
        if (kw == null) {
            return false;
        }
        switch (jdkVersion) {
            case JDK_1_3: {
                return kw < 144;
            }
            case JDK_1_4: {
                return kw < 145;
            }
            case JDK_1_5: {
                return kw < 146;
            }
            case JDK_1_6: {
                return kw < 146;
            }
            case JDK_1_7: {
                return kw < 146;
            }
            case JDK_1_8: {
                return kw < 146;
            }
            case JDK_1_9: {
                return kw < 146;
            }
        }
        if (!jdkVersion.isJdk3OrAbove()) {
            return kw < 144;
        }
        return true;
    }

    public static boolean isValidImportName(String name) {
        return CommonUtilities.isValidName(name, true, false);
    }

    public static boolean isValidQualifiedName(String name) {
        return CommonUtilities.isValidName(name, false, true);
    }

    public static boolean isValidSimpleName(String name) {
        return CommonUtilities.isValidIdentifier(name) || "this".equals(name) || "super".equals(name);
    }

    private static boolean isValidName(String name, boolean checkImport, boolean checkQualified) {
        if (name == null || name.length() == 0) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ".", true);
        boolean sawDot = true;
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (".".equals(nextToken)) {
                if (sawDot) {
                    return false;
                }
                sawDot = true;
            } else {
                if (checkQualified) {
                    if (!CommonUtilities.isValidSimpleName(nextToken) && !"class".equals(nextToken) && PrimitiveType.lookupPrimitive(name) == null) {
                        return false;
                    }
                } else if (checkImport) {
                    if (!CommonUtilities.isValidIdentifier(nextToken)) {
                        return count > 0 && "*".equals(nextToken) && !tokenizer.hasMoreTokens();
                    }
                } else if (!CommonUtilities.isValidIdentifier(nextToken)) {
                    return false;
                }
                sawDot = false;
            }
            ++count;
        }
        return !sawDot;
    }

    public static boolean isReservedLiteral(String word) {
        return reservedLiterals.contains(word);
    }

    public static boolean isReservedWord(String word) {
        return CommonUtilities.isKeyword(word, JdkVersion.getMaxVersion()) || CommonUtilities.isReservedLiteral(word);
    }

    public static boolean isReservedWord(String word, JdkVersion jdkVersion) {
        return CommonUtilities.isKeyword(word, jdkVersion) || CommonUtilities.isReservedLiteral(word);
    }

    public static boolean isValidIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int count = name.length();
        if (count == 0) {
            return false;
        }
        if (CommonUtilities.isReservedWord(name)) {
            return false;
        }
        char firstch = name.charAt(0);
        if (!Character.isJavaIdentifierStart(firstch)) {
            return false;
        }
        for (int i = 1; i < count; ++i) {
            char ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPackageName(String name) {
        return CommonUtilities.isValidName(name, false, false);
    }

    public static boolean isValidTypeName(String name) {
        return CommonUtilities.isValidPackageName(name) || PrimitiveType.lookupPrimitive(name) != null;
    }

    public static boolean containsClassThisSuper(String qualifiedName) {
        int length = qualifiedName.length();
        int afterLastDot = 0;
        while (afterLastDot < length) {
            int segmentLength;
            int nextDot = qualifiedName.indexOf(46, afterLastDot);
            if (nextDot < 0) {
                nextDot = length;
            }
            if (4 <= (segmentLength = nextDot - afterLastDot) && segmentLength <= 5) {
                String segment = qualifiedName.substring(afterLastDot, nextDot);
                if (segment.equals("class")) {
                    return true;
                }
                if (segment.equals("this")) {
                    return true;
                }
                if (segment.equals("super")) {
                    return true;
                }
            }
            afterLastDot = nextDot + 1;
        }
        return false;
    }

    public static JavaClass getTypeErasure(JavaTypeVariable thing) {
        JavaType firstBound;
        Collection<JavaType> bounds;
        if (!(CommonUtilities.hasBoundsCircularity(thing) || (bounds = thing.getBounds()).isEmpty() || (firstBound = bounds.iterator().next()).equals(thing))) {
            return firstBound.getTypeErasure();
        }
        JavaType superclass = thing.getSuperclass();
        if (superclass != null) {
            return superclass.getTypeErasure();
        }
        Collection<JavaType> interfaces = thing.getInterfaces();
        if (interfaces.isEmpty()) {
            return null;
        }
        JavaType firstInterface = interfaces.iterator().next();
        return firstInterface.getTypeErasure();
    }

    public static boolean hasBoundsCircularity(JavaTypeVariable javaTypeVariable) {
        if (javaTypeVariable == null) {
            return false;
        }
        return CommonUtilities.hasBoundsCircularity(javaTypeVariable, javaTypeVariable);
    }

    private static boolean hasBoundsCircularity(JavaTypeVariable originalThing, JavaTypeVariable currentThing) {
        Collection<JavaType> bounds = currentThing.getBounds();
        if (!bounds.isEmpty()) {
            for (JavaType bound : bounds) {
                boolean hasCircularity;
                if (bound == null) continue;
                if (bound.equals(originalThing)) {
                    return true;
                }
                if (bound.getElementKind() != 10 || !(hasCircularity = CommonUtilities.hasBoundsCircularity(originalThing, (JavaTypeVariable)bound))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getInstantiatedTypeToString(JavaType type) {
        StringBuilder buf = new StringBuilder();
        if (type.isArray()) {
            buf.append(CommonUtilities.getInstantiatedTypeToString(type.getComponentType()));
            buf.append("[]");
        } else {
            buf.append(type.getName());
            if (type.getElementKind() == 11) {
                JavaWildcardType wildCardType = (JavaWildcardType)type;
                String snippet = null;
                Collection<JavaType> c = wildCardType.getUpperBounds();
                if (c != null && c.iterator().hasNext()) {
                    snippet = " extends ";
                } else {
                    c = wildCardType.getLowerBounds();
                    if (c != null && c.iterator().hasNext()) {
                        snippet = " super ";
                    }
                }
                if (snippet != null) {
                    buf.append(snippet);
                    JavaType boundType = c.iterator().next();
                    buf.append(CommonUtilities.getInstantiatedTypeToString(boundType));
                }
            } else if (type.hasActualTypeArguments()) {
                buf.append('<');
                Collection<JavaType> args = type.getActualTypeArguments();
                Iterator<JavaType> iter = args.iterator();
                while (iter.hasNext()) {
                    buf.append(CommonUtilities.getInstantiatedTypeToString(iter.next()));
                    if (!iter.hasNext()) continue;
                    buf.append(',');
                }
                buf.append('>');
            }
        }
        return buf.toString();
    }

    public static List immutableCopy(Collection src) {
        Object[] array = src.toArray();
        return Arrays.asList(array);
    }

    public static ArrayList mutableCopy(Collection src) {
        ArrayList dst = new ArrayList();
        dst.addAll(src);
        return dst;
    }

    public static List<Integer> getParameterCommaLocations(SourceMethod sourceMethod) {
        SourceFormalParameterList formalParameterList;
        ArrayList<Integer> commaLocations = new ArrayList<Integer>();
        if (sourceMethod != null && (formalParameterList = sourceMethod.getFormalParameterList()) != null) {
            List<SourceVariable> parameters = formalParameterList.getSourceParameters();
            CommonUtilities.fillInCommaLocations(parameters, formalParameterList.getTokens(), commaLocations);
        }
        return commaLocations;
    }

    public static List<Integer> getArgumentCommaLocations(SourceInvokeExpression invokeExpression) {
        SourceListExpression argumentList;
        ArrayList<Integer> commaLocations = new ArrayList<Integer>();
        if (invokeExpression != null && (argumentList = invokeExpression.getArgumentList()) != null) {
            List<SourceExpression> arguments = argumentList.getOperands();
            CommonUtilities.fillInCommaLocations(arguments, argumentList.getTokens(), commaLocations);
        }
        return commaLocations;
    }

    private static void fillInCommaLocations(List<? extends SourceElement> pieces, List<SourceToken> tokens, List<Integer> commaLocations) {
        if (pieces.isEmpty()) {
            return;
        }
        int piecesIndex = 0;
        int currentPieceStart = pieces.get(piecesIndex).getStartOffset();
        int currentPieceEnd = pieces.get(piecesIndex).getEndOffset();
        for (SourceToken token : tokens) {
            if (token.getTokenStart() >= currentPieceStart && token.getTokenEnd() <= currentPieceEnd) continue;
            if (token.getTokenStart() >= currentPieceEnd) {
                if (++piecesIndex < pieces.size()) {
                    currentPieceStart = pieces.get(piecesIndex).getStartOffset();
                    currentPieceEnd = pieces.get(piecesIndex).getEndOffset();
                } else {
                    SourceToken lastToken = tokens.get(tokens.size() - 1);
                    currentPieceStart = lastToken.getTokenEnd();
                    currentPieceEnd = lastToken.getTokenEnd();
                }
            }
            if (token.getTokenValue() != 39) continue;
            commaLocations.add(token.getTokenStart());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JavaHasNameSet<JavaType> getHandledExceptions(SourceElement sourceElement) {
        JavaHasNameSet<JavaType> set = new JavaHasNameSet<JavaType>();
        for (SourceElement parent = sourceElement.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getSymbolKind()) {
                case 48: {
                    for (SourceCatchClause clause : ((SourceTryStatement)parent).getCatchClauses()) {
                        JavaType type;
                        SourceVariable variable = clause.getCatchVariable();
                        if (variable == null || (type = variable.getResolvedType()) == null) continue;
                        set.add(type);
                    }
                    break;
                }
                case 35: {
                    SourceCatchClause catchClause = (SourceCatchClause)parent;
                    SourceTryStatement catchTry = catchClause.getOwningTry();
                    if (catchTry == null) break;
                    parent = catchTry;
                    break;
                }
                case 41: {
                    SourceFinallyClause finallyClause = (SourceFinallyClause)parent;
                    SourceTryStatement finallyTry = finallyClause.getOwningTry();
                    if (finallyTry == null) break;
                    parent = finallyTry;
                    break;
                }
                case 19: {
                    SourceMethod method = (SourceMethod)parent;
                    for (JavaType e : method.getExceptions()) {
                        set.add(e);
                    }
                    return set;
                }
            }
        }
        return set;
    }

    public static String format(String input, String arg0) {
        int index;
        if (arg0 != null && (index = input.indexOf("{0}")) >= 0) {
            String prefix = input.substring(0, index);
            String suffix = input.substring(index + 3);
            input = prefix + arg0 + suffix;
        }
        return input;
    }

    public static String format(String input, String arg0, String arg1) {
        String suffix;
        String prefix;
        int index;
        if (arg0 != null && (index = input.indexOf("{0}")) >= 0) {
            prefix = input.substring(0, index);
            suffix = input.substring(index + 3);
            input = prefix + arg0 + suffix;
        }
        if (arg1 != null && (index = input.indexOf("{1}")) >= 0) {
            prefix = input.substring(0, index);
            suffix = input.substring(index + 3);
            input = prefix + arg1 + suffix;
        }
        return input;
    }

    public static void panic(String msg) {
        throw new IllegalStateException(msg);
    }

    public static void panic() {
        throw new IllegalStateException();
    }

    public static void unsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    public static void unsupported() {
        throw new UnsupportedOperationException();
    }

    public static void notImplementedYet() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    static {
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)33, (byte)6);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)68, (byte)2);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)60, (byte)32);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)64, (byte)36);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)42, (byte)18);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)62, (byte)34);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)32, (byte)8);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)66, (byte)11);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)78, (byte)13);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)57, (byte)29);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)74, (byte)52);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)77, (byte)57);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)58, (byte)30);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)51, (byte)25);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)46, (byte)22);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)45, (byte)21);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)44, (byte)20);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)65, (byte)42);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)56, (byte)28);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)73, (byte)51);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)76, (byte)56);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)67, (byte)1);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)59, (byte)31);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)63, (byte)35);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)41, (byte)17);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)61, (byte)33);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)52, (byte)3);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)54, (byte)43);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)34, (byte)7);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)36, (byte)10);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)37, (byte)12);
        for (short tk = 32; tk < 83; tk = (short)(tk + 1)) {
            byte opt = 0;
            if (opt == 0) {
                opt = CommonUtilities.asg_op(tk);
            }
            if (opt == 0) {
                opt = CommonUtilities.rel_op(tk);
            }
            if (opt == 0) {
                opt = CommonUtilities.shift_op(tk);
            }
            if (opt == 0) continue;
            CommonUtilities.set_op2opt(OPTYPE_INFIX, tk, opt);
        }
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)48, (byte)48);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)40, (byte)47);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)53, (byte)41);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)35, (byte)9);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)67, (byte)44);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)59, (byte)37);
        CommonUtilities.set_op2opt(OPTYPE_POSTFIX, (short)48, (byte)46);
        CommonUtilities.set_op2opt(OPTYPE_POSTFIX, (short)40, (byte)45);
        keywordToToken = new HashMap<String, Short>();
        for (short kw = 96; kw < 146; kw = (short)(kw + 1)) {
            keywordToToken.put(KW_words[kw - 96], kw);
        }
        reservedLiterals = new HashSet<String>(3);
        reservedLiterals.add("null");
        reservedLiterals.add("true");
        reservedLiterals.add("false");
    }
}

