/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.classfile.ClassConstants;
import oracle.javatools.parser.java.v2.classfile.Name;
import oracle.javatools.parser.java.v2.classfile.NamePool;
import oracle.javatools.parser.java.v2.common.CommonUtilities;

public final class ClassFile
implements ClassConstants {
    private static final ClassField[] EMPTY_FIELD_ARRAY = new ClassField[0];
    private static final ClassMethod[] EMPTY_METHOD_ARRAY = new ClassMethod[0];
    private static final ClassAnnotation[] EMPTY_ANNOTATION_ARRAY = new ClassAnnotation[0];
    private static final ComponentValue[] EMPTY_VALUE_ARRAY = new ComponentValue[0];
    private static final ClassAnnotation[][] EMPTY_ANNOTATION_ARRAY_ARRAY = new ClassAnnotation[0][];
    private static final MethodParameter[] EMPTY_METHOD_PARAMETER_ARRAY = new MethodParameter[0];
    private static final int DEPRECATED = 65536;
    private static final int HIDDEN_ATTR = 0x20000000;
    private static final Map<Name, Byte> ATTRIBUTE_indices;
    private static final Name kInitS;
    private static final Name kClinitS;
    private byte[] buffer;
    private int bp;
    private int[] poolIdx;
    private Object[] poolObj;
    private int implBp;
    private int fieldBp;
    private int methodBp;
    private int attrBp;
    private URL url;
    private int modifiers;
    private Name thisClassName;
    private Name sourceFilename;
    private Name classSignature;
    private Name baseClass;
    private Name[] baseInterfaces;
    private ClassField[] fields;
    private ClassMethod clinit;
    private ClassMethod[] methods;
    private ClassMethod[] constructors;
    private Name outerClass;
    private Name[] innerClasses;
    private ClassAnnotation[] classAnnotations;
    private List<TypeAnnotation> typeAnnotations;
    private boolean isAnonymous;
    private int enclosingClassIndex;
    private int enclosingMethodIndex;
    public static int ___constant_pool;
    public static final int ___inner_classes = 0;
    private static final int kMember_AttrPos = 6;

    private static final byte name2attribute(Name name) {
        Byte result = ATTRIBUTE_indices.get(name);
        if (result != null) {
            return result;
        }
        return 0;
    }

    public ClassFile(byte[] buffer, URL url) {
        this.buffer = buffer;
        this.url = url;
        try {
            this.readHeader();
            this.indexFields();
            this.indexMethods();
            this.readClassAttributes();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (url != null) {
                System.err.println("Error while reading class file of " + url);
            }
            throw e;
        }
    }

    public ClassFile(byte[] buffer) {
        this(buffer, null);
    }

    public ByteArrayInputStream getBytes() {
        return new ByteArrayInputStream(this.buffer);
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public int getModifiers() {
        return this.modifiers & 0xFFFF;
    }

    public String getSignature() {
        if (this.classSignature != null) {
            return this.classSignature.toString();
        }
        return null;
    }

    public boolean isDeprecated() {
        return (this.modifiers & 0x10000) != 0;
    }

    public boolean isHidden() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public String getFullClassName() {
        return this.thisClassName.toString();
    }

    public Name getBaseClass() {
        return this.baseClass;
    }

    public Name[] getBaseInterfaces() {
        if (this.baseInterfaces == null) {
            this.readBaseInterfaces();
        }
        return this.baseInterfaces;
    }

    public Name getOuterClass() {
        return this.outerClass;
    }

    public ClassField[] getDeclaredFields() {
        if (this.fields == null) {
            this.readFields();
        }
        return this.fields;
    }

    public ClassMethod[] getDeclaredMethods() {
        if (this.methods == null) {
            this.readMethods();
        }
        return this.methods;
    }

    public ClassMethod[] getDeclaredConstructors() {
        if (this.constructors == null) {
            this.readMethods();
        }
        return this.constructors;
    }

    public ClassMethod getClinitMethod() {
        if (this.methods == null) {
            this.readMethods();
        }
        return this.clinit;
    }

    public Name[] getDeclaredInnerClasses() {
        return this.innerClasses;
    }

    public ClassAnnotation[] getDeclaredAnnotations() {
        return this.classAnnotations;
    }

    public Collection<TypeAnnotation> getTypeAnnotations() {
        return this.typeAnnotations;
    }

    public String getSourceFilename() {
        if (this.sourceFilename == null) {
            return null;
        }
        return this.sourceFilename.toString();
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean isLocal() {
        return !this.isAnonymous() && this.enclosingMethodIndex > 0;
    }

    public String getEnclosingClassName() {
        Name name;
        if (this.isValidPoolIndex(this.enclosingClassIndex) && (name = this.readPoolName(this.enclosingClassIndex)) != null) {
            return name.toString();
        }
        return null;
    }

    public String getEnclosingMethodName() {
        return this.getEnclosingMethodDetail(0);
    }

    public String getEnclosingMethodDescriptor() {
        return this.getEnclosingMethodDetail(1);
    }

    private String getEnclosingMethodDetail(int index) {
        if (this.isValidPoolIndex(this.enclosingMethodIndex)) {
            Name[] names;
            int byteIndex = this.poolIdx[this.enclosingMethodIndex];
            if (this.buffer[byteIndex] != 12) {
                this.fileError("Expected CONSTANT_NameandType index");
            }
            if ((names = (Name[])this.readPoolObject(this.enclosingMethodIndex)) != null && names.length > index && names[index] != null) {
                return names[index].toString();
            }
        }
        return null;
    }

    private void readHeader() {
        int magic = this.nextInt();
        if (magic != -889275714) {
            this.fileError("Bad magic number");
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion * 100 + minorVersion < 4503) {
            this.fileError("Wrong version");
        }
        this.indexConstantPool();
        this.modifiers = this.nextChar();
        this.thisClassName = (Name)this.readPoolObject(this.nextChar());
        this.baseClass = this.readPoolClass(this.nextChar());
        this.implBp = this.bp;
        char interfaceCount = this.nextChar();
        this.bp += 2 * interfaceCount;
        this.fieldBp = this.bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            int fieldCount = this.nextChar();
            for (int i = 0; i < fieldCount; ++i) {
                this.skipFieldOrMethod();
            }
            this.methodBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int methodCount = this.nextChar();
            for (int i = 0; i < methodCount; ++i) {
                this.skipFieldOrMethod();
            }
            this.attrBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBaseInterfaces() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.baseInterfaces != null) {
                return;
            }
            try {
                int savedBp = this.bp;
                this.bp = this.implBp;
                int interfaceCount = this.nextChar();
                Name[] newBaseInterfaces = new Name[interfaceCount];
                for (int i = 0; i < interfaceCount; ++i) {
                    Name n = this.readPoolClass(this.nextChar());
                    if (n == null) {
                        String message = "Invalid reference";
                        this.fileError("Invalid reference");
                        continue;
                    }
                    newBaseInterfaces[i] = n;
                }
                this.bp = savedBp;
                this.baseInterfaces = newBaseInterfaces;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw this.updateException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.fields != null) {
                return;
            }
            try {
                int savedBp = this.bp;
                this.bp = this.fieldBp;
                int fieldCount = this.nextChar();
                ClassField[] newFields = ClassFile.createFieldArray(fieldCount);
                for (int i = 0; i < fieldCount; ++i) {
                    newFields[i] = new ClassField();
                }
                if (this.methodBp == 0) {
                    this.methodBp = this.bp;
                } else {
                    this.bp = savedBp;
                }
                this.fields = newFields;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw this.updateException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methods != null) {
                return;
            }
            try {
                int savedBp = this.bp;
                if (this.methodBp == 0) {
                    this.indexFields();
                }
                this.bp = this.methodBp;
                int methodCount = this.nextChar();
                if (methodCount == 0) {
                    this.methods = EMPTY_METHOD_ARRAY;
                    this.constructors = EMPTY_METHOD_ARRAY;
                    this.clinit = null;
                } else {
                    ClassMethod[] allMethods = new ClassMethod[methodCount];
                    int nConstructors = 0;
                    int nClInit = 0;
                    for (int i = 0; i < methodCount; ++i) {
                        ClassMethod m;
                        allMethods[i] = m = new ClassMethod();
                        if (m.isConstructor()) {
                            ++nConstructors;
                            continue;
                        }
                        if (!m.isClinit()) continue;
                        ++nClInit;
                    }
                    ClassMethod[] newMethods = ClassFile.createMethodArray(methodCount - nConstructors - nClInit);
                    ClassMethod[] newConstructors = ClassFile.createMethodArray(nConstructors);
                    ClassMethod newClinit = null;
                    int m = 0;
                    int c = 0;
                    for (int i = 0; i < methodCount; ++i) {
                        ClassMethod method = allMethods[i];
                        if (method.isConstructor()) {
                            newConstructors[c++] = method;
                            continue;
                        }
                        if (method.isClinit()) {
                            if (newClinit != null) {
                                // empty if block
                            }
                            newClinit = method;
                            continue;
                        }
                        newMethods[m++] = method;
                    }
                    this.constructors = newConstructors;
                    this.clinit = newClinit;
                    this.methods = newMethods;
                }
                if (this.attrBp == 0) {
                    this.attrBp = this.bp;
                } else {
                    this.bp = savedBp;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw this.updateException(ex);
            }
        }
    }

    private void readInnerClasses() {
        int count = this.nextChar();
        Name[] preliminary = new Name[count];
        int actual = 0;
        while (count-- > 0) {
            Name inner = this.readPoolClass(this.nextChar());
            Name outer = this.readPoolClass(this.nextChar());
            char innerNameIndex = this.nextChar();
            char flags = this.nextChar();
            if (outer != null && outer.equals(this.thisClassName)) {
                preliminary[actual++] = inner;
                continue;
            }
            if (inner == null) continue;
            if (inner.equals(this.thisClassName)) {
                int tmpMods = this.modifiers & 0xFFFFFFFE;
                this.outerClass = outer;
                this.modifiers = tmpMods | flags & 0xF;
                this.isAnonymous = innerNameIndex == '\u0000';
                continue;
            }
            try {
                String innerClassName = inner.toString();
                if (innerClassName.startsWith(this.getFullClassName())) {
                    preliminary[actual++] = inner;
                    continue;
                }
                if (!this.getFullClassName().startsWith(innerClassName + "$")) continue;
                this.outerClass = inner;
            }
            catch (Exception ex) {
                Assert.printStackTrace(ex);
            }
        }
        if (actual == 0) {
            this.innerClasses = Name.EMPTY_ARRAY;
        } else {
            this.innerClasses = new Name[actual];
            System.arraycopy(preliminary, 0, this.innerClasses, 0, actual);
        }
    }

    private void readEnclosingMethodAttribute() {
        this.enclosingClassIndex = this.nextChar();
        this.enclosingMethodIndex = this.nextChar();
    }

    private void readClassAttributes() {
        int savedBp = this.bp;
        if (this.attrBp == 0) {
            this.indexMethods();
        }
        try {
            this.bp = this.attrBp;
            int attrCount = this.nextChar();
            block16: for (int i = 0; i < attrCount; ++i) {
                char attrIndex = this.nextChar();
                int attrLen = this.nextInt();
                int attrSavedBp = this.bp;
                Name attrName = this.readPoolName(attrIndex);
                byte attribute = ClassFile.name2attribute(attrName);
                switch (attribute) {
                    case 4: {
                        this.modifiers |= 0x10000;
                        continue block16;
                    }
                    case 21: {
                        this.modifiers |= 0x20000000;
                        continue block16;
                    }
                    case 18: {
                        this.classSignature = this.readPoolExternal(this.nextChar());
                        continue block16;
                    }
                    case 20: {
                        this.modifiers |= 0x1000;
                        continue block16;
                    }
                    case 12: 
                    case 15: {
                        this.classAnnotations = this.readAnnotations(this.classAnnotations);
                        int endBp = attrSavedBp + attrLen;
                        if (this.bp != endBp) {
                            this.fileError("Invalid class annotations length");
                        }
                        this.bp = endBp;
                        continue block16;
                    }
                    case 14: 
                    case 17: {
                        int endBp = attrSavedBp + attrLen;
                        this.typeAnnotations = this.readTypeAnnotations(this.typeAnnotations, endBp);
                        if (this.bp != endBp) {
                            this.fileError("Invalid class type annotations length");
                        }
                        this.bp = endBp;
                        continue block16;
                    }
                    case 19: {
                        this.sourceFilename = this.readPoolName(this.nextChar());
                        continue block16;
                    }
                    case 7: {
                        this.readInnerClasses();
                        continue block16;
                    }
                    case 5: {
                        this.readEnclosingMethodAttribute();
                        continue block16;
                    }
                    default: {
                        this.bp += attrLen;
                    }
                }
            }
            if (this.innerClasses == null) {
                this.innerClasses = Name.EMPTY_ARRAY;
            }
            if (this.classAnnotations == null) {
                this.classAnnotations = EMPTY_ANNOTATION_ARRAY;
            }
            if (this.typeAnnotations == null) {
                this.typeAnnotations = Collections.emptyList();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw this.updateException(ex);
        }
        finally {
            this.bp = savedBp;
        }
    }

    private ArrayIndexOutOfBoundsException updateException(ArrayIndexOutOfBoundsException original) {
        try {
            String name = null;
            if (this.url != null) {
                name = this.url.getPath();
            } else if (this.sourceFilename != null) {
                name = this.sourceFilename.toString();
            } else if (this.thisClassName != null) {
                name = this.thisClassName.toString();
            }
            int len = this.buffer.length;
            StringBuilder buf = new StringBuilder();
            buf.append(original.getMessage());
            buf.append(". File/Class name = ");
            buf.append(String.valueOf(name));
            buf.append(". Buffer length = ");
            buf.append(len);
            return new ArrayIndexOutOfBoundsException(buf.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return original;
        }
    }

    private void indexConstantPool() {
        int entryCount = this.nextChar();
        this.poolIdx = new int[entryCount];
        this.poolObj = new Object[entryCount];
        int i = 1;
        block7: while (i < entryCount) {
            this.poolIdx[i++] = this.bp;
            byte tag = this.buffer[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.bp += len;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.bp += 2;
                    continue block7;
                }
                case 15: {
                    this.bp += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.bp += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    continue block7;
                }
            }
            this.fileError("Bad constant pool tag: " + tag);
        }
    }

    private boolean isValidPoolIndex(int poolIndex) {
        return poolIndex > 0 && poolIndex < this.poolObj.length;
    }

    private Object readPoolObject(int poolIndex) {
        Object o;
        if (!this.isValidPoolIndex(poolIndex)) {
            this.fileError("Invalid pool index");
        }
        if (this.poolObj[poolIndex] != null) {
            return this.poolObj[poolIndex];
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (byteIndex == 0) {
            return null;
        }
        this.poolObj[poolIndex] = o = this.readPoolObjectImpl(byteIndex);
        return o;
    }

    private Object readPoolObjectImpl(int byteIndex) {
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 1: {
                return NamePool.fromUTF(this.buffer, byteIndex + 3, this.getChar(byteIndex + 1));
            }
            case 7: {
                return this.readPoolExternal(this.getChar(byteIndex + 1));
            }
            case 2: {
                this.fileError("Can't read unicode");
                break;
            }
            case 8: {
                Name n = (Name)this.readPoolObject(this.getChar(byteIndex + 1));
                return n.toString();
            }
            case 3: {
                int i = this.getInt(byteIndex + 1);
                return new Integer(i);
            }
            case 4: {
                float f = Float.intBitsToFloat(this.getInt(byteIndex + 1));
                return new Float(f);
            }
            case 5: {
                long l = this.getLong(byteIndex + 1);
                return new Long(l);
            }
            case 6: {
                double d = Double.longBitsToDouble(this.getLong(byteIndex + 1));
                return new Double(d);
            }
            case 12: {
                Name n1 = (Name)this.readPoolObject(this.getChar(byteIndex + 1));
                Name n2 = (Name)this.readPoolObject(this.getChar(byteIndex + 3));
                return new Name[]{n1, n2};
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: {
                this.fileError("Shouldn't be handling these attributes: " + tag);
                break;
            }
            default: {
                this.fileError("Bad constant pool tag: " + tag);
            }
        }
        return null;
    }

    private Object readPoolConstant(int poolIndex, char descriptor) {
        switch (descriptor) {
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 's': {
                return this.readPoolObject(poolIndex);
            }
            case 'c': {
                return this.readPoolName(poolIndex);
            }
            case '@': 
            case '[': 
            case 'e': {
                return null;
            }
        }
        Integer i = (Integer)this.readPoolObject(poolIndex);
        if (i == null) {
            return null;
        }
        switch (descriptor) {
            case 'S': {
                return new Short((short)i.intValue());
            }
            case 'C': {
                return new Character((char)i.intValue());
            }
            case 'B': {
                return new Byte((byte)i.intValue());
            }
            case 'Z': {
                if (i == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        this.fileError("Invalid type for a ConstantValue attribute");
        return null;
    }

    private Name readPoolName(int poolIndex) {
        return (Name)this.readPoolObject(poolIndex);
    }

    private Name readPoolExternal(int poolIndex) {
        if (this.poolObj[poolIndex] == null) {
            int byteIndex = this.poolIdx[poolIndex];
            if (this.buffer[byteIndex] == 1) {
                this.poolObj[poolIndex] = NamePool.fromUTF(this.buffer, byteIndex + 3, this.getChar(byteIndex + 1));
            } else {
                this.fileError("Expected CONSTANT_Utf8 index");
            }
        }
        return (Name)this.poolObj[poolIndex];
    }

    private Name readPoolClass(int poolIndex) {
        if (poolIndex == 0) {
            return null;
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (this.buffer[byteIndex] != 7) {
            this.fileError("Expected CONSTANT_Class index");
        }
        return (Name)this.readPoolObject(poolIndex);
    }

    private byte nextByte() {
        return this.buffer[this.bp++];
    }

    private char nextChar() {
        int b = this.bp;
        char ch = (char)((this.buffer[b] & 0xFF) << 8 | this.buffer[b + 1] & 0xFF);
        this.bp += 2;
        return ch;
    }

    private int nextInt() {
        int b = this.bp;
        int i = (this.buffer[b] & 0xFF) << 24 | (this.buffer[b + 1] & 0xFF) << 16 | (this.buffer[b + 2] & 0xFF) << 8 | this.buffer[b + 3] & 0xFF;
        this.bp += 4;
        return i;
    }

    private byte getByte(int b) {
        return this.buffer[b];
    }

    private char getChar(int b) {
        return (char)((this.buffer[b] & 0xFF) << 8 | this.buffer[b + 1] & 0xFF);
    }

    private int getInt(int b) {
        return (this.buffer[b] & 0xFF) << 24 | (this.buffer[b + 1] & 0xFF) << 16 | (this.buffer[b + 2] & 0xFF) << 8 | this.buffer[b + 3] & 0xFF;
    }

    private long getLong(int b) {
        long hi = this.getInt(b);
        long lo = this.getInt(b + 4);
        return hi << 32 | lo & 0xFFFFFFFFL;
    }

    public final synchronized void dump(PrintStream out) {
        String filename;
        int mods = this.modifiers;
        ClassFile.dumpModifiers(out, mods, true, false);
        if ((mods & 0x2000) != 0) {
            out.print("@interface ");
        } else if ((mods & 0x200) != 0) {
            out.print("interface ");
        } else if ((mods & 0x4000) != 0) {
            out.print("enum ");
        } else {
            out.print("class ");
        }
        out.println(this.getFullClassName());
        if (this.getBaseClass() != null) {
            out.println("  extends " + this.getBaseClass().toString());
        }
        Name[] interfaces = this.getBaseInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            out.println("  implements " + interfaces[i].toString());
        }
        String signature = this.getSignature();
        if (signature != null) {
            out.println("  signature: " + signature);
        }
        if ((filename = this.getSourceFilename()) != null) {
            out.println("SourceFile: " + filename);
        }
        ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
        out.println();
        this.dumpConstantPool(out);
        this.dumpAttributes(out, this.attrBp);
        out.println("Fields:");
        ClassField[] fields = this.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].dump(out);
        }
        out.println();
        out.println("Constructors:");
        ClassMethod[] constructors = this.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            constructors[i].dump(out);
        }
        out.println();
        out.println("Methods:");
        ClassMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            methods[i].dump(out);
        }
        out.println();
    }

    private void dumpConstantPool(PrintStream out) {
        out.println("Constant pool:");
        for (int i = 1; i < this.poolIdx.length; ++i) {
            out.print(i + "\t");
            this.dumpPoolObject(out, i);
            out.println();
            int byteIndex = this.poolIdx[i];
            byte tag = this.buffer[byteIndex];
            if (tag != 5 && tag != 6) continue;
            ++i;
        }
        out.println();
    }

    private void dumpPoolObject(PrintStream out, int poolIndex) {
        int byteIndex = this.poolIdx[poolIndex];
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 1: {
                out.print("(Utf8) ");
                break;
            }
            case 7: {
                char ref = this.getChar(byteIndex + 1);
                out.print("(Class) #" + ref + ": ");
                break;
            }
            case 2: {
                out.print("(Unicode) ??");
                return;
            }
            case 8: {
                char ref = this.getChar(byteIndex + 1);
                out.print("(String) #" + ref + ": ");
                break;
            }
            case 3: {
                out.print("(Integer) ");
                break;
            }
            case 4: {
                out.print("(Float) ");
                break;
            }
            case 5: {
                out.print("(Long) ");
                break;
            }
            case 6: {
                out.print("(Double) ");
                break;
            }
            case 12: {
                char nameref = this.getChar(byteIndex + 1);
                char typeref = this.getChar(byteIndex + 3);
                out.print("(NameandTypeRef) ");
                out.print("#" + nameref + " #" + typeref + ": ");
                break;
            }
            case 9: {
                out.print("(Fieldref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 10: {
                out.print("(Methodref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 11: {
                out.print("(InterfaceMethodref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 15: {
                out.print("(MethodHandle) ");
                byte refKind = this.getByte(byteIndex + 1);
                char refIndex = this.getChar(byteIndex + 2);
                out.print("#" + refKind + " #" + refIndex + ": ");
                break;
            }
            case 16: {
                out.print("(MethodType) ");
                char signatureIndex = this.getChar(byteIndex + 1);
                out.print("#" + signatureIndex + ": ");
                break;
            }
            case 18: {
                out.print("(InvokeDynamic) ");
                char methodIndex = this.getChar(byteIndex + 1);
                char nameTypeIndex = this.getChar(byteIndex + 3);
                out.print("#" + methodIndex + " #" + nameTypeIndex + ": ");
                break;
            }
            default: {
                this.fileError("Bad constant pool tag: " + tag);
            }
        }
        this.dumpPoolObjectImpl(out, poolIndex);
    }

    private void dumpPoolObjectImpl(PrintStream out, int poolIndex) {
        int byteIndex = this.poolIdx[poolIndex];
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 7: 
            case 8: 
            case 16: {
                char ref = this.getChar(byteIndex + 1);
                this.dumpPoolObjectImpl(out, ref);
                return;
            }
            case 12: {
                char nameref = this.getChar(byteIndex + 1);
                char typeref = this.getChar(byteIndex + 3);
                this.dumpPoolObjectImpl(out, nameref);
                out.print(", ");
                this.dumpPoolObjectImpl(out, typeref);
                return;
            }
            case 9: 
            case 10: 
            case 11: {
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                this.dumpPoolObjectImpl(out, classref);
                out.print(".");
                this.dumpPoolObjectImpl(out, nametyperef);
                return;
            }
            case 18: {
                char bootStrapMethodRef = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#");
                out.print((int)bootStrapMethodRef);
                out.print(": ");
                this.dumpPoolObjectImpl(out, nametyperef);
                return;
            }
            case 15: {
                byte kind = this.getByte(byteIndex + 1);
                char methodRef = this.getChar(byteIndex + 2);
                out.print(kind);
                out.print(", ");
                this.dumpPoolObjectImpl(out, methodRef);
                return;
            }
        }
        Object o = this.readPoolObject(poolIndex);
        if (o != null) {
            out.print(o);
        }
    }

    private static void dumpModifiers(PrintStream out, int modifiers, boolean isClass, boolean isField) {
        if ((modifiers & 1) != 0) {
            out.print("public ");
        }
        if ((modifiers & 2) != 0) {
            out.print("private ");
        }
        if ((modifiers & 4) != 0) {
            out.print("protected ");
        }
        if ((modifiers & 8) != 0) {
            out.print("static ");
        }
        if ((modifiers & 0x10) != 0) {
            out.print("final ");
        }
        if (!isClass && (modifiers & 0x20) != 0) {
            out.print("synchronized ");
        }
        if (isField) {
            if ((modifiers & 0x40) != 0) {
                out.print("volatile ");
            }
            if ((modifiers & 0x80) != 0) {
                out.print("transient ");
            }
        }
        if ((modifiers & 0x100) != 0) {
            out.print("native ");
        }
        if ((modifiers & 0x400) != 0) {
            out.print("abstract ");
        }
        if ((modifiers & 0x800) != 0) {
            out.print("strictfp ");
        }
        if ((modifiers & 0x1000) != 0) {
            out.print("(synthetic) ");
        }
        if ((modifiers & 0x2000) != 0) {
            out.print("(annotation) ");
        }
        if ((modifiers & 0x4000) != 0) {
            out.print("(enum) ");
        }
        if ((modifiers & 0x10000) != 0) {
            out.print("@deprecated ");
        }
        if ((modifiers & 0x20000000) != 0) {
            out.print("@hidden ");
        }
    }

    private static void dumpAnnotations(PrintStream out, ClassAnnotation[] a) {
        if (a.length == 0) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            a[i].dump(out);
        }
    }

    private static ClassField[] createFieldArray(int size) {
        if (size == 0) {
            return EMPTY_FIELD_ARRAY;
        }
        return new ClassField[size];
    }

    private static ClassMethod[] createMethodArray(int size) {
        if (size == 0) {
            return EMPTY_METHOD_ARRAY;
        }
        return new ClassMethod[size];
    }

    public TargetInfo parseTargetInfo() {
        byte targetType = this.nextByte();
        switch (targetType) {
            case 0: {
                return new ParamTargetInfo(TargetInfoType.CLASS_TYPE_PARAMETER);
            }
            case 1: {
                return new ParamTargetInfo(TargetInfoType.METHOD_TYPE_PARAMETER);
            }
            case 16: {
                return new SuperTargetInfo(TargetInfoType.CLASS_EXTENDS);
            }
            case 17: {
                return new TypeParamBoundTargetInfo(TargetInfoType.CLASS_TYPE_PARAMETER_BOUND);
            }
            case 18: {
                return new TypeParamBoundTargetInfo(TargetInfoType.METHOD_TYPE_PARAMETER_BOUND);
            }
            case 19: {
                return new TargetInfo(TargetInfoType.FIELD, true);
            }
            case 20: {
                return new TargetInfo(TargetInfoType.METHOD_RETURN, true);
            }
            case 21: {
                return new TargetInfo(TargetInfoType.METHOD_RECEIVER, true);
            }
            case 22: {
                return new ParamTargetInfo(TargetInfoType.METHOD_PARAMETER);
            }
            case 23: {
                return new ThrowsTargetInfo(TargetInfoType.THROWS);
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                return null;
            }
        }
        String msg = "Unknown target info kind";
        Assert.printStackTrace(msg);
        throw new IllegalStateException(msg);
    }

    private void skipFieldOrMethod() {
        this.bp += 6;
        int attrCount = this.nextChar();
        for (int i = 0; i < attrCount; ++i) {
            this.bp += 2;
            int attrLen = this.nextInt();
            this.bp += attrLen;
        }
    }

    private void skipAnnotation() {
        this.bp += 2;
        int count = this.nextChar();
        for (int i = 0; i < count; ++i) {
            this.skipComponent();
        }
    }

    private void skipComponent() {
        this.bp += 2;
        this.skipComponentValue();
    }

    private void skipComponentValue() {
        byte tag = this.nextByte();
        this.skipValue(tag);
    }

    private void skipValue(byte componentTag) {
        switch (componentTag) {
            case 64: {
                this.skipAnnotation();
                break;
            }
            case 91: {
                int count = this.nextChar();
                for (int i = 0; i < count; ++i) {
                    this.skipComponentValue();
                }
                break;
            }
            case 101: {
                this.bp += 4;
                break;
            }
            default: {
                this.bp += 2;
            }
        }
    }

    private ClassAnnotation[] readAnnotations(ClassAnnotation[] oldArray) {
        int oldCount;
        int count;
        if (oldArray == null) {
            oldArray = EMPTY_ANNOTATION_ARRAY;
        }
        ClassAnnotation[] newArray = (count = (oldCount = oldArray.length) + this.nextChar()) > 0 ? new ClassAnnotation[count] : EMPTY_ANNOTATION_ARRAY;
        if (oldCount > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
        }
        for (int i = oldCount; i < count; ++i) {
            newArray[i] = new ClassAnnotation();
        }
        return newArray;
    }

    private List<TypeAnnotation> readTypeAnnotations(List<TypeAnnotation> typeAnnotations, int endBp) {
        if (typeAnnotations == null) {
            typeAnnotations = new ArrayList<TypeAnnotation>();
        }
        int count = this.nextChar();
        try {
            for (int i = 0; i < count; ++i) {
                typeAnnotations.add(new TypeAnnotation());
            }
        }
        catch (IllegalStateException ex) {
            this.bp = endBp;
        }
        return typeAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAttributes(PrintStream out, int targetBp) {
        ClassFile classFile = this;
        synchronized (classFile) {
            int savedBp = this.bp;
            try {
                this.bp = targetBp;
                int attrCount = this.nextChar();
                for (int i = 0; i < attrCount; ++i) {
                    char attrIndex = this.nextChar();
                    int attrLen = this.nextInt();
                    int attrSavedBp = this.bp;
                    Name attrName = this.readPoolName(attrIndex);
                    out.println("  '" + attrName + "' (" + attrLen + ')');
                    if (attrLen > 0) {
                        out.print("    ");
                        for (int j = 0; j < attrLen; ++j) {
                            if (j > 0 && j % 24 == 0) {
                                out.println();
                                out.print("    ");
                            }
                            int ii = this.nextByte();
                            out.print(ClassFile.x(ii &= 0xFF, 2) + ' ');
                        }
                        out.println();
                        this.dumpAttribute(out, attrName, attrSavedBp);
                    }
                    this.bp = attrSavedBp + attrLen;
                }
            }
            finally {
                this.bp = savedBp;
            }
        }
    }

    private void dumpAttribute(PrintStream out, Name attrName, int targetBp) {
        this.bp = targetBp;
        byte attribute = ClassFile.name2attribute(attrName);
        switch (attribute) {
            case 18: 
            case 19: {
                this.dumpAttribute_Name(out);
                break;
            }
            case 7: {
                this.dumpInnerClasses(out);
                break;
            }
            case 11: {
                this.dumpMethodParameters(out);
            }
        }
    }

    private void dumpMethodParameters(PrintStream out) {
        int count = 0xFF & this.nextByte();
        for (int x = 0; x < count; ++x) {
            Name name = this.readPoolName(this.nextChar());
            char flags = this.nextChar();
            out.println("      Method parameter name: " + name.toString() + " flags: 0X" + Integer.toHexString(flags));
        }
        out.println();
    }

    private void dumpInnerClasses(PrintStream out) {
        int count = this.nextChar();
        while (count-- > 0) {
            Name inner = this.readPoolClass(this.nextChar());
            Name outer = this.readPoolClass(this.nextChar());
            out.println("      Inner name: " + inner);
            out.println("      Outer name: " + outer);
            char unknown = this.nextChar();
            out.println("      <unknown>: " + ClassFile.x(unknown, 4));
            char flags = this.nextChar();
            out.println("      Modifiers: " + ClassFile.x(flags, 4));
            out.println();
        }
    }

    private void dumpAttribute_Name(PrintStream out) {
        Name name = this.readPoolName(this.nextChar());
        out.println("      \"" + name + "\"");
        out.println();
    }

    private static String x(int i, int width) {
        String s = Integer.toHexString(i);
        while (s.length() < width) {
            s = '0' + s;
        }
        return s;
    }

    private void fileError(String msg) {
        String filename = this.url != null ? this.url.getPath() : "";
        String finalMessage = filename.trim().length() > 0 ? msg + " in file " + filename : msg;
        throw new RuntimeException(finalMessage);
    }

    static {
        int count = 21;
        ATTRIBUTE_indices = new HashMap<Name, Byte>(21);
        for (int i = 0; i < 21; ++i) {
            Name name = NamePool.fromString(ATTRIBUTE_words[i]);
            ATTRIBUTE_indices.put(name, (byte)(i + 1));
        }
        kInitS = NamePool.fromString("<init>");
        kClinitS = NamePool.fromString("<clinit>");
        ___constant_pool = 0;
    }

    public static class TargetInfoPath {
        private byte pathKind;
        private byte argumentIndex;

        public TargetInfoPath(byte pathKind, byte argumentIndex) {
            this.pathKind = pathKind;
            this.argumentIndex = argumentIndex;
        }

        public byte getPathKind() {
            return this.pathKind;
        }

        public byte getArgumentIndex() {
            return this.argumentIndex;
        }

        public boolean equals(Object object) {
            if (object instanceof TargetInfoPath) {
                TargetInfoPath other = (TargetInfoPath)object;
                return this.pathKind == other.pathKind && this.argumentIndex == other.argumentIndex;
            }
            return false;
        }

        public int hashCode() {
            return this.pathKind * 37 + this.argumentIndex;
        }
    }

    public class TargetInfoPaths {
        private List<TargetInfoPath> paths;

        private TargetInfoPaths() {
            byte count = ClassFile.this.nextByte();
            this.paths = new ArrayList<TargetInfoPath>(count);
            for (byte b = 0; b < count; b = (byte)(b + 1)) {
                byte pathKind = ClassFile.this.nextByte();
                byte argumentIndex = ClassFile.this.nextByte();
                this.paths.add(new TargetInfoPath(pathKind, argumentIndex));
            }
        }

        public List<TargetInfoPath> getPaths() {
            return this.paths;
        }
    }

    public static enum TargetInfoType {
        CLASS_EXTENDS,
        CLASS_TYPE_PARAMETER,
        CLASS_TYPE_PARAMETER_BOUND,
        FIELD,
        METHOD_PARAMETER,
        METHOD_RECEIVER,
        METHOD_RETURN,
        METHOD_TYPE_PARAMETER,
        METHOD_TYPE_PARAMETER_BOUND,
        THROWS,
        TYPECAST;

    }

    public class TypeParamBoundTargetInfo
    extends TargetInfo {
        private byte paramIndex;
        private byte boundIndex;

        private TypeParamBoundTargetInfo(TargetInfoType targetInfoType) {
            super(targetInfoType, false);
            this.paramIndex = ClassFile.this.nextByte();
            this.boundIndex = ClassFile.this.nextByte();
            this.readTargetInfoPaths();
        }

        public byte getParamIndex() {
            return this.paramIndex;
        }

        public byte getBoundIndex() {
            return this.boundIndex;
        }
    }

    public class SuperTargetInfo
    extends TargetInfo {
        private char superIndex;

        private SuperTargetInfo(TargetInfoType targetInfoType) {
            super(targetInfoType, false);
            this.superIndex = ClassFile.this.nextChar();
            this.readTargetInfoPaths();
        }

        public char getSuperIndex() {
            return this.superIndex;
        }
    }

    public class ThrowsTargetInfo
    extends TargetInfo {
        private char typeIndex;

        private ThrowsTargetInfo(TargetInfoType targetInfoType) {
            super(targetInfoType, false);
            this.typeIndex = ClassFile.this.nextChar();
            this.readTargetInfoPaths();
        }

        public char getTypeIndex() {
            return this.typeIndex;
        }
    }

    public class ParamTargetInfo
    extends TargetInfo {
        private byte paramIndex;

        private ParamTargetInfo(TargetInfoType targetInfoType) {
            super(targetInfoType, false);
            this.paramIndex = ClassFile.this.nextByte();
            this.readTargetInfoPaths();
        }

        public byte getParamIndex() {
            return this.paramIndex;
        }
    }

    public class TargetInfo {
        private TargetInfoPaths targetInfoPaths;
        private TargetInfoType targetInfoType;

        private TargetInfo(TargetInfoType targetInfoType, boolean readTargetInfoPaths) {
            this.targetInfoType = targetInfoType;
            if (readTargetInfoPaths) {
                this.readTargetInfoPaths();
            }
        }

        protected void readTargetInfoPaths() {
            this.targetInfoPaths = new TargetInfoPaths();
        }

        public TargetInfoPaths getTargetInfoPaths() {
            return this.targetInfoPaths;
        }

        public TargetInfoType getTargetInfoType() {
            return this.targetInfoType;
        }
    }

    public final class TypeAnnotation {
        private ClassAnnotation classAnnotation;
        private TargetInfo targetInfo;

        private TypeAnnotation() {
            this.targetInfo = ClassFile.this.parseTargetInfo();
            this.classAnnotation = new ClassAnnotation();
        }

        public TargetInfo getTargetInfo() {
            return this.targetInfo;
        }

        public ClassAnnotation getClassAnnotation() {
            return this.classAnnotation;
        }
    }

    public final class EnumReference {
        final Name enumClassname;
        final Name enumName;

        EnumReference(int classIndex, int enumIndex) {
            this.enumClassname = (Name)ClassFile.this.readPoolConstant(classIndex, 'c');
            this.enumName = ClassFile.this.readPoolName(enumIndex);
        }

        private void dump(PrintStream out) {
            out.print("(Enum) " + this.enumClassname.toString() + '.' + this.enumName);
        }
    }

    public final class ComponentValue {
        private final byte tag;
        private final int valueBp;
        private Object value;

        private ComponentValue() {
            this.tag = ClassFile.this.nextByte();
            this.valueBp = ClassFile.this.bp;
            ClassFile.this.skipValue(this.tag);
        }

        public final char getComponentTag() {
            return (char)(this.tag & 0xFF);
        }

        public final Object getComponentValue() {
            if (this.value == null) {
                this.value = this.readValue();
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object readValue() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.value != null) {
                    return this.value;
                }
                switch (this.tag) {
                    case 101: {
                        char classindex = ClassFile.this.getChar(this.valueBp);
                        char enumindex = ClassFile.this.getChar(this.valueBp + 2);
                        return new EnumReference(classindex, enumindex);
                    }
                    case 91: {
                        int count = ClassFile.this.getChar(this.valueBp);
                        if (count == 0) {
                            return EMPTY_VALUE_ARRAY;
                        }
                        ComponentValue[] values = new ComponentValue[count];
                        int savedBp = ClassFile.this.bp;
                        try {
                            ClassFile.this.bp = this.valueBp + 2;
                            for (int i = 0; i < count; ++i) {
                                values[i] = new ComponentValue();
                            }
                            ComponentValue[] componentValueArray = values;
                            return componentValueArray;
                        }
                        finally {
                            ClassFile.this.bp = savedBp;
                        }
                    }
                    case 64: {
                        int savedBp = ClassFile.this.bp;
                        try {
                            ClassFile.this.bp = this.valueBp;
                            ClassAnnotation values = new ClassAnnotation();
                            return values;
                        }
                        finally {
                            ClassFile.this.bp = savedBp;
                        }
                    }
                }
                char index = ClassFile.this.getChar(this.valueBp);
                return ClassFile.this.readPoolConstant(index, this.getComponentTag());
            }
        }

        private void dump(PrintStream out) {
            Object o = this.getComponentValue();
            this.dump(out, o, this.tag);
        }

        private void dump(PrintStream out, Object o, byte tag) {
            switch (tag) {
                case 66: 
                case 67: 
                case 68: 
                case 73: 
                case 74: 
                case 83: 
                case 90: {
                    out.print(o);
                    break;
                }
                case 115: {
                    out.print('\"' + o.toString() + '\"');
                    break;
                }
                case 64: {
                    ClassAnnotation a = (ClassAnnotation)o;
                    a.dump(out);
                    break;
                }
                case 99: {
                    out.print("(Class) " + o.toString());
                    break;
                }
                case 101: {
                    EnumReference e = (EnumReference)o;
                    e.dump(out);
                    break;
                }
                case 91: {
                    ComponentValue[] componentValues;
                    out.print('{');
                    for (ComponentValue componentValue : componentValues = (ComponentValue[])o) {
                        this.dump(out, componentValue.readValue(), componentValue.tag);
                    }
                    out.print('}');
                    break;
                }
                default: {
                    CommonUtilities.panic("Unknown component tag: " + tag);
                }
            }
        }
    }

    public class ClassAnnotation {
        private final Name annotationType;
        private final int compBp;
        private String[] componentNames;
        private ComponentValue[] componentValues;

        private ClassAnnotation() {
            this.annotationType = (Name)ClassFile.this.readPoolConstant(ClassFile.this.nextChar(), 'c');
            this.compBp = ClassFile.this.bp;
            int count = ClassFile.this.nextChar();
            for (int i = 0; i < count; ++i) {
                ClassFile.this.skipComponent();
            }
        }

        public final Name getAnnotationType() {
            return this.annotationType;
        }

        public final String[] getComponentNames() {
            if (this.componentNames == null) {
                this.readComponents();
            }
            return this.componentNames;
        }

        public final ComponentValue[] getComponentValues() {
            if (this.componentValues == null) {
                this.readComponents();
            }
            return this.componentValues;
        }

        private final void dump(PrintStream out) {
            String type = this.annotationType.toString();
            String print = type.substring(1, type.length() - 1);
            out.print('@' + print);
            out.print('(');
            this.readComponents();
            int count = this.componentNames.length;
            boolean needComma = false;
            for (int i = 0; i < count; ++i) {
                if (needComma) {
                    out.print(", ");
                }
                out.print(this.componentNames[i] + " = ");
                this.componentValues[i].dump(out);
                needComma = true;
            }
            out.println(')');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readComponents() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.componentNames != null) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                try {
                    ClassFile.this.bp = this.compBp;
                    int count = ClassFile.this.nextChar();
                    if (count == 0) {
                        this.componentValues = EMPTY_VALUE_ARRAY;
                        this.componentNames = JavaConstants.EMPTY_STRING_ARRAY;
                    } else {
                        String[] newComponentNames = new String[count];
                        ComponentValue[] newComponentValues = new ComponentValue[count];
                        for (int i = 0; i < count; ++i) {
                            newComponentNames[i] = ClassFile.this.readPoolName(ClassFile.this.nextChar()).toString();
                            newComponentValues[i] = new ComponentValue();
                        }
                        this.componentValues = newComponentValues;
                        this.componentNames = newComponentNames;
                    }
                }
                finally {
                    ClassFile.this.bp = savedBp;
                }
            }
        }
    }

    public final class MethodParameter {
        private Name name;
        private char flags;

        private MethodParameter() {
            this.name = ClassFile.this.readPoolName(ClassFile.this.nextChar());
            this.flags = ClassFile.this.nextChar();
        }

        public String getName() {
            return this.name.toString();
        }

        public char getFlags() {
            return this.flags;
        }
    }

    public final class ClassMethod {
        private int thisBp;
        private int modifiers;
        private Name name;
        private String methodDescriptor;
        private String methodSignature;
        private Name[] exceptions;
        private ClassAnnotation[] methodAnnotations;
        private List<TypeAnnotation> typeAnnotations;
        private MethodParameter[] methodParameters;
        private ClassAnnotation[][] parameterAnnotations;
        private ComponentValue defaultValue;

        private ClassMethod() {
            this.thisBp = ClassFile.this.bp;
            this.modifiers = ClassFile.this.nextChar();
            this.name = ClassFile.this.readPoolName(ClassFile.this.nextChar());
            this.methodDescriptor = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
            ClassFile.this.bp = this.thisBp;
            ClassFile.this.skipFieldOrMethod();
        }

        public final int getModifiers() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.modifiers & 0xFFFF;
        }

        public final String getDescriptor() {
            return this.methodDescriptor;
        }

        public final String getSignature() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.methodSignature;
        }

        public final boolean isClinit() {
            return this.name.equals(kClinitS);
        }

        public final boolean isConstructor() {
            return this.name.equals(kInitS);
        }

        public final String getMethodName() {
            return this.name.toString();
        }

        public final boolean isDeprecated() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public final boolean isHidden() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public final Name[] getThrownExceptionTypes() {
            if (this.exceptions == null) {
                this.readMethodAttributes();
            }
            return this.exceptions;
        }

        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.methodAnnotations;
        }

        public Collection<TypeAnnotation> getTypeAnnotations() {
            if (this.typeAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.typeAnnotations;
        }

        public ClassAnnotation[][] getParameterAnnotations() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.parameterAnnotations;
        }

        public ComponentValue getDefaultValue() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.defaultValue;
        }

        public MethodParameter[] getMethodParameters() {
            if (this.methodParameters == null) {
                this.readMethodAttributes();
            }
            return this.methodParameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMethodAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.methodAnnotations != null) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                try {
                    ClassFile.this.bp = this.thisBp + 6;
                    int attrCount = ClassFile.this.nextChar();
                    block18: for (int i = 0; i < attrCount; ++i) {
                        Name attrName = ClassFile.this.readPoolName(ClassFile.this.nextChar());
                        int attrLen = ClassFile.this.nextInt();
                        int attrSavedBp = ClassFile.this.bp;
                        byte attribute = ClassFile.name2attribute(attrName);
                        switch (attribute) {
                            case 4: {
                                this.modifiers |= 0x10000;
                                continue block18;
                            }
                            case 21: {
                                this.modifiers |= 0x20000000;
                                continue block18;
                            }
                            case 18: {
                                this.methodSignature = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
                                continue block18;
                            }
                            case 20: {
                                this.modifiers |= 0x1000;
                                continue block18;
                            }
                            case 1: {
                                this.defaultValue = new ComponentValue();
                                continue block18;
                            }
                            case 6: {
                                int exceptionCount = ClassFile.this.nextChar();
                                this.exceptions = new Name[exceptionCount];
                                for (int j = 0; j < exceptionCount; ++j) {
                                    this.exceptions[j] = ClassFile.this.readPoolClass(ClassFile.this.nextChar());
                                }
                                continue block18;
                            }
                            case 12: 
                            case 15: {
                                this.methodAnnotations = ClassFile.this.readAnnotations(this.methodAnnotations);
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.this.bp != endBp) {
                                    ClassFile.this.fileError("Invalid annotations length");
                                }
                                ClassFile.this.bp = endBp;
                                continue block18;
                            }
                            case 13: 
                            case 16: {
                                int paramCount = ClassFile.this.nextByte();
                                Object array = paramCount > 0 ? new ClassAnnotation[paramCount][] : EMPTY_ANNOTATION_ARRAY_ARRAY;
                                for (int p = 0; p < paramCount; ++p) {
                                    array[p] = this.parameterAnnotations == null ? ClassFile.this.readAnnotations(null) : ClassFile.this.readAnnotations(this.parameterAnnotations[p]);
                                }
                                this.parameterAnnotations = array;
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.this.bp != endBp) {
                                    ClassFile.this.fileError("Invalid annotations length");
                                }
                                ClassFile.this.bp = endBp;
                                continue block18;
                            }
                            case 14: 
                            case 17: {
                                int endBp = attrSavedBp + attrLen;
                                this.typeAnnotations = ClassFile.this.readTypeAnnotations(this.typeAnnotations, endBp);
                                if (ClassFile.this.bp != endBp) {
                                    ClassFile.this.fileError("Invalid type annotations length");
                                }
                                ClassFile.this.bp = endBp;
                                continue block18;
                            }
                            case 11: {
                                int endBp = attrSavedBp + attrLen;
                                int count = 0xFF & ClassFile.this.nextByte();
                                this.methodParameters = new MethodParameter[count];
                                for (int x = 0; x < count; ++x) {
                                    this.methodParameters[x] = new MethodParameter();
                                }
                                if (ClassFile.this.bp != endBp) {
                                    ClassFile.this.fileError("Invalid method parameters length");
                                }
                                ClassFile.this.bp = endBp;
                                continue block18;
                            }
                            default: {
                                ClassFile.this.bp = ClassFile.this.bp + attrLen;
                            }
                        }
                    }
                    if (this.exceptions == null) {
                        this.exceptions = Name.EMPTY_ARRAY;
                    }
                    if (this.methodAnnotations == null) {
                        this.methodAnnotations = EMPTY_ANNOTATION_ARRAY;
                    }
                    if (this.typeAnnotations == null) {
                        this.typeAnnotations = Collections.emptyList();
                    }
                    if (ClassFile.this.isDeprecated()) {
                        this.modifiers |= 0x10000;
                    }
                    if (ClassFile.this.isHidden()) {
                        this.modifiers |= 0x20000000;
                    }
                    if (this.methodParameters == null) {
                        this.methodParameters = EMPTY_METHOD_PARAMETER_ARRAY;
                    }
                }
                finally {
                    ClassFile.this.bp = savedBp;
                }
            }
        }

        private final void dump(PrintStream out) {
            this.readMethodAttributes();
            ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
            ClassFile.dumpModifiers(out, this.modifiers, false, true);
            out.println(this.getMethodName() + ' ' + this.getDescriptor());
            String signature = this.getSignature();
            if (signature != null) {
                out.println("  signature: " + signature);
            }
            Name[] exceptions = this.getThrownExceptionTypes();
            for (int i = 0; i < exceptions.length; ++i) {
                out.println("  throws " + exceptions[i].toString());
            }
            ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
            out.println();
            ClassFile.this.dumpAttributes(out, this.thisBp + 6);
        }
    }

    public final class ClassField {
        private int thisBp;
        private int modifiers;
        private String name;
        private String fieldDescriptor;
        private String fieldSignature;
        private int constantValueIndex = -1;
        private ClassAnnotation[] fieldAnnotations = null;
        private List<TypeAnnotation> typeAnnotations = null;

        private ClassField() {
            this.thisBp = ClassFile.this.bp;
            this.modifiers = ClassFile.this.nextChar();
            this.name = ClassFile.this.readPoolName(ClassFile.this.nextChar()).toString();
            this.fieldDescriptor = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
            ClassFile.this.bp = this.thisBp;
            ClassFile.this.skipFieldOrMethod();
        }

        public final int getModifiers() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            return this.modifiers & 0xFFFF;
        }

        public final String getFieldName() {
            return this.name;
        }

        public final String getDescriptor() {
            return this.fieldDescriptor;
        }

        public final String getSignature() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            return this.fieldSignature;
        }

        public final boolean isDeprecated() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public final boolean isHidden() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public final Object getConstantValue() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            if (this.constantValueIndex < 0) {
                return null;
            }
            int descriptor = this.fieldDescriptor.charAt(0);
            if (descriptor == 76 && this.fieldDescriptor.equals("Ljava/lang/String;")) {
                descriptor = 115;
            }
            return ClassFile.this.readPoolConstant(this.constantValueIndex, (char)descriptor);
        }

        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            return this.fieldAnnotations;
        }

        public Collection<TypeAnnotation> getTypeAnnotations() {
            if (this.typeAnnotations == null) {
                this.readFieldAttributes();
            }
            return this.typeAnnotations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFieldAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.fieldAnnotations != null) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                ClassFile.this.bp = this.thisBp + 6;
                int attrCount = ClassFile.this.nextChar();
                block12: for (int i = 0; i < attrCount; ++i) {
                    Name attrName = ClassFile.this.readPoolName(ClassFile.this.nextChar());
                    int attrLen = ClassFile.this.nextInt();
                    int attrSavedBp = ClassFile.this.bp;
                    byte attribute = ClassFile.name2attribute(attrName);
                    switch (attribute) {
                        case 4: {
                            this.modifiers |= 0x10000;
                            continue block12;
                        }
                        case 21: {
                            this.modifiers |= 0x20000000;
                            continue block12;
                        }
                        case 18: {
                            this.fieldSignature = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
                            continue block12;
                        }
                        case 20: {
                            this.modifiers |= 0x1000;
                            continue block12;
                        }
                        case 12: 
                        case 15: {
                            this.fieldAnnotations = ClassFile.this.readAnnotations(this.fieldAnnotations);
                            int endBp = attrSavedBp + attrLen;
                            if (ClassFile.this.bp != endBp) {
                                ClassFile.this.fileError("Invalid annotations length");
                            }
                            ClassFile.this.bp = endBp;
                            continue block12;
                        }
                        case 14: 
                        case 17: {
                            int endBp = attrSavedBp + attrLen;
                            this.typeAnnotations = ClassFile.this.readTypeAnnotations(this.typeAnnotations, endBp);
                            if (ClassFile.this.bp != endBp) {
                                ClassFile.this.fileError("Invalid type annotations length");
                            }
                            ClassFile.this.bp = endBp;
                            continue block12;
                        }
                        case 3: {
                            this.constantValueIndex = ClassFile.this.nextChar();
                            continue block12;
                        }
                        default: {
                            ClassFile.this.bp = ClassFile.this.bp + attrLen;
                        }
                    }
                }
                if (this.fieldAnnotations == null) {
                    this.fieldAnnotations = EMPTY_ANNOTATION_ARRAY;
                }
                if (this.typeAnnotations == null) {
                    this.typeAnnotations = Collections.emptyList();
                }
                if (ClassFile.this.isDeprecated()) {
                    this.modifiers |= 0x10000;
                }
                if (ClassFile.this.isHidden()) {
                    this.modifiers |= 0x20000000;
                }
                ClassFile.this.bp = savedBp;
            }
        }

        private final void dump(PrintStream out) {
            this.readFieldAttributes();
            ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
            ClassFile.dumpModifiers(out, this.modifiers, false, true);
            out.println(this.getFieldName() + ' ' + this.getDescriptor());
            String signature = this.getSignature();
            if (signature != null) {
                out.println("  signature: " + signature);
            }
            if (this.constantValueIndex > 0) {
                out.print("  constant value: " + this.constantValueIndex + ", ");
                ClassFile.this.dumpPoolObject(out, this.constantValueIndex);
                out.println();
            }
            out.println();
            ClassFile.this.dumpAttributes(out, this.thisBp + 6);
        }
    }
}

