/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.formatter.java;

import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;

public class JavaFormatterBundle
extends ListResourceBundle {
    private static ResourceBundle instance;
    static final Object[][] contents;
    public static final String FORMATTER_USAGE_MESSAGE = "formatter.usage.message";
    public static final String FORMATTER_ERROR_FILE_NOT_FOUND = "formatter.error.file.not.found";
    public static final String FORMATTER_ERROR_READING_CODE_STYLE_OPTION_FILE = "formatter.error.reading.code.style.option.file";
    public static final String FORMATTER_ERROR_INVALID_CODE_STYLE_OPTION_ENTRY = "formatter.error.invalid.code.style.option.entry";
    public static final String FORMATTER_ERROR_CREATE_ONLY_OPTION = "formatter.error.create.only.option";
    public static final String FORMATTER_CODE_STYLE_OPTION_FILE_EXISTS = "formatter.code.style.option.file.exists";
    public static final String FORMATTER_ERROR_NO_CODE_STYLE_FILE = "formatter.error.no.code.style.file";
    public static final String FORMATTER_CODE_STYLE_OPTION_FILE_CREATED = "formatter.code.style.option.file.created";
    public static final String FORMATTER_ERROR_WRITING_CODE_STYLE_OPTION_FILE = "formatter.error.writing.code.style.option.file";
    public static final String FORMATTER_ERROR_NO_JAVA_FILE = "formatter.error.no.java.file";
    public static final String FORMATTER_ERROR_UNKNOWN_OPTION = "formatter.error.unknown.option";
    public static final String FORMATTER_ARGUMENTS = "formatter.arguments";
    public static final String FORMATTER_ERROR_NO_CODE_STYLE_OPTION = "formatter.error.no.code.style.option";
    public static final String FORMATTER_ERROR_NO_FILES_OR_DIRECTORIES = "formatter.error.no.files.or.directories";
    public static final String FORMATTER_TOTAL_TIME = "formatter.total.time";
    public static final String FORMATTER_FORMAT_DONE = "formatter.format.done";
    public static final String FORMATTER_FORMATTING_FILE = "formatter.formatting.file";
    public static final String FORMATTER_ERROR_NO_SOURCE_NUMBER = "formatter.error.no.source.number";
    public static final String FORMATTER_ERROR_INVALID_SOURCE_NUMBER = "formatter.error.invalid.source.number";
    public static final String FORMATTER_ERROR_FORMATTING_FILE = "formatter.error.formatting.file";
    public static final String FORMATTER_ERROR_UNABLE_TO_GET_SOURCE_FILE = "formatter.error.unable.to.get.source.file";
    public static final String FORMATTER_ERROR_SOURCE_HAS_ERRORS = "formatter.error.source.has.errors";
    public static final String FORMATTER_ERROR_FORMAT_FAILED = "formatter.error.format.failed";
    public static final String FORMATTER_ERROR_NO_ENCODING = "formatter.error.no.encoding";
    public static final String FORMATTER_ERROR_UNSUPPORTED_ENCODING = "formatter.error.unsupported.encoding";
    public static final String FORMATTER_ERROR_UNKNOWN_ENCODING = "formatter.error.unknown.encoding";
    public static final String FORMATTER_ERROR_FILE_NO_READ_WRITE_ACCESS = "formatter.error.file.no.read.write.access";

    public static final ResourceBundle getBundle() {
        if (instance == null) {
            instance = ResourceBundle.getBundle("oracle.javatools.formatter.java.JavaFormatterBundle");
        }
        return instance;
    }

    public static String get(String key) {
        return JavaFormatterBundle.getBundle().getString(key);
    }

    public static String res(String key) {
        return JavaFormatterBundle.get(key);
    }

    public static String format(String key, Object ... arguments) {
        return MessageFormat.format(JavaFormatterBundle.get(key), arguments);
    }

    @Override
    public Object[][] getContents() {
        return contents;
    }

    static {
        contents = new Object[][]{{FORMATTER_USAGE_MESSAGE, "\nReformats stand-alone files and directories.\n\nUsage\n  java -jar javaformatter.jar option... file...\n  java -jar javaformatter.jar option...\n\nParameters\n  file        Directories or files to reformat.\n\nOptions\n  -codestyle  Follow this by the code style option file name.\n  -create     Follow this by a file name. This will create a code style\n              option file which can be used with the -codestyle option.\n  -encoding   Followed by the encoding, e.g UTF-8.\n  -quiet      Only print errors and the final result.\n  -recursive  Directories are searched recursively for files.\n  -source     Followed by JDK version number, e.g 1.6.\n  \nExamples\n  java -jar javaformatter.jar -create options.xml\n    Creates a new code style options file in options.xml\n  java -jar javaformatter.jar -codestyle options.xml file1.java\n    Reformats file1.java using code style options from options.xml\n  java -jar javaformatter.jar -codestyle options.xml directory1\n    Reformats files in directory1 using code style options from options.xml\n  java -jar javaformatter.jar -codestyle options.xml -recursive directory1\n    Recursively reformats files in directory1\n  "}, {FORMATTER_ERROR_FILE_NOT_FOUND, "Error: cannot find file {0}"}, {FORMATTER_ERROR_READING_CODE_STYLE_OPTION_FILE, "Error: exception thrown while reading code style option file: {0}"}, {FORMATTER_ERROR_INVALID_CODE_STYLE_OPTION_ENTRY, "Error: invalid code style option entry: {0}"}, {FORMATTER_ERROR_CREATE_ONLY_OPTION, "Error: no other options allowed with -create option"}, {FORMATTER_CODE_STYLE_OPTION_FILE_EXISTS, "Code style option file {0} exists, overwrite (y/n)?"}, {FORMATTER_ERROR_NO_CODE_STYLE_FILE, "Error: missing code style file name"}, {FORMATTER_CODE_STYLE_OPTION_FILE_CREATED, "Created code style option file {0}"}, {FORMATTER_ERROR_WRITING_CODE_STYLE_OPTION_FILE, "Error: exception thrown while writing to code style option file: {0}"}, {FORMATTER_ERROR_NO_JAVA_FILE, "Error: file {0} is not a Java file"}, {FORMATTER_ERROR_UNKNOWN_OPTION, "Error: unknown option {0}"}, {FORMATTER_ARGUMENTS, "Arguments:"}, {FORMATTER_ERROR_NO_CODE_STYLE_OPTION, "Error: missing -codestyle option"}, {FORMATTER_ERROR_NO_FILES_OR_DIRECTORIES, "Error: no files or directories to format!"}, {FORMATTER_TOTAL_TIME, "Total time ({0} msec) {1} hours {2} minutes {3} seconds {4} msec"}, {FORMATTER_FORMAT_DONE, "Formatted {0} file(s) causing {1} error(s)"}, {FORMATTER_FORMATTING_FILE, "Formatting {0}"}, {FORMATTER_ERROR_NO_SOURCE_NUMBER, "Error: missing -source number"}, {FORMATTER_ERROR_INVALID_SOURCE_NUMBER, "Error: invalid -source number, should be 1.5, 1.6, etc."}, {FORMATTER_ERROR_FORMATTING_FILE, "Error: exception thrown while formatting file: {0}"}, {FORMATTER_ERROR_UNABLE_TO_GET_SOURCE_FILE, "Error: unable to get source file, skipping file"}, {FORMATTER_ERROR_SOURCE_HAS_ERRORS, "Error: source has syntax errors, skipping file"}, {FORMATTER_ERROR_FORMAT_FAILED, "Error: reformat failed, skipping file"}, {FORMATTER_ERROR_NO_ENCODING, "Error: missing encoding"}, {FORMATTER_ERROR_UNSUPPORTED_ENCODING, "Error: unsupported encoding: {0}"}, {FORMATTER_ERROR_UNKNOWN_ENCODING, "Error: unknown encoding: {0}"}, {FORMATTER_ERROR_FILE_NO_READ_WRITE_ACCESS, "Error: file has no read and write access, skipping file"}};
    }
}

