/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.directory;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.compare.algorithm.list.CompareListItem;

public class DirectoryFile
extends CompareListItem<DirectoryFile> {
    private final String _name;
    private final String _id;
    private final boolean _directory;

    public DirectoryFile(DirectoryFile directoryFile) {
        this(directoryFile.isDirectory(), directoryFile.getName(), directoryFile.getID());
    }

    public DirectoryFile(boolean directory, String name, String id) {
        this._directory = directory;
        this._name = name;
        this._id = id;
    }

    @Override
    public Object clone() {
        return new DirectoryFile(this);
    }

    @Override
    public String getLabel() {
        return this._name;
    }

    public static final DirectoryFile parseFile(String spec) throws ParseException {
        Pattern pattern = Pattern.compile("^(.+?)( ([^ ]+))?$");
        Matcher matcher = pattern.matcher(spec);
        if (!matcher.matches()) {
            throw new ParseException("", 0);
        }
        String name = matcher.group(1);
        DirectoryFile file = new DirectoryFile(name.endsWith("/"), name.replace('/', ' ').trim(), matcher.group(3));
        return file;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._name);
        if (this._directory) {
            stringBuffer.append('/');
        }
        if (this._id != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this._id);
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getID() {
        return this._id;
    }

    public boolean isDirectory() {
        return this._directory;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DirectoryFile)) {
            return false;
        }
        DirectoryFile otherFile = (DirectoryFile)o;
        return this._name.equals(otherFile.getName());
    }

    @Override
    public int compareTo(DirectoryFile o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public Object getData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._name);
        if (this._directory) {
            stringBuffer.append('/');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString().toCharArray();
    }
}

