/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.Reader;
import java.text.CharacterIterator;
import oracle.javatools.buffer.ArrayTextBuffer;
import oracle.javatools.buffer.CharArrayReadTextBuffer;
import oracle.javatools.buffer.CharacterIteratorWrapper;
import oracle.javatools.buffer.ExpirableTextBufferSnapshot;
import oracle.javatools.buffer.GapArrayTextBuffer;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.StringReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferReader;
import oracle.javatools.buffer.TextBufferWrapper;

public final class TextBufferFactory {
    private TextBufferFactory() {
    }

    public static TextBuffer createTextBuffer() {
        return TextBufferFactory.createGapTextBuffer();
    }

    public static TextBuffer createTextBuffer(ReadWriteLock lockToUse) {
        return new GapArrayTextBuffer(lockToUse);
    }

    public static TextBuffer createArrayTextBuffer() {
        return new ArrayTextBuffer(new ReadWriteLock());
    }

    public static TextBuffer createGapTextBuffer() {
        return new GapArrayTextBuffer(new ReadWriteLock());
    }

    public static TextBuffer createReadOnlyTextBufferWrapper(TextBuffer textBuffer) {
        return new TextBufferWrapper(textBuffer);
    }

    public static ReadTextBuffer createReadTextBuffer(String dataSource) {
        return new StringReadTextBuffer(dataSource);
    }

    public static ReadTextBuffer createReadTextBuffer(char[] dataSource) {
        return new CharArrayReadTextBuffer(dataSource);
    }

    public static CharacterIterator createCharacterIterator(ReadTextBuffer textBuffer) {
        return new CharacterIteratorWrapper(textBuffer);
    }

    public static Reader createReader(ReadTextBuffer textBuffer) {
        return new TextBufferReader(textBuffer, 0);
    }

    public static Reader createReader(ReadTextBuffer textBuffer, int startOffset) {
        return new TextBufferReader(textBuffer, startOffset);
    }

    public static TextBuffer createExpirableTextBufferSnapshot(TextBuffer textBuffer) {
        if (textBuffer instanceof ExpirableTextBufferSnapshot) {
            return textBuffer;
        }
        return new ExpirableTextBufferSnapshot(textBuffer);
    }
}

