/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.OffsetMarkComparator;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.Disposable;
import oracle.javatools.util.Tuple;

public final class OffsetRegion
implements Comparable,
Disposable {
    private final Tuple<OffsetMark, OffsetMark> tuple;
    private final TextBuffer buffer;

    OffsetRegion(TextBuffer buffer, int start, int end) {
        this.buffer = buffer;
        this.tuple = new Tuple<OffsetMark, OffsetMark>(buffer.addOffsetMark(start), buffer.addOffsetMark(end));
    }

    public int compareTo(Object o) {
        if (!(o instanceof OffsetRegion)) {
            return 0;
        }
        return OffsetMarkComparator.getInstance().compare(this.tuple.object1(), ((OffsetRegion)o).tuple.object1());
    }

    boolean contains(int offset) {
        return this.tuple.object1().getOffset() <= offset && this.tuple.object2().getOffset() >= offset;
    }

    public int getStartOffset() {
        return this.tuple.object1().getOffset();
    }

    public int getEndOffset() {
        return this.tuple.object2().getOffset();
    }

    @Override
    public void dispose() {
        this.buffer.removeOffsetMark(this.tuple.object1());
        this.buffer.removeOffsetMark(this.tuple.object2());
    }
}

