/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import oracle.ide.util.ReturnResultStorage;

public class UIThreadUtil {
    public static <V> V executeSync(final Callable<V> callable) throws Exception {
        final ReturnResultStorage rr = new ReturnResultStorage();
        if (SwingUtilities.isEventDispatchThread()) {
            return callable.call();
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    Object v = callable.call();
                    rr.setResult(v);
                }
                catch (Exception e) {
                    rr.setException(e);
                }
            }
        });
        if (rr.exceptionThrown()) {
            throw rr.getException();
        }
        return rr.getResult();
    }

    public static void executeSync(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void executeASync(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

