/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.javatools.util.NullArgumentException;

public final class TimedCache<K, V> {
    public static final int DEFAULT_EXPIRATION = 10;
    public static final int MAXIMUM_EXPIRATION = 1000;
    public static final int NEVER_EXPIRES = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 5;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static TimeUnit EXPIRATION_UNIT = TimeUnit.MINUTES;
    private static final Logger logger = Logger.getLogger(TimedCache.class.getName());
    private static final Timer timer = AccessController.doPrivileged(new PrivilegedAction<Timer>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Timer run() {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            thread.setContextClassLoader(TimedCache.class.getClassLoader());
            try {
                Timer timer = new Timer("TimedCache-Timer", true);
                return timer;
            }
            finally {
                thread.setContextClassLoader(loader);
            }
        }
    });
    private static final AtomicInteger purgeCounter = new AtomicInteger();
    private final Map<K, Entry> cacheMap;
    private volatile int defaultExpiration;

    public static <K, V> TimedCache<K, V> newInstance() {
        return TimedCache.newInstance(10);
    }

    public static <K, V> TimedCache<K, V> newInstance(int defaultExpiration) {
        return new TimedCache<K, V>(defaultExpiration, 5, 0.75f);
    }

    public static <K, V> TimedCache<K, V> newInstance(int defaultExpiration, int initialCapacity, float loadFactor) {
        return new TimedCache<K, V>(defaultExpiration, initialCapacity, loadFactor);
    }

    public TimedCache() {
        this(10);
    }

    public TimedCache(int defaultExpiration) {
        this(defaultExpiration, 5, 0.75f);
    }

    private TimedCache(int defaultExpiration, int initialCapacity, float loadFactor) {
        this.setDefaultExpiration(defaultExpiration);
        this.cacheMap = new HashMap<K, Entry>(initialCapacity, loadFactor);
    }

    public V get(K key) {
        if (key == null) {
            throw new NullArgumentException("get(): null key not allowed");
        }
        return this.getFromCache(key);
    }

    public void put(K key, V value) {
        this.put(key, value, this.defaultExpiration);
    }

    public void put(K key, V value, int expiration) {
        if (key == null) {
            throw new NullArgumentException("put(): null key not allowed");
        }
        if (value == null) {
            this.remove(key);
        } else {
            this.putIntoCache(key, value, TimedCache.sanitizeExpiration(expiration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Map<K, Entry> map = this.cacheMap;
        synchronized (map) {
            Entry existingEntry = this.cacheMap.remove(key);
            if (existingEntry != null) {
                existingEntry.removeTimer();
                logger.finer("removed entry for key " + key);
                Object value = existingEntry.cache;
                existingEntry.cache = null;
                return (V)value;
            }
            logger.finer("no entry for key " + key);
            return null;
        }
    }

    public void setDefaultExpiration(int defaultExpiration) {
        this.defaultExpiration = TimedCache.sanitizeExpiration(defaultExpiration);
    }

    public void setExpiration(K key, int expiration) {
        if (key == null) {
            throw new NullArgumentException("setExpire(): null key not allowed");
        }
        this.changeExpiration(key, TimedCache.sanitizeExpiration(expiration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        logger.finer("cache cleared");
        Map<K, Entry> map = this.cacheMap;
        synchronized (map) {
            for (Entry e : this.cacheMap.values()) {
                e.removeTimer();
                e.cache = null;
            }
            this.cacheMap.clear();
            TimedCache.purgeTimer(true);
        }
    }

    private static int sanitizeExpiration(int expiration) {
        if ((expiration = Math.min(1000, expiration)) < 0) {
            expiration = 10;
        }
        return expiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getFromCache(K key) {
        Object cache = null;
        Map<K, Entry> map = this.cacheMap;
        synchronized (map) {
            Entry existingEntry = this.cacheMap.get(key);
            if (existingEntry != null) {
                existingEntry.restartTimer();
                cache = existingEntry.cache;
                logger.finer("cache hit for key " + key);
            } else {
                logger.finer("cache miss for key " + key);
            }
        }
        return (V)cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIntoCache(K key, V cache, int expiration) {
        Map<K, Entry> map = this.cacheMap;
        synchronized (map) {
            Entry cacheEntry = new Entry(key, cache, expiration);
            Entry oldEntry = this.cacheMap.put(key, cacheEntry);
            if (oldEntry != null) {
                oldEntry.removeTimer();
                oldEntry.cache = null;
                logger.finer("replaced old entry for key " + key);
            } else {
                logger.finer("added entry for key " + key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeExpiration(K key, int expiration) {
        Map<K, Entry> map = this.cacheMap;
        synchronized (map) {
            Entry existingEntry = this.cacheMap.get(key);
            if (existingEntry != null) {
                existingEntry.changeExpiration(expiration);
                logger.finer("changed expiration for key " + key + " to " + expiration);
            } else {
                logger.finer("key " + key + " not found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entryExpired(Entry cacheEntry) {
        Map<K, Entry> map = this.cacheMap;
        synchronized (map) {
            Entry existingEntry = this.cacheMap.get(cacheEntry.key);
            if (existingEntry == cacheEntry) {
                this.cacheMap.remove(cacheEntry.key);
                cacheEntry.cache = null;
                logger.finer("entry expired for key " + cacheEntry.key);
            }
        }
    }

    private static void purgeTimer(boolean force) {
        if (force || purgeCounter.incrementAndGet() % 1000 == 0) {
            timer.purge();
        }
    }

    private final class Entry {
        private final K key;
        private V cache;
        private volatile TimerTask task;
        private int expiration;

        private Entry(K key, V cache, int expiration) {
            this.key = key;
            this.cache = cache;
            this.changeExpiration(expiration);
        }

        private void changeExpiration(int expiration) {
            this.expiration = expiration;
            if (expiration == 0) {
                this.removeTimer();
            } else {
                this.restartTimer();
            }
        }

        private void restartTimer() {
            if ((this.task == null || this.task.cancel()) && this.expiration != 0) {
                TimedCache.purgeTimer(false);
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        if (Entry.this.task == this) {
                            TimedCache.this.entryExpired(Entry.this);
                        }
                    }
                };
                timer.schedule(this.task, this.getExpirationInterval());
            }
        }

        private void removeTimer() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
                TimedCache.purgeTimer(false);
            }
        }

        private long getExpirationInterval() {
            return TimeUnit.MILLISECONDS.convert(this.expiration, EXPIRATION_UNIT);
        }
    }
}

