/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.ide.Version;
import oracle.ide.util.HogTracker;

public final class Assert {
    private static Logger LOGGER;
    private static HashMap<String, Long> _timingMap;
    private static HashMap<String, Stack<HogTracker>> _trackerMap;
    private static Handler _handler;
    private static final String CHECKING_PROPERTY = "ide.AssertCheckingDisabled";
    private static final boolean checking;
    private static final String TRACING_PROPERTY = "ide.AssertTracingDisabled";
    private static final boolean tracing;
    private static int timingThreshold;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Assert() {
    }

    public static void precondition(boolean condition, String description) throws IllegalStateException {
        if (Version.DEBUG_BUILD != 0 && checking && !condition) {
            if (description == null) {
                description = "Precondition failed";
            }
            System.err.println(description);
            throw new IllegalStateException(description);
        }
    }

    public static void precondition(boolean condition) throws IllegalStateException {
        if (Version.DEBUG_BUILD != 0) {
            Assert.precondition(condition, null);
        }
    }

    public static void check(boolean condition, String description) throws IllegalStateException {
        if (Version.DEBUG_BUILD != 0 && checking && !condition) {
            System.err.println(description);
            throw new IllegalStateException(description, null);
        }
    }

    public static void check(boolean condition) throws IllegalStateException {
        if (Version.DEBUG_BUILD != 0 && checking && !condition) {
            System.err.println("Check failed");
            throw new IllegalStateException("Check failed", null);
        }
    }

    public static void checkAWTThread() throws IllegalStateException {
        if (Version.DEBUG_BUILD != 0) {
            Assert.check(SwingUtilities.isEventDispatchThread(), "Must be invoked from event thread");
        }
    }

    public static void fail(String description) throws IllegalStateException {
        if (Version.DEBUG_BUILD != 0) {
            Assert.check(false, description);
        }
    }

    public static void fail() throws IllegalStateException {
        if (Version.DEBUG_BUILD != 0) {
            Assert.check(false);
        }
    }

    public static void fail(Exception exception) throws IllegalStateException {
        if (Version.DEBUG_BUILD != 0 && checking) {
            Assert.printStackTrace(exception);
            throw new IllegalStateException("Check failed", exception);
        }
    }

    public static void exit(int code) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.println("Assert.exit:");
            System.exit(code);
        }
    }

    public static void printStackTrace() {
        if (Version.DEBUG_BUILD != 0) {
            Assert.printStackTrace(new Exception("Assert Stack Trace"));
        }
    }

    public static void printStackTrace(String message) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.printStackTrace(new Exception("Assert Stack Trace: " + message));
        }
    }

    public static void printStackTrace(Throwable ex) {
        if (Version.DEBUG_BUILD != 0 && tracing) {
            LOGGER.log(Level.FINE, ex.getLocalizedMessage(), ex);
        }
    }

    public static void printStackTrace(boolean condition, String s) {
        if (Version.DEBUG_BUILD != 0 && condition) {
            Assert.printStackTrace(s);
        }
    }

    public static void print(String s) {
        if (Version.DEBUG_BUILD != 0 && tracing) {
            System.err.print("Assert: " + s);
        }
    }

    public static void print(boolean condition, String s) {
        if (Version.DEBUG_BUILD != 0 && condition) {
            Assert.print(s);
        }
    }

    public static void print(boolean condition, String trueString, String falseString) {
        if (Version.DEBUG_BUILD != 0) {
            if (condition) {
                Assert.print(trueString);
            } else {
                Assert.print(falseString);
            }
        }
    }

    public static void println(String s) {
        if (Version.DEBUG_BUILD != 0 && tracing) {
            LOGGER.fine(s);
        }
    }

    public static void println(boolean condition, String s) {
        if (Version.DEBUG_BUILD != 0 && condition) {
            Assert.println(s);
        }
    }

    public static void println(boolean condition, String trueString, String falseString) {
        if (Version.DEBUG_BUILD != 0) {
            if (condition) {
                Assert.println(trueString);
            } else {
                Assert.println(falseString);
            }
        }
    }

    public static void println(String pattern, Object param) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.println(pattern, new Object[]{param});
        }
    }

    public static void println(String pattern, Object param1, Object param2) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.println(pattern, new Object[]{param1, param2});
        }
    }

    public static void println(String pattern, Object param1, Object param2, Object param3) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.println(pattern, new Object[]{param1, param2, param3});
        }
    }

    public static void println(String pattern, Object[] params) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.println(MessageFormat.format(pattern, params));
        }
    }

    public static void execute(Runnable runnable) {
        if (Version.DEBUG_BUILD != 0) {
            runnable.run();
        }
    }

    private static String getTimingKey(String key) {
        if (!$assertionsDisabled && Version.DEBUG_BUILD == 0) {
            throw new AssertionError();
        }
        return Thread.currentThread().getName() + ":" + key;
    }

    public static void startTiming(String key, String msg, boolean quietStart) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.startTiming(key, msg, quietStart, true);
        }
    }

    public static synchronized void startTiming(String key, String msg, boolean quietStart, boolean prefixThread) {
        if (Version.DEBUG_BUILD != 0) {
            if (!quietStart) {
                Assert.printHeader(msg);
            }
            String storeKey = prefixThread ? Assert.getTimingKey(key) : key;
            _timingMap.put(storeKey, System.nanoTime());
        }
    }

    public static void endTiming(String key, String msg, String indent, boolean quietStart) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.endTiming(key, msg, indent, quietStart, true, 0L);
        }
    }

    public static void endTiming(String key, String msg, String indent, boolean quietStart, long timeThreshold) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.endTiming(key, msg, indent, quietStart, true, timeThreshold);
        }
    }

    public static synchronized void endTiming(String key, String msg, String indent, boolean quietStart, boolean prefixThread) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.endTiming(key, msg, indent, quietStart, prefixThread, 0L);
        }
    }

    public static synchronized void endTiming(String key, String msg, String indent, boolean quietStart, boolean prefixThread, long timeThreshold) {
        if (Version.DEBUG_BUILD != 0) {
            String storeKey;
            long endTime = System.nanoTime();
            String string = storeKey = prefixThread ? Assert.getTimingKey(key) : key;
            if (msg != null) {
                if (!_timingMap.containsKey(storeKey)) {
                    Assert.println("Assert.endTiming could not find key: " + storeKey);
                    return;
                }
                long startTime = _timingMap.get(storeKey);
                long msElapsed = (endTime - startTime) / 1000000L;
                Assert.printTiming(msElapsed, msg, indent, timeThreshold);
            }
            _timingMap.remove(storeKey);
        }
    }

    public static void printTiming(long time, String msg, String indent) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.printTiming(time, msg, indent, 0L);
        }
    }

    public static void printTiming(long time, String msg, String indent, long threshold) {
        if (Version.DEBUG_BUILD != 0 && time >= threshold && time > (long)Assert.printTimingThreshold()) {
            StringBuffer sb = new StringBuffer(10 + msg.length());
            sb.append("[").append(time).append("ms] ");
            while (sb.length() < 11) {
                sb.insert(0, " ");
            }
            if (indent == null || indent.length() == 0) {
                sb.append(msg);
            } else {
                sb.append(indent).append(msg);
            }
            Assert.println(sb.toString());
        }
    }

    public static void printHeader(String msg) {
        if (Version.DEBUG_BUILD != 0 && msg != null) {
            Assert.println("      [--] " + msg + "...");
        }
    }

    public static int printTimingThreshold() {
        if (timingThreshold == -2) {
            try {
                timingThreshold = Integer.valueOf(System.getProperty("PrintTimingThreshold", "50"));
                if (timingThreshold < 0) {
                    timingThreshold = -1;
                }
            }
            catch (Exception e) {
                timingThreshold = -1;
            }
        }
        return timingThreshold;
    }

    public static synchronized void startTracking(String key) {
        if (Version.DEBUG_BUILD != 0) {
            String storeKey = Assert.getTimingKey(key);
            Stack<HogTracker> stack = _trackerMap.get(storeKey);
            if (stack == null) {
                stack = new Stack();
                _trackerMap.put(storeKey, stack);
            }
            stack.push(new HogTracker());
        }
    }

    public static void markTracking(String key) {
        HogTracker tracker;
        if (Version.DEBUG_BUILD != 0 && (tracker = Assert.getTracker(key, false)) != null) {
            tracker.mark();
        }
    }

    public static void checkTracking(String key, Object object) {
        HogTracker tracker;
        if (Version.DEBUG_BUILD != 0 && (tracker = Assert.getTracker(key, false)) != null) {
            tracker.check(object);
        }
    }

    public static void endTracking(String key) {
        if (Version.DEBUG_BUILD != 0) {
            Assert.endTracking(key, null);
        }
    }

    public static void endTracking(String key, String msg) {
        HogTracker tracker;
        if (Version.DEBUG_BUILD != 0 && (tracker = Assert.getTracker(key, true)) != null) {
            tracker.report();
            if (msg != null && msg.length() > 0) {
                tracker.reportTotal(msg);
            }
        }
    }

    private static synchronized HogTracker getTracker(String key, boolean remove) {
        if (!$assertionsDisabled && Version.DEBUG_BUILD == 0) {
            throw new AssertionError();
        }
        String storeKey = Assert.getTimingKey(key);
        if (!_trackerMap.containsKey(storeKey)) {
            Assert.println("Assert.getTracker could not find key: " + storeKey);
            return null;
        }
        Stack<HogTracker> stack = _trackerMap.get(storeKey);
        if (remove) {
            HogTracker tracker = stack.pop();
            if (stack.size() == 0) {
                _trackerMap.remove(key);
            }
            return tracker;
        }
        return stack.peek();
    }

    private static void resetHandler() {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                LOGGER.setUseParentHandlers(false);
                if (_handler != null) {
                    LOGGER.removeHandler(_handler);
                }
                _handler = new AssertHandler();
                LOGGER.addHandler(_handler);
                return null;
            }
        };
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            action.run();
        }
    }

    static {
        boolean bl = $assertionsDisabled = !Assert.class.desiredAssertionStatus();
        if (Version.DEBUG_BUILD != 0) {
            LOGGER = Logger.getLogger(Assert.class.getName());
            _timingMap = new HashMap();
            _trackerMap = new HashMap();
            Assert.resetHandler();
        }
        checking = !Boolean.getBoolean(CHECKING_PROPERTY);
        tracing = !Boolean.getBoolean(TRACING_PROPERTY);
        timingThreshold = -2;
    }

    private static class AssertFormatter
    extends Formatter {
        private AssertFormatter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String format(LogRecord record) {
            try (PrintStream printer = null;){
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                printer = new PrintStream(bytes);
                printer.append("Trace: ");
                printer.append(record.getMessage());
                printer.append("\n");
                Throwable throwable = record.getThrown();
                if (throwable != null) {
                    throwable.printStackTrace(printer);
                }
                printer.flush();
                String string = bytes.toString();
                return string;
            }
        }
    }

    private static class AssertHandler
    extends ConsoleHandler {
        AssertHandler() {
            this.setLevel(Level.FINE);
            if (!Boolean.getBoolean("ide.assert.standardFormatter")) {
                this.setFormatter(new AssertFormatter());
            }
        }
    }
}

