/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.Comparator;
import oracle.ide.net.URLFileSystem;

public final class URLComparator
implements Comparator {
    private final boolean _dirsBeforeFiles;
    private final boolean _caseSensitive;

    public URLComparator() {
        this(false, true);
    }

    public URLComparator(boolean dirsBeforeFiles) {
        this(dirsBeforeFiles, URLFileSystem.isLocalFileSystemCaseSensitive());
    }

    public URLComparator(boolean dirsBeforeFiles, boolean caseSensitive) {
        this._dirsBeforeFiles = dirsBeforeFiles;
        this._caseSensitive = caseSensitive;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (this._dirsBeforeFiles) {
            boolean isDir2;
            URL url1 = (URL)o1;
            URL url2 = (URL)o2;
            boolean isDir1 = URLFileSystem.isDirectoryPath(url1);
            if (isDir1 != (isDir2 = URLFileSystem.isDirectoryPath(url2))) {
                return isDir1 ? -1 : 1;
            }
        }
        String str1 = o1.toString();
        String str2 = o2.toString();
        if (this._caseSensitive) {
            return str1.compareTo(str2);
        }
        return str1.compareToIgnoreCase(str2);
    }
}

