/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.net.FileURLFileSystemHelper;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.PlatformUtils;

public final class SymlinkCycleDetector {
    private static final boolean ENABLED = PlatformUtils.isLinux() && !Boolean.getBoolean("ide.disable.symlink.cycle.detection");
    private final boolean enabled;
    private final Collection<VisitedDirectory> visited;

    public static SymlinkCycleDetector getInstance(URL root) {
        if (root == null) {
            throw new NullArgumentException("null root URL");
        }
        return new SymlinkCycleDetector(root);
    }

    private SymlinkCycleDetector(URL root) {
        this.enabled = ENABLED && "file".equals(root.getProtocol());
        this.visited = this.enabled ? new ArrayList() : null;
    }

    public boolean isSymlinkCycle(URL dir, URLFileSystem.FileInfo[] infos) {
        if (this.enabled) {
            VisitedDirectory current = new VisitedDirectory(dir, infos);
            for (VisitedDirectory v : this.visited) {
                if (!v.equals(current)) continue;
                return true;
            }
            this.visited.add(current);
        }
        return false;
    }

    private static int getHashCode(URLFileSystem.FileInfo[] infos) {
        int hash = 17;
        if (infos != null) {
            for (URLFileSystem.FileInfo info : infos) {
                hash = 31 * hash + SymlinkCycleDetector.getHashCode(info);
            }
        }
        return hash;
    }

    private static int getHashCode(URLFileSystem.FileInfo info) {
        int hash = 17;
        hash = 31 * hash + URLFileSystem.getFileName(info.getURL()).hashCode();
        hash = 31 * hash + SymlinkCycleDetector.getHashCode(info.lastModified());
        hash = 31 * hash + SymlinkCycleDetector.getHashCode(info.length());
        hash = 31 * hash + SymlinkCycleDetector.getHashCode(info.isDirectory());
        hash = 31 * hash + SymlinkCycleDetector.getHashCode(info.isFile());
        hash = 31 * hash + SymlinkCycleDetector.getHashCode(info.isHidden());
        return hash;
    }

    private static int getHashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    private static int getHashCode(boolean b) {
        return b ? 1 : 0;
    }

    private static class VisitedDirectory {
        private final URL url;
        private final int hash;

        public VisitedDirectory(URL url, URLFileSystem.FileInfo[] infos) {
            this.url = url;
            this.hash = SymlinkCycleDetector.getHashCode(infos);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VisitedDirectory)) {
                return false;
            }
            VisitedDirectory other = (VisitedDirectory)o;
            if (this.hash == other.hash) {
                try {
                    File file = FileURLFileSystemHelper.url2File(this.url).getCanonicalFile();
                    File otherFile = FileURLFileSystemHelper.url2File(other.url).getCanonicalFile();
                    return file.equals(otherFile);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }
    }
}

