/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncHashtable;
import oracle.security.crypto.util.Utils;

public class X509ExtensionSet
implements ASN1Object,
Externalizable {
    private UnsyncHashtable extTable = new UnsyncHashtable();
    private Vector extList = new Vector();
    private ASN1Sequence seq = null;

    public X509ExtensionSet() {
    }

    public X509ExtensionSet(Vector exts) {
        int size = exts.size();
        for (int i = 0; i < size; ++i) {
            this.addExtension((X509Extension)exts.elementAt(i));
        }
    }

    public X509ExtensionSet(InputStream is) throws IOException {
        this.input(is);
    }

    public X509Extension addExtension(X509Extension ext) {
        this.reset();
        X509Extension oldExt = (X509Extension)this.extTable.get((Object)ext.getType());
        if (oldExt != null) {
            this.extList.removeElement(oldExt);
        }
        this.extList.addElement(ext);
        this.extTable.put((Object)ext.getType(), (Object)ext);
        return oldExt;
    }

    public X509Extension getExtension(ASN1ObjectID type) {
        return (X509Extension)this.extTable.get((Object)type);
    }

    public Enumeration types() {
        return this.extTable.keys();
    }

    public Vector getExtensions() {
        Vector v = new Vector();
        int n = this.extList.size();
        for (int i = 0; i < n; ++i) {
            v.addElement(this.extList.elementAt(i));
        }
        return v;
    }

    public int size() {
        return this.extList.size();
    }

    public boolean hasExtension(ASN1ObjectID type) {
        return this.extTable.containsKey((Object)type);
    }

    public boolean hasUnrecognizedCriticalExtension() {
        int n = this.extList.size();
        for (int i = 0; i < n; ++i) {
            X509Extension ext = (X509Extension)this.extList.elementAt(i);
            if (!ext.getCritical() || ext.isRecognized()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('{');
        int n = this.extList.size();
        for (int i = 0; i < n; ++i) {
            s.append(this.extList.elementAt(i).toString());
            if (i >= n - 1) continue;
            s.append(", ");
        }
        s.append('}');
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.extList.removeAllElements();
        this.extTable.clear();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        while (sis.hasMoreData()) {
            this.addExtension(X509Extension.inputInstance((InputStream)sis));
        }
        sis.terminate();
        this.reset();
        if (this.size() == 0) {
            throw new ASN1FormatException("Extension set must contain at least 1 extension");
        }
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence s = new ASN1Sequence();
            int n = this.extList.size();
            for (int i = 0; i < n; ++i) {
                s.addElement((ASN1Object)((X509Extension)this.extList.elementAt(i)));
            }
            this.seq = s;
        }
        return this.seq;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

