/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.Entity;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500RDN;
import oracle.security.crypto.util.ArrayVector;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X500Name
extends Entity
implements ASN1Object {
    private Vector rdnSequence = new Vector();
    private String countryName = null;
    private String stateName = null;
    private String localityName = null;
    private String organizationName = null;
    private String orgUnitName = null;
    private String email = null;
    private ASN1Sequence contents;
    private String stringContents;
    private int hash = -1;

    public X500Name() {
    }

    public X500Name(String str) {
        this.input(str);
    }

    public X500Name(InputStream is) throws IOException {
        this.input(is);
    }

    X500Name(ASN1Sequence s) throws IOException {
        this.input(s);
    }

    public void addComponent(X500RDN rdn) {
        this.rdnSequence.addElement(rdn);
        Enumeration e = rdn.types();
        while (e.hasMoreElements()) {
            ASN1ObjectID type = (ASN1ObjectID)e.nextElement();
            ASN1Object o = rdn.getValue(type);
            if (!(o instanceof ASN1String)) continue;
            ASN1String value = (ASN1String)o;
            if (type.equals((Object)PKIX.id_at_commonName)) {
                this.setName(value.getValue());
                continue;
            }
            if (type.equals((Object)PKIX.id_at_countryName)) {
                this.countryName = value.getValue();
                continue;
            }
            if (type.equals((Object)PKIX.id_at_localityName)) {
                this.localityName = value.getValue();
                continue;
            }
            if (type.equals((Object)PKIX.id_at_stateOrProvinceName)) {
                this.stateName = value.getValue();
                continue;
            }
            if (type.equals((Object)PKIX.id_at_organizationName)) {
                this.organizationName = value.getValue();
                continue;
            }
            if (type.equals((Object)PKIX.id_at_organizationalUnitName)) {
                this.orgUnitName = value.getValue();
                continue;
            }
            if (!type.equals((Object)PKIX.emailAddress)) continue;
            this.email = value.getValue();
        }
        this.stringContents = null;
        this.contents = null;
        this.hash = -1;
    }

    public void addComponent(ASN1ObjectID type, ASN1String value) {
        this.addComponent(new X500RDN(type, (ASN1Object)value));
    }

    public void addComponent(ASN1ObjectID type, String value) {
        this.addComponent(new X500RDN(type, value));
    }

    public void addComponent(String name, String value) {
        this.addComponent(X500RDN.getTypeID(name), value);
    }

    public ASN1Object getAttributeValue(String name) {
        return this.getAttributeValue(X500RDN.getTypeID(name));
    }

    public ASN1Object getAttributeValue(ASN1ObjectID type) {
        X500RDN rdn = this.getAttribute(type);
        return rdn != null ? rdn.getValue(type) : null;
    }

    public X500RDN getAttribute(String name) {
        ASN1ObjectID type = X500RDN.getTypeID(name);
        return type != null ? this.getAttribute(type) : null;
    }

    public X500RDN getAttribute(ASN1ObjectID type) {
        Enumeration e = this.components();
        while (e.hasMoreElements()) {
            X500RDN rdn = (X500RDN)e.nextElement();
            if (rdn == null || rdn.getValue(type) == null) continue;
            return rdn;
        }
        return null;
    }

    public void input(InputStream is) throws IOException {
        this.reset();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        while (sis.hasMoreData()) {
            this.addComponent(new X500RDN((InputStream)sis));
        }
        sis.terminate();
    }

    void input(ASN1Sequence s) throws IOException {
        this.input(Utils.toStream((Streamable)s));
    }

    public void input(String s) throws InvalidFormatException {
        this.reset();
        boolean allWhitespace = true;
        int size = s.length();
        for (int j = 0; j < size; ++j) {
            if (X500RDN.isWhitespace(s.charAt(j))) continue;
            allWhitespace = false;
            break;
        }
        if (allWhitespace) {
            return;
        }
        StringBuffer r = new StringBuffer();
        boolean quoting = false;
        boolean foundRDN = false;
        int i = 0;
        ArrayVector comps = new ArrayVector();
        while (i < s.length()) {
            try {
                char c = s.charAt(i);
                if (c == '\"') {
                    quoting = !quoting;
                    r.append(c);
                } else if (c == ',' || c == ';') {
                    if (quoting) {
                        r.append(c);
                    } else {
                        foundRDN = true;
                    }
                } else if (c == '\\') {
                    r.append(c);
                    c = s.charAt(++i);
                    r.append(c);
                } else {
                    r.append(c);
                }
                if (!foundRDN && ++i != s.length()) continue;
                comps.addElement((Object)new X500RDN(r.toString()));
                r = new StringBuffer();
                quoting = false;
                foundRDN = false;
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidFormatException("Malformed DN string");
            }
        }
        Object[] arrayComps = new X500RDN[comps.size()];
        comps.getElements(arrayComps);
        for (int k = arrayComps.length - 1; k >= 0; --k) {
            this.addComponent((X500RDN)arrayComps[k]);
        }
    }

    private void reset() {
        this.rdnSequence.removeAllElements();
        this.countryName = null;
        this.stateName = null;
        this.localityName = null;
        this.organizationName = null;
        this.orgUnitName = null;
        this.email = null;
        this.stringContents = null;
        this.contents = null;
        this.hash = -1;
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    public int length() {
        return this.outputASN1().length();
    }

    ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                s.addElement((ASN1Object)((X500RDN)this.rdnSequence.elementAt(i)));
            }
            this.contents = s;
        }
        return this.contents;
    }

    public String toString() {
        if (this.stringContents == null) {
            StringBuffer s = new StringBuffer();
            for (int i = this.size() - 1; i >= 0; --i) {
                X500RDN rdn = this.componentAt(i);
                s.append(rdn.toString());
                s.append(',');
            }
            if (s.length() > 0) {
                s.setLength(s.length() - 1);
            }
            this.stringContents = s.toString();
        }
        return this.stringContents;
    }

    public Vector getComponents() {
        if (this.rdnSequence == null) {
            this.rdnSequence = new Vector();
            if (this.countryName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_countryName, this.countryName));
            }
            if (this.stateName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_stateOrProvinceName, this.stateName));
            }
            if (this.localityName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_localityName, this.localityName));
            }
            if (this.organizationName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_organizationName, this.organizationName));
            }
            if (this.orgUnitName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_organizationalUnitName, this.orgUnitName));
            }
            if (this.getName() != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_commonName, this.getName()));
            }
            if (this.email != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.emailAddress, this.email));
            }
        }
        return this.rdnSequence;
    }

    public Enumeration components() {
        return this.getComponents().elements();
    }

    public int size() {
        return this.getComponents().size();
    }

    public X500RDN componentAt(int i) {
        return (X500RDN)this.getComponents().elementAt(i);
    }

    private void clearNewAPI() {
        this.rdnSequence = null;
        this.contents = null;
        this.stringContents = null;
        this.hash = -1;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String s) {
        this.countryName = s;
        this.clearNewAPI();
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String s) {
        this.stateName = s;
        this.clearNewAPI();
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String s) {
        this.localityName = s;
        this.clearNewAPI();
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String s) {
        this.organizationName = s;
        this.clearNewAPI();
    }

    public String getOrgUnitName() {
        return this.orgUnitName;
    }

    public void setOrgUnitName(String s) {
        this.orgUnitName = s;
        this.clearNewAPI();
    }

    public String getCommonName() {
        return this.getName();
    }

    public void setCommonName(String s) {
        this.setName(s);
        this.clearNewAPI();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String s) {
        this.email = s;
        this.clearNewAPI();
    }

    public void setAttr(String name, String value) {
        if (name.equalsIgnoreCase("C")) {
            this.setCountryName(value);
        } else if (name.equalsIgnoreCase("ST")) {
            this.setStateName(value);
        } else if (name.equalsIgnoreCase("L")) {
            this.setLocalityName(value);
        } else if (name.equalsIgnoreCase("O")) {
            this.setOrganizationName(value);
        } else if (name.equalsIgnoreCase("OU")) {
            this.setOrgUnitName(value);
        } else if (name.equalsIgnoreCase("CN")) {
            this.setName(value);
        } else if (name.equalsIgnoreCase("Email")) {
            this.setEmail(value);
        } else if (name.equalsIgnoreCase("EmailAddress")) {
            this.setEmail(value);
        } else {
            throw new IllegalArgumentException("Attribute '" + name + "' cannot be set using setAttr(String, String)" + ", only {C, ST, L, O, OU, CN, EMAIL (or EMAILADDRESS)} are allowed.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X500Name x = (X500Name)o;
        if (x.size() != this.size()) {
            return false;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.componentAt(i).equals(x.componentAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data = (byte[])is.readObject();
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

