/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cert.CertificateVerifier;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.core.AuthenticationException;

public class TrustedCAPolicy
implements CertificateTrustPolicy {
    private boolean requireCRL = false;
    private boolean requireCA = true;
    private Hashtable trustedTable = new Hashtable();

    public TrustedCAPolicy() {
    }

    public TrustedCAPolicy(Vector trustedCACerts, boolean requireCRL, boolean requireCA) {
        this.setTrustedCAs(trustedCACerts);
        this.requireCRL = requireCRL;
        this.requireCA = requireCA;
    }

    public CertificateVerifier makeCertificateVerifier(Vector certificates, Vector crls) {
        return new TrustedCACertificateVerifier(certificates, crls);
    }

    public void addTrustedCA(X509 trustedCACert) {
        this.trustedTable.put(trustedCACert.getSubject(), trustedCACert);
    }

    public void setRequireCRLs(boolean flag) {
        this.requireCRL = flag;
    }

    public boolean getRequireCRLs() {
        return this.requireCRL;
    }

    public void setRequireCAFlag(boolean flag) {
        this.requireCA = flag;
    }

    public boolean getRequireCAFlag() {
        return this.requireCA;
    }

    public void setTrustedCAs(Vector trustedCACerts) {
        this.trustedTable.clear();
        if (trustedCACerts == null) {
            return;
        }
        int size = trustedCACerts.size();
        for (int i = 0; i < size; ++i) {
            X509 c = (X509)trustedCACerts.elementAt(i);
            this.trustedTable.put(c.getSubject(), c);
        }
    }

    public Enumeration trustedCAs() {
        return this.trustedTable.elements();
    }

    class TrustedCACertificateVerifier
    implements CertificateVerifier {
        private Hashtable iasnTable = new Hashtable();
        private Hashtable subjectTable = new Hashtable();
        private Hashtable crlTable = new Hashtable();

        TrustedCACertificateVerifier(Vector certificates, Vector crls) {
            int i;
            int size;
            if (certificates != null) {
                size = certificates.size();
                for (i = 0; i < size; ++i) {
                    X509 cert = (X509)certificates.elementAt(i);
                    IssuerAndSerialNo iasn = new IssuerAndSerialNo(cert);
                    this.iasnTable.put(iasn, cert);
                    this.subjectTable.put(cert.getSubject(), cert);
                }
            }
            if (crls != null) {
                size = crls.size();
                for (i = 0; i < size; ++i) {
                    CRL crl = (CRL)crls.elementAt(i);
                    this.crlTable.put(crl.getIssuer(), crl);
                }
            }
        }

        public X509 getValidCertificate(IssuerAndSerialNo iasn) throws AuthenticationException {
            X509 cert = (X509)this.iasnTable.get(iasn);
            if (cert == null) {
                return null;
            }
            if (TrustedCAPolicy.this.trustedTable.containsKey(cert.getSubject())) {
                return cert;
            }
            Vector<X509> certChain = new Vector<X509>();
            X500Name holder = null;
            while (cert != null) {
                Object obj = this.subjectTable.get(cert.getIssuer());
                if (obj != null && certChain.contains(obj)) {
                    throw new AuthenticationException("Chain does not terminate with a trusted CA");
                }
                certChain.addElement(cert);
                holder = cert.getIssuer();
                cert = (X509)this.subjectTable.get(holder);
                if (TrustedCAPolicy.this.trustedTable.containsKey(holder)) break;
                if (cert != null) continue;
                throw new AuthenticationException("Chain does not terminate with a trusted CA");
            }
            X509 certCA = (X509)TrustedCAPolicy.this.trustedTable.get(holder);
            boolean notFirstCert = false;
            while (!certChain.isEmpty()) {
                BasicConstraintsExtension bc;
                cert = (X509)certChain.lastElement();
                CRL crlist = (CRL)this.crlTable.get(certCA.getSubject());
                cert.setIssuerCertificate(certCA);
                if (crlist != null) {
                    cert.setIssuerCRL(crlist);
                } else if (TrustedCAPolicy.this.requireCRL) {
                    throw new AuthenticationException("CRL not found for certificate");
                }
                if (TrustedCAPolicy.this.requireCA && notFirstCert && ((bc = (BasicConstraintsExtension)certCA.getExtension(PKIX.id_ce_basicConstraints)) == null || !bc.getCA())) {
                    throw new AuthenticationException("Certificate is not a CA");
                }
                if (!cert.verify()) {
                    throw new AuthenticationException("Certificate invalid");
                }
                certCA = cert;
                certChain.removeElementAt(certChain.size() - 1);
                notFirstCert = true;
            }
            return cert;
        }
    }
}

