/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.util.InvalidInputException;

public class KeyPairPKCS12
extends PKCS12 {
    private Vector orderedCertChain = null;

    public KeyPairPKCS12() {
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, Vector certChain, int mode) {
        this(pkcs8, certChain, KeyPairPKCS12.transformMode(mode));
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, Vector certChain, ASN1ObjectID pbeOID) {
        this(pkcs8, certChain, pbeOID, null);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, Vector certChain, int mode, String friendlyName) {
        this(pkcs8, certChain, KeyPairPKCS12.transformMode(mode), friendlyName);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, Vector certChain, ASN1ObjectID pbeOID, String friendlyName) {
        byte[] localKeyID = null;
        if (certChain != null && certChain.size() > 0) {
            X509 botCert = (X509)certChain.elementAt(0);
            MessageDigest sha = null;
            try {
                sha = MessageDigest.getInstance((AlgorithmIdentifier)AlgID.sha_1);
            }
            catch (AlgorithmIdentifierException ex) {
                throw new RuntimeException("SHA1 class not found. " + ex.toString());
            }
            localKeyID = sha.computeDigest(botCert.getEncoded());
        }
        if (pkcs8 != null) {
            PKCS12Safe k = new PKCS12Safe((PKCS12)this, (ASN1ObjectID)null);
            PKCS12ShroudedKeyBag b = new PKCS12ShroudedKeyBag(k, pkcs8);
            if (localKeyID != null) {
                b.setLocalKeyID(localKeyID);
            }
            if (friendlyName != null) {
                b.setFriendlyName(friendlyName);
            }
            k.addBag(b);
            this.addAuthSafe(k);
        }
        if (certChain != null && certChain.size() > 0) {
            PKCS12Safe cc = new PKCS12Safe((PKCS12)this, pbeOID);
            for (int i = certChain.size() - 1; i > 0; --i) {
                cc.addBag(new PKCS12CertBag(cc, (X509)certChain.elementAt(i)));
            }
            X509 botCert = (X509)certChain.elementAt(0);
            PKCS12CertBag b = new PKCS12CertBag(cc, botCert);
            if (localKeyID != null) {
                b.setLocalKeyID(localKeyID);
            }
            if (friendlyName != null) {
                b.setFriendlyName(friendlyName);
            }
            cc.addBag(b);
            this.addAuthSafe(cc);
        }
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, Vector certChain, int mode) {
        this(passwd, pkcs8, certChain, KeyPairPKCS12.transformMode(mode));
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, Vector certChain, ASN1ObjectID pbeOID) {
        this(passwd, pkcs8, certChain, pbeOID, null);
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, Vector certChain, int mode, String friendlyName) {
        this(passwd, pkcs8, certChain, KeyPairPKCS12.transformMode(mode), friendlyName);
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, Vector certChain, ASN1ObjectID pbeOID, String friendlyName) {
        this(pkcs8, certChain, pbeOID, friendlyName);
        this.setPassword(passwd);
    }

    public KeyPairPKCS12(String passwd, InputStream is) throws IOException {
        super(passwd, is);
        this.orderCertificateChain();
    }

    public KeyPairPKCS12(String passwd, ASN1Sequence s) throws IOException {
        super(passwd, s);
        this.orderCertificateChain();
    }

    private static ASN1ObjectID transformMode(int mode) {
        if (mode == -2) {
            return PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC;
        }
        if (mode == -1) {
            return PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC;
        }
        if (mode == 0) {
            return null;
        }
        return new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, mode);
    }

    public void input(ASN1Sequence s) throws IOException {
        super.input(s);
        this.orderedCertChain = null;
        this.orderCertificateChain();
    }

    public void input(InputStream is) throws IOException {
        super.input(is);
        this.orderedCertChain = null;
        this.orderCertificateChain();
    }

    private PKCS12ShroudedKeyBag getShroudedKeyBag() {
        Vector as = this.getAuthSafes();
        int size = as.size();
        for (int i = 0; i < size; ++i) {
            PKCS12Safe s = (PKCS12Safe)as.elementAt(i);
            Vector v = s.getBags();
            int size2 = v.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                PKCS12Bag b = (PKCS12Bag)v.elementAt(i2);
                if (!(b instanceof PKCS12ShroudedKeyBag)) continue;
                return (PKCS12ShroudedKeyBag)b;
            }
        }
        return null;
    }

    public PrivateKeyPKCS8 getPrivateKeyPKCS8() {
        PKCS12ShroudedKeyBag b = this.getShroudedKeyBag();
        if (b != null) {
            return b.getPKCS8();
        }
        return null;
    }

    public PrivateKey getPrivateKey() {
        PKCS12ShroudedKeyBag b = this.getShroudedKeyBag();
        if (b != null) {
            return b.getPrivateKey();
        }
        return null;
    }

    public PrivateKey getPrivateKey(String passwd) {
        PrivateKeyPKCS8 pkcs8 = this.getPrivateKeyPKCS8();
        if (pkcs8 != null) {
            pkcs8.setPassword(passwd);
            return pkcs8.getKey();
        }
        return null;
    }

    public Vector getCertificateChain() {
        return this.orderedCertChain;
    }

    public X509 getBottomCert() {
        Vector cc = this.getCertificateChain();
        if (cc.size() == 0) {
            return null;
        }
        return (X509)cc.firstElement();
    }

    private void orderCertificateChain() throws InvalidInputException {
        if (this.orderedCertChain != null) {
            return;
        }
        Hashtable<X500Name, X509> issuers = new Hashtable<X500Name, X509>();
        Hashtable<X500Name, X509> subjects = new Hashtable<X500Name, X509>();
        int certCount = 0;
        Vector<X509> chain = new Vector<X509>();
        Hashtable<X509, X509> check = new Hashtable<X509, X509>();
        Vector safes = this.getAuthSafes();
        int size = safes.size();
        for (int i = 0; i < size; ++i) {
            PKCS12Safe safe = (PKCS12Safe)safes.elementAt(i);
            Vector v = safe.getBags();
            int size2 = v.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                PKCS12Bag bag = (PKCS12Bag)v.elementAt(i2);
                if (!(bag instanceof PKCS12CertBag)) continue;
                X509 cert = ((PKCS12CertBag)bag).getCert();
                if (cert.getIssuer().equals(cert.getSubject())) {
                    chain.addElement(cert);
                    check.put(cert, cert);
                } else {
                    if (issuers.put(cert.getIssuer(), cert) != null) {
                        throw new InvalidInputException("Multiple certificates with same issuer");
                    }
                    if (subjects.put(cert.getSubject(), cert) != null) {
                        throw new InvalidInputException("Multiple certificates with same subject");
                    }
                }
                ++certCount;
            }
        }
        if (chain.size() == 0 && issuers.size() > 0) {
            X509 cert = (X509)issuers.get((X500Name)issuers.keys().nextElement());
            if (cert != null) {
                chain.addElement(cert);
                check.put(cert, cert);
            }
        } else if (chain.size() > 1) {
            throw new InvalidInputException("Certificate chain contains more than 1 self-signed cert");
        }
        if (chain.size() == 1) {
            X509 first = (X509)chain.elementAt(0);
            X509 prev = (X509)subjects.get(first.getIssuer());
            X509 next = (X509)issuers.get(first.getSubject());
            while (prev != null) {
                if (check.put(prev, prev) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                chain.addElement(prev);
                prev = (X509)subjects.get(prev.getIssuer());
            }
            while (next != null) {
                if (check.put(next, next) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                chain.insertElementAt(next, 0);
                next = (X509)issuers.get(next.getSubject());
            }
            if (chain.size() != certCount) {
                throw new InvalidInputException("Certificate chain cannot be ordered");
            }
        }
        this.orderedCertChain = chain;
    }
}

