/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import javax.swing.Action;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.action.BaseModelAction;

public class XmlSelectionAction
extends BaseModelAction {
    private final boolean _needsSelection;

    public XmlSelectionAction(String mnemonicAndDisplayName, KeyStroke accelerator, String actionCommand, boolean needsSelection) {
        super(mnemonicAndDisplayName, accelerator, actionCommand, needsSelection, false);
        this._needsSelection = needsSelection;
    }

    @Override
    public boolean isActiveViewAction() {
        return true;
    }

    @Override
    protected boolean needToUpdateEnabled(XmlModelEvent event) {
        return event.isSelectionOrRangeSelectionChanged() || this.needsToRespondToReadOnlyChange(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isEnabledImpl() {
        if (!super.isEnabledImpl()) {
            return false;
        }
        AbstractModel model = this.getModel();
        model.acquireReadLock();
        try {
            Selection s = model.getSelection();
            boolean emptySelection = s.isEmpty();
            if (s.hasRangeSelection() && s.getRangeSelection().getStart() == s.getRangeSelection().getEnd()) {
                emptySelection = true;
            }
            boolean bl = this._needsSelection ^ emptySelection;
            return bl;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected static void setActionName(Action action, String actionName) {
        String strippedString = StringUtils.stripMnemonic((String)actionName);
        int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)actionName);
        action.putValue("Name", strippedString);
        action.putValue("MnemonicKey", IntegerUtils.getInteger((int)mnemonicKeyCode));
    }
}

