/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.text.Collator;
import java.util.Comparator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;

public class XmlKeyDisplayNameComparator
implements Comparator {
    private Collator _collator;
    private XmlMetadataResolver _resolver;

    public XmlKeyDisplayNameComparator(XmlMetadataResolver resolver) {
        this(resolver, null);
    }

    public XmlKeyDisplayNameComparator(XmlMetadataResolver resolver, Collator c) {
        if (resolver == null) {
            throw new IllegalArgumentException("resolver must not be null");
        }
        this._resolver = resolver;
        if (c == null) {
            c = Collator.getInstance(resolver.getContext().getLocale());
        }
        this._collator = c;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof XmlKey && o2 instanceof XmlKey) {
            XmlKey k1 = (XmlKey)o1;
            XmlKey k2 = (XmlKey)o2;
            int k1DisplayOrder = this._resolver.getDisplayOrder(k1);
            int k2DisplayOrder = this._resolver.getDisplayOrder(k2);
            if (k1DisplayOrder == -1 && k2DisplayOrder == -1) {
                return this._collator.compare(this._resolver.getShortDisplayName(k1), this._resolver.getShortDisplayName(k2));
            }
            if (k1DisplayOrder == -1) {
                return 1;
            }
            if (k2DisplayOrder == -1) {
                return -1;
            }
            return k1DisplayOrder - k2DisplayOrder;
        }
        if (o1 instanceof XmlKey) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof XmlKeyDisplayNameComparator;
    }
}

