/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.util.DomPositionRef;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DomPositionRefFactory {
    private static final DomPositionRef _NULL_REF = new DomPositionRef(){

        @Override
        public DomPosition getCorrespondingPosition(Document doc) {
            return null;
        }
    };

    public static DomPositionRef get(DomPosition pos) {
        if (pos == null || pos.getTargetNode() == null) {
            return _NULL_REF;
        }
        final NodeRef targetNodeRef = NodeRefFactory.getNodeRef((Node)pos.getTargetNode());
        boolean hasAttr = pos.hasAttributeQName();
        boolean hasTextOffset = pos.hasTextOffset();
        if (hasTextOffset) {
            final int textOffset = pos.getTextOffset();
            if (hasAttr) {
                final QualifiedName attrQName = pos.getAttributeQName();
                return new DomPositionRef(){

                    @Override
                    public DomPosition getCorrespondingPosition(Document doc) {
                        Node node = targetNodeRef.getCorrespondingNode(doc);
                        return DomPositionFactory.createDomPosition((Element)((Element)node), (QualifiedName)attrQName, (int)textOffset);
                    }
                };
            }
            return new DomPositionRef(){

                @Override
                public DomPosition getCorrespondingPosition(Document doc) {
                    Node node = targetNodeRef.getCorrespondingNode(doc);
                    return DomPositionFactory.createTextPosition((CharacterData)((CharacterData)node), (int)textOffset);
                }
            };
        }
        assert (!hasAttr);
        final int relativePos = pos.getRelativePosition();
        return new DomPositionRef(){

            @Override
            public DomPosition getCorrespondingPosition(Document doc) {
                Node node = targetNodeRef.getCorrespondingNode(doc);
                return DomPositionFactory.createDomPosition((Node)node, (int)relativePos);
            }
        };
    }

    private DomPositionRefFactory() {
    }
}

