/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.beans.PropertyVetoException;
import javax.swing.Icon;
import oracle.bali.xml.util.AttributeValueItem;

public class DefaultAttributeValueItem
implements AttributeValueItem {
    private Icon _icon;
    private String _text;
    private String _selectedValue;

    public static AttributeValueItem createItemWithNullSelectedValue(String displayText, Icon icon) {
        return new DefaultAttributeValueItem(icon, displayText, null);
    }

    public DefaultAttributeValueItem(String displayText) {
        this(displayText, null);
    }

    public DefaultAttributeValueItem(String displayText, Icon icon) {
        this(displayText, icon, displayText);
    }

    public DefaultAttributeValueItem(String displayText, Icon icon, String selectedValue) {
        this(icon, displayText, DefaultAttributeValueItem._defaultIfNull(selectedValue, displayText));
    }

    @Override
    public String getDisplayText() {
        return this._text;
    }

    @Override
    public Icon getIcon() {
        return this._icon;
    }

    @Override
    public String selectValue() throws PropertyVetoException {
        return this._selectedValue;
    }

    public boolean equalsSelectedValue(Object object) {
        if (object == this._selectedValue) {
            return true;
        }
        return object != null && object.equals(this._selectedValue);
    }

    public String toString() {
        return this.getDisplayText();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DefaultAttributeValueItem) {
            DefaultAttributeValueItem item = (DefaultAttributeValueItem)o;
            if (this.getIcon() == this._icon && (this.getDisplayText() == item.getDisplayText() || this.getDisplayText() != null && this.getDisplayText().equals(item.getDisplayText()))) {
                return true;
            }
        }
        return false;
    }

    private DefaultAttributeValueItem(Icon icon, String displayText, String selectedValue) {
        this._text = displayText;
        this._icon = icon;
        this._selectedValue = selectedValue;
    }

    private static String _defaultIfNull(String a, String b) {
        if (a == null) {
            return b;
        }
        return a;
    }
}

