/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.datatransfer.DataFlavor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.xml.share.clipboard.AWTClipboardManager;
import oracle.bali.xml.share.clipboard.ClipboardManager;

class AWTClipboardTester {
    AWTClipboardTester() {
    }

    public static void main(String[] args) throws Throwable {
        int i;
        final ClipboardManager manager = AWTClipboardManager.getClipboardManager();
        System.out.println("Got manager: " + manager);
        ChangeListener tester = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                AWTClipboardTester._printFlavors(manager, "Got change event; flavors now:");
            }

            public String toString() {
                return "printing listener";
            }
        };
        AWTClipboardTester._printFlavors(manager, "Initial set of flavors:");
        manager.addFlavorListener(tester);
        ChangeListener dummy = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
            }

            public String toString() {
                return "no-op anon inner class";
            }
        };
        manager.addFlavorListener(dummy);
        dummy = null;
        Thread.sleep(5000L);
        manager.removeFlavorListener(tester);
        AWTClipboardTester._printFlavors(manager, "Set upon disconnect:");
        Thread.sleep(10000L);
        AWTClipboardTester._printFlavors(manager, "Set after waiting post-disconnect:");
        manager.addFlavorListener(tester);
        Thread.sleep(5000L);
        tester = null;
        for (i = 0; i < 20; ++i) {
            System.gc();
            Thread.sleep(1000L);
        }
        tester = null;
        for (i = 0; i < 40; ++i) {
            System.gc();
            Thread.sleep(1000L);
        }
    }

    private static void _printFlavors(ClipboardManager manager, String intro) {
        System.out.println();
        System.out.print(intro);
        DataFlavor[] flavors = manager.getAvailableDataFlavors();
        if (flavors.length == 0) {
            System.out.println(" [none]");
        } else {
            System.out.println();
            for (int i = 0; i < flavors.length; ++i) {
                System.out.print("  ");
                System.out.println(flavors[i]);
            }
        }
        System.out.println();
    }
}

