/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.util.EventListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.share.UnmodifiableArrayIterator;

public class SafeListenerManager {
    private Object[] _array = new EventListener[0];
    private static final Logger _LOGGER = Logger.getLogger(SafeListenerManager.class.getName());

    public synchronized void addListener(Object listener) {
        if (this._find(listener) != -1) {
            this._logError("Tried to add listener to the same listener manager twice! Manager={0} Listener={1}", listener);
            return;
        }
        Object[] newArray = new Object[this._array.length + 1];
        System.arraycopy(this._array, 0, newArray, 0, this._array.length);
        newArray[newArray.length - 1] = listener;
        this._array = newArray;
    }

    public synchronized void removeListener(Object listener) {
        this.removeListener(listener, true);
    }

    public synchronized void removeListener(Object listener, boolean logIfNotFound) {
        int numAfterIndex;
        int index = this._find(listener);
        if (index == -1) {
            if (logIfNotFound) {
                this._logError("Tried to remove a listener from a listener manager where it was not registered! Manager={0} Listener={1}", listener);
            }
            return;
        }
        Object[] newArray = new Object[this._array.length - 1];
        int numBeforeIndex = index;
        if (numBeforeIndex > 0) {
            System.arraycopy(this._array, 0, newArray, 0, numBeforeIndex);
        }
        if ((numAfterIndex = newArray.length - index) > 0) {
            System.arraycopy(this._array, index + 1, newArray, index, numAfterIndex);
        }
        this._array = newArray;
    }

    public synchronized Iterator iterator() {
        return new UnmodifiableArrayIterator(this._array);
    }

    public synchronized boolean isEmpty() {
        return this._array.length == 0;
    }

    public Iterator iteratorOnSameContents(Iterator oldIterator) {
        if (!(oldIterator instanceof UnmodifiableArrayIterator)) {
            throw new IllegalArgumentException("parameter must be an iterator returned from this class!");
        }
        return new UnmodifiableArrayIterator((UnmodifiableArrayIterator)oldIterator);
    }

    private int _find(Object listener) {
        for (int i = 0; i < this._array.length; ++i) {
            if (this._array[i] != listener) continue;
            return i;
        }
        return -1;
    }

    private void _logError(String msg, Object listener) {
        if (_LOGGER.isLoggable(Level.WARNING)) {
            LogRecord record = new LogRecord(Level.WARNING, msg);
            record.setParameters(new Object[]{this, listener});
            record.setThrown(new RuntimeException("stack trace"));
            _LOGGER.log(record);
        }
    }
}

