/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class MultiCollection<T>
extends AbstractCollection<T> {
    private final Collection<T>[] _cols;

    public MultiCollection(Collection<T>[] cols) {
        if (cols == null) {
            throw new IllegalArgumentException("null arg");
        }
        this._cols = cols;
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this._cols.length; ++i) {
            size += this._cols[i].size();
        }
        return size;
    }

    @Override
    public Iterator<T> iterator() {
        return new MultiIterator();
    }

    private class MultiIterator
    implements Iterator<T> {
        private Iterator<T> _curInner = null;
        private int _nextOuterIndex = 0;

        private MultiIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            while (!(this._curInner != null && this._curInner.hasNext() || this._nextOuterIndex >= MultiCollection.this._cols.length)) {
                this._curInner = MultiCollection.this._cols[this._nextOuterIndex].iterator();
                ++this._nextOuterIndex;
            }
            if (this._curInner == null) {
                return false;
            }
            if (this._curInner.hasNext()) {
                return true;
            }
            this._curInner = null;
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._curInner.next();
        }
    }
}

