/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.view.AbstractMultipleRootFilteredView;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Node;

public class KeyRootedMultipleRootFilteredView
extends AbstractMultipleRootFilteredView {
    private final Set<XmlKey> _childKeys;
    private final XmlKey _rootKey;

    public KeyRootedMultipleRootFilteredView(XmlKey rootKey, XmlKey childKey, XmlKey ... childKeys) {
        if (rootKey == null) {
            throw new IllegalArgumentException("null root key");
        }
        if (childKey == null) {
            throw new IllegalArgumentException("must have at least one child key");
        }
        LinkedHashSet<XmlKey> keySet = new LinkedHashSet<XmlKey>();
        keySet.add(childKey);
        for (XmlKey key : childKeys) {
            keySet.add(key);
        }
        this._childKeys = Collections.unmodifiableSet(keySet);
        this._rootKey = rootKey;
    }

    public KeyRootedMultipleRootFilteredView(String rootNamespaceURI, String rootLocalName, String childNamespaceURI, String childLocalName) {
        if (rootLocalName == null) {
            throw new IllegalArgumentException("null rootLocalName");
        }
        if (childLocalName == null) {
            throw new IllegalArgumentException("null childLocalName");
        }
        XmlKey rootKey = ImmutableXmlKey.createElementKey((String)rootNamespaceURI, (String)rootLocalName);
        ArrayList<QualifiedName> list = new ArrayList<QualifiedName>(2);
        list.add(rootKey.getElementQName());
        list.add(QualifiedName.getQualifiedName((String)childNamespaceURI, (String)childLocalName));
        HashSet<XmlKey> keySet = new HashSet<XmlKey>();
        keySet.add(ImmutableXmlKey.createElementKey(list));
        this._childKeys = Collections.unmodifiableSet(keySet);
        this._rootKey = rootKey;
    }

    public Set<XmlKey> getChildKeySet() {
        return this._childKeys;
    }

    @Override
    protected Set updateRootNodes(XmlModelEvent event, Set oldRoots) {
        boolean needToFindRoot;
        boolean bl = needToFindRoot = event == null || oldRoots.size() == 0 || event.getDomDocumentPropertyChange() != null || event.getChangeRoot() == null || KeyRootedMultipleRootFilteredView.__isDecendentOfRootNode(oldRoots, event.getChangeRoot());
        if (needToFindRoot) {
            return this.getRoots(this.getBaseModel(), this._rootKey, this._childKeys);
        }
        return oldRoots;
    }

    protected Set getRoots(AbstractModel model, XmlKey rootKey, Set<XmlKey> childKeys) {
        TreeTraversal traversal = model.getTreeTraversal();
        Node rootNode = XmlModelUtils.findFirstNodeByKey(model, rootKey);
        HashSet<Node> s = new HashSet<Node>();
        if (rootNode == null) {
            return s;
        }
        Node walk = traversal.getFirstChild(rootNode);
        while (walk != null) {
            XmlKey walkKey = model.getNodeXmlKey(walk);
            if (childKeys.contains(walkKey)) {
                if (s == null) {
                    s = new HashSet();
                }
                s.add(walk);
            }
            walk = traversal.getNextSibling(walk);
        }
        return s;
    }

    @Override
    protected boolean isPossibleNewleyCreatedRoot(Node node) {
        return this._childKeys.contains(this.getXmlMetadataResolver().getNodeXmlKey(node));
    }
}

