/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.model.message.XmlModelMessageIssueList;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;

public class SimpleXmlModelMessageIssueList
implements XmlModelMessageIssueList {
    private final List<XmlModelMessage> _messages = new ArrayList<XmlModelMessage>();
    private final List<XmlModelMessage> _immutableMessages = Collections.unmodifiableList(this._messages);
    private int _errorCount = 0;
    private int _warningCount = 0;
    private int _incompleteCount = 0;
    private int _advisoryCount = 0;

    @Override
    public List<XmlModelMessage> getMessages() {
        return this._immutableMessages;
    }

    @Override
    public final boolean hasErrors() {
        return this.getErrorCount() > 0;
    }

    @Override
    public final boolean hasWarnings() {
        return this.getWarningCount() > 0;
    }

    @Override
    public final boolean hasIncompletes() {
        return this.getIncompleteCount() > 0;
    }

    public final int getErrorCount() {
        return this._errorCount;
    }

    public final int getWarningCount() {
        return this._warningCount;
    }

    public final int getIncompleteCount() {
        return this._incompleteCount;
    }

    public final int getAdvisoryCount() {
        return this._advisoryCount;
    }

    public final Iterator<Issue> iterator() {
        List<XmlModelMessage> list = this._immutableMessages;
        return list.iterator();
    }

    public final Issue getIssueAt(int index) {
        return this._immutableMessages.get(index);
    }

    public final Severity getSeverity() {
        if (this.getErrorCount() > 0) {
            return Severity.ERROR;
        }
        if (this.getWarningCount() > 0) {
            return Severity.WARNING;
        }
        if (this.getIncompleteCount() > 0) {
            return Severity.INCOMPLETE;
        }
        return Severity.OK;
    }

    public final boolean isStale() {
        return false;
    }

    public final int size() {
        return this._immutableMessages.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (XmlModelMessage obj : this._messages) {
            if (obj == null) continue;
            buf.append(obj);
            buf.append("\n");
        }
        return buf.toString();
    }

    public void addMessage(XmlModelMessage msg) {
        this._messages.add(msg);
        switch (msg.getSeverity()) {
            case ERROR: {
                ++this._errorCount;
                break;
            }
            case WARNING: {
                ++this._warningCount;
                break;
            }
            case INCOMPLETE: {
                ++this._incompleteCount;
                break;
            }
            case ADVISORY: {
                ++this._advisoryCount;
                break;
            }
        }
    }
}

