/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency.id;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.XmlReference;
import oracle.bali.xml.model.traversal.MutableTraversalData;
import oracle.bali.xml.model.traversal.TraversalData;
import oracle.bali.xml.model.traversal.TraversalHandler;
import org.w3c.dom.Node;

public class IdReference
extends XmlReference
implements TraversalHandler {
    public static final String ID_REFS = "XSD_ID_REFERENCES";

    public IdReference(XmlContext xmlContext, Node node, int start, int end) {
        super(xmlContext, node, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Declaration findDeclaration(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            String value;
            HashMap map;
            TraversalData data = context.getTraversalData(model.getContext());
            if (data.containsKey(this.getDeclarationId()) && (map = (HashMap)data.get(this.getDeclarationId())).containsKey(value = this.getValue(context))) {
                Declaration declaration = (Declaration)map.get(value);
                return declaration;
            }
        }
        finally {
            model.releaseReadLock();
        }
        return null;
    }

    @Override
    protected String getDisplayNameImpl(DependencyContext context) {
        return "Id Reference: '" + this.getValue(context) + "'";
    }

    protected String getDeclarationId() {
        return "XSD_ID_DECLARATIONS";
    }

    protected String getReferenceId() {
        return ID_REFS;
    }

    @Override
    public void handleStartNode(XmlModel model, Node node, MutableTraversalData data) {
        String id;
        ArrayList<IdReference> idRefs;
        HashMap<String, ArrayList<IdReference>> map = (HashMap<String, ArrayList<IdReference>>)data.get(this.getReferenceId());
        if (map == null) {
            map = new HashMap<String, ArrayList<IdReference>>();
        }
        if ((idRefs = (ArrayList<IdReference>)map.get(id = this.getValue(node))) == null) {
            idRefs = new ArrayList<IdReference>();
        }
        idRefs.add(this);
        map.put(id, idRefs);
        data.put(this.getReferenceId(), map);
    }

    @Override
    public void handleEndNode(XmlModel model, Node node, MutableTraversalData data) {
    }

    protected final String getValue(Node node) {
        String textValue = DomUtils.getTextNodeValue((Node)node);
        return textValue.substring(this.getStartIndex(), this.getEndIndex());
    }
}

