/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.model.datatransfer.operation.PerformOperationAction;
import oracle.bali.xml.share.GroupingAction;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.util.ModelUtil;

public abstract class Operation {
    public static final float STANDARD_OPERATIONS_RANK = 0.9f;
    public static final String FLATTENED_NAME = Operation.class.getName() + "-flattened name";

    public abstract int getSupportedActions();

    public boolean doesActionMutateModel() {
        return true;
    }

    public abstract List getApplicableDataAndPositions(AbstractModel var1, List var2, ExtendedTransferable var3);

    public abstract boolean apply(AbstractModel var1, DomPosition var2, TransferDataInfo var3, TransactionToken var4) throws IOException, XmlCommitException;

    public Action createAsAction(AbstractModel model, List listOfDataAndPositions) {
        if (listOfDataAndPositions.size() == 1) {
            DataAndPositions dap = (DataAndPositions)listOfDataAndPositions.get(0);
            TransferDataInfo data = dap.getData();
            List positions = dap.getPositions();
            String dataDisplayName = this.getDisplayName(model, data);
            if (positions.size() == 1) {
                DomPosition pos = (DomPosition)positions.get(0);
                return this._createAction(model, data, pos, dataDisplayName);
            }
            GroupingAction grouping = new GroupingAction();
            grouping.putValue("Name", dataDisplayName);
            for (DomPosition position : positions) {
                Action action = this._createAction(model, data, position, this.getPositionDisplayName(model, position));
                grouping.addChildAction(action);
            }
            return grouping;
        }
        GroupingAction grouping = new GroupingAction();
        grouping.putValue("Name", this.getDisplayName(model, null));
        LinkedHashMap<String, GroupingAction> nameToGroup = new LinkedHashMap<String, GroupingAction>();
        for (DataAndPositions dap : listOfDataAndPositions) {
            TransferDataInfo data = dap.getData();
            Object md = data.getMetadata(TransferDataInfo.METADATA_SHORT_DESCRIPTION);
            String desc = md instanceof String ? (String)md : data.toString();
            DomPosition pos = (DomPosition)dap.getPositions().get(0);
            Action childAction = this._createAction(model, data, pos, desc);
            String subgroup = (String)ModelUtil.as((Object)data.getMetadata(XmlTransferUtils.KEY_SUBGROUP_NAME), String.class);
            if (subgroup == null) {
                grouping.addChildAction(childAction);
                continue;
            }
            GroupingAction subgroupAction = (GroupingAction)nameToGroup.get(subgroup);
            if (subgroupAction == null) {
                subgroupAction = new GroupingAction();
                subgroupAction.putValue("Name", subgroup);
                nameToGroup.put(subgroup, subgroupAction);
                grouping.addChildAction(subgroupAction);
            }
            subgroupAction.addChildAction(childAction);
        }
        return grouping;
    }

    public abstract String getDisplayName(AbstractModel var1, TransferDataInfo var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getPositionDisplayName(AbstractModel model, DomPosition position) {
        String key = position.isBefore() ? "BeforePosition" : (position.isAfter() ? "AfterPosition" : "InsidePosition");
        model.acquireReadLock();
        try {
            String string = model.getTranslatedString(key, model.getXmlMetadataResolver().getMediumDisplayName(position.getTargetNode()));
            return string;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public abstract float getSuitabilityRank();

    private Action _createAction(AbstractModel model, TransferDataInfo data, DomPosition pos, String displayName) {
        PerformOperationAction action = new PerformOperationAction(this, model, data, pos);
        action.putValue("Name", StringUtils.stripMnemonic((String)displayName));
        Object md = data.getMetadata(TransferDataInfo.METADATA_ICON);
        Icon icon = (Icon)ModelUtil.as((Object)md, Icon.class);
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
        return action;
    }

    public static class RejectOperatingAndDontQueryLowerRankedOps
    extends RuntimeException {
    }
}

