/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.category;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;

public abstract class CategoryDefinition
implements Comparable<CategoryDefinition> {
    public static final int DEFAULT_DISPLAY_ORDER = -1;
    private final String _identifier;

    public final String getIdentifier() {
        return this._identifier;
    }

    public final String getDisplayName() {
        String displayName = this.getDisplayNameImpl();
        if (displayName == null) {
            displayName = this.getIdentifier();
        }
        return displayName;
    }

    public String getDescription() {
        return null;
    }

    public Icon getSmallIcon() {
        return null;
    }

    public int getDisplayOrder() {
        return -1;
    }

    public float getPreferredPageRank() {
        return -1.0f;
    }

    public boolean getOpenByDefault() {
        return false;
    }

    public Iterator<CategoryDefinition> getSubCategoryDefinitions() {
        return Collections.emptyList().iterator();
    }

    public CategoryDefinition getSubCategoryDefinition(String identifier) {
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public int compareTo(CategoryDefinition o1) {
        return this.getDisplayName().compareTo(o1.getDisplayName());
    }

    protected String getDisplayNameImpl() {
        return null;
    }

    protected CategoryDefinition(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("CategoryDefinition: identifier cannot be null");
        }
        this._identifier = identifier;
    }

    public static class CategoryDefinitionComparator
    implements Comparator<CategoryDefinition> {
        @Override
        public int compare(CategoryDefinition cd1, CategoryDefinition cd2) {
            if (cd1.getDisplayOrder() == cd2.getDisplayOrder()) {
                return cd1.getDisplayName().compareToIgnoreCase(cd2.getDisplayName());
            }
            return cd1.getDisplayOrder() <= cd2.getDisplayOrder() ? -1 : 1;
        }
    }
}

