/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.action.ModelAction;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.share.BaseAction;

public class BaseModelAction
extends BaseAction
implements ModelAction {
    private AbstractModel _model;
    private volatile boolean _recalcEnabled;
    private final transient XmlModelListener _modelListener;
    private final transient PropertyChangeListener _contextListener;
    private static final Logger _LOGGER = Logger.getLogger(BaseModelAction.class.getName());

    public BaseModelAction(String mnemonicAndDisplayName, KeyStroke accelerator, String actionCommand, boolean needsModelListener, boolean needsContextListener) {
        super(StringUtils.stripMnemonic((String)mnemonicAndDisplayName), StringUtils.getMnemonicKeyCode((String)mnemonicAndDisplayName), accelerator, actionCommand, null);
        if (needsModelListener || needsContextListener) {
            Listener changeListener = new Listener();
            this._modelListener = needsModelListener ? changeListener : null;
            this._contextListener = needsContextListener ? changeListener : null;
        } else {
            this._modelListener = null;
            this._contextListener = null;
        }
    }

    @Override
    public boolean isActiveViewAction() {
        return false;
    }

    @Override
    public final void setModel(AbstractModel model) {
        if (model != this._model) {
            if (this._contextListener != null) {
                XmlContext newContext;
                XmlContext oldContext = this._model != null ? this._model.getContext() : null;
                XmlContext xmlContext = newContext = model != null ? model.getContext() : null;
                if (oldContext != newContext) {
                    if (oldContext != null) {
                        oldContext.removePropertyChangeListener(this._contextListener);
                    }
                    if (newContext != null) {
                        newContext.addPropertyChangeListener(this._contextListener);
                    }
                }
            }
            this._model = model;
            this._updateEnabled();
        }
    }

    @Override
    public final AbstractModel getModel() {
        return this._model;
    }

    @Override
    public XmlModelListener getModelListener() {
        return this._modelListener;
    }

    protected boolean isEnabledImpl() {
        AbstractModel model = this.getModel();
        if (model == null) {
            return false;
        }
        if (!this._mutatesModel()) {
            return true;
        }
        model.acquireReadLock();
        try {
            boolean bl = !model.isReadOnly();
            return bl;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected boolean needToUpdateEnabled(XmlModelEvent event) {
        return true;
    }

    protected boolean needToUpdateEnabled(PropertyChangeEvent event) {
        return true;
    }

    protected final boolean needsToRespondToReadOnlyChange(XmlModelEvent event) {
        return this._mutatesModel() && event.getPropertyChange("readOnly") != null;
    }

    private boolean _mutatesModel() {
        return Boolean.TRUE.equals(this.getValue("XmlContext.MUTATES_MODEL"));
    }

    protected final void scheduleRecalculateEnabled(final int waitMs) {
        if (waitMs <= 0) {
            throw new IllegalArgumentException("non-positive wait ms");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(waitMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (BaseModelAction.this._recalcEnabled) {
                    BaseModelAction.this._updateEnabled();
                }
            }
        };
        this._recalcEnabled = true;
        Thread thread = new Thread(r, "recalc thread for " + this.getClass());
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    private void _updateEnabled() {
        AbstractModel model = this.getModel();
        if (model != null) {
            model.acquireReadLock();
        }
        try {
            boolean enabled = this.isEnabledImpl();
            this.setEnabled(enabled);
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "setEnabled on {0} to {1}, model={2}", new Object[]{this, enabled, model});
            }
        }
        finally {
            if (model != null) {
                model.releaseReadLock();
            }
        }
        if (this._recalcEnabled) {
            this._recalcEnabled = false;
        }
    }

    private class Listener
    extends XmlModelAdapter
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void listenerAttached(XmlModelEvent event) {
            BaseModelAction.this._updateEnabled();
        }

        @Override
        public void modelChanged(XmlModelEvent event) {
            if (BaseModelAction.this._recalcEnabled || BaseModelAction.this.needToUpdateEnabled(event)) {
                BaseModelAction.this._updateEnabled();
            }
        }

        @Override
        public void listenerDetached(XmlModelEvent event) {
            BaseModelAction.this._updateEnabled();
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (BaseModelAction.this.needToUpdateEnabled(event)) {
                if (BaseModelAction.this.getModel().getBaseModel().isInTransaction()) {
                    BaseModelAction.this._recalcEnabled = true;
                } else {
                    BaseModelAction.this._updateEnabled();
                }
            }
        }
    }
}

