/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.SelectionTransaction;
import oracle.bali.xml.model.SetChangeListener;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.bali.xml.share.UnmodifiableIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Selection {
    private SelectionTransaction _currTransaction;
    private SelectionTransaction _rootTransaction;
    private DomRange _rangeSelection = null;
    private final AbstractModel _owner;
    private final LinkedHashSet<Node> _selectedNodes = new LinkedHashSet();
    private final LinkedList<Node> _removeList = new LinkedList();
    private final LinkedList<Node> _addList = new LinkedList();
    private DomPosition _cursorLocation;
    private DomPosition _dropLocation;
    private static final Logger _LOGGER = Logger.getLogger(Selection.class.getName());

    public Selection(AbstractModel owner) {
        if (owner == null) {
            throw new IllegalArgumentException("No owner specified");
        }
        this._owner = owner;
        this._startTransaction();
        this._rootTransaction = this._currTransaction;
    }

    public DomPosition getCursorLocation() {
        return this._cursorLocation;
    }

    public DomPosition setCursorLocation(DomPosition newCursorLocation) {
        this.checkTransaction();
        newCursorLocation = this.getModel().convertInsertionPosition(newCursorLocation);
        this.checkValidDomPosition(newCursorLocation);
        this.setCursorLocationImpl(newCursorLocation);
        return newCursorLocation;
    }

    public DomPosition getDropLocation() {
        return this._dropLocation;
    }

    public DomPosition setDropLocation(DomPosition newDropLocation) {
        this.checkTransaction();
        this.checkValidDomPosition(newDropLocation);
        this.setDropLocationImpl(newDropLocation);
        return newDropLocation;
    }

    public Node getEarliestSelectedNode() {
        this._verifyLock();
        Iterator<Node> selection = this.getSelectedNodes();
        Node earliestNode = null;
        TreeTraversal traversal = this.getModel().getTreeTraversal();
        while (selection.hasNext()) {
            earliestNode = DomUtils.earlierPreorderNode((TreeTraversal)traversal, earliestNode, (Node)selection.next());
        }
        return earliestNode;
    }

    public final AbstractModel getModel() {
        return this._owner;
    }

    public Node getLatestSelectedNode() {
        this._verifyLock();
        Iterator<Node> selection = this.getSelectedNodes();
        TreeTraversal traversal = this.getModel().getTreeTraversal();
        Node latestNode = null;
        while (selection.hasNext()) {
            latestNode = DomUtils.laterPreorderNode((TreeTraversal)traversal, latestNode, (Node)selection.next());
        }
        return latestNode;
    }

    public Node getFirstSelectedNode() {
        this._verifyLock();
        Iterator<Node> itor = this.getSelectedNodes();
        if (itor.hasNext()) {
            return itor.next();
        }
        return null;
    }

    public boolean isEmpty() {
        this._verifyLock();
        return this._selectedNodes.isEmpty();
    }

    public boolean clear() {
        this.checkTransaction();
        this._currTransaction.__selectionCleared();
        if (this._selectedNodes.isEmpty()) {
            assert (this._rangeSelection == null);
            return false;
        }
        this._removeList.addAll(this._selectedNodes);
        this._selectedNodes.clear();
        this._rangeSelection = null;
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Cleared selection: {0}", this);
        }
        return true;
    }

    public final boolean add(Node domNode) {
        this.checkTransaction();
        this.checkValidNode(domNode);
        return this.addImpl(domNode);
    }

    public final boolean remove(Node domNode) {
        this.checkTransaction();
        this.checkValidNode(domNode);
        return this.removeImpl(domNode);
    }

    public final boolean set(Node domNode) {
        return this.set(Collections.singleton(domNode));
    }

    public final boolean set(Collection<? extends Node> nodes) {
        this.checkTransaction();
        if (this._selectedNodes.equals(nodes)) {
            return false;
        }
        this.clear();
        this.add(nodes);
        return true;
    }

    public final void remove(Collection<? extends Node> nodes) {
        this.checkTransaction();
        for (Node node : nodes) {
            this.checkValidNode(node);
            this.removeImpl(node);
        }
    }

    public final void add(Collection<? extends Node> nodes) {
        this.checkTransaction();
        for (Node node : nodes) {
            this.checkValidNode(node);
            this.addImpl(node);
        }
    }

    public Node[] getSelectedNodesArray() {
        this._verifyLock();
        Node[] nodes = new Node[this.size()];
        if (nodes.length != 0) {
            nodes = this._selectedNodes.toArray(nodes);
        }
        return nodes;
    }

    public List<Node> getSelectedNodesList() {
        this._verifyLock();
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return new UnmodifiableArrayList<Node>(this.getSelectedNodesArray());
    }

    public int size() {
        this._verifyLock();
        return this._selectedNodes.size();
    }

    public boolean contains(Node domNode) {
        this._verifyLock();
        this.checkValidNode(domNode);
        return this._selectedNodes.contains(domNode);
    }

    public boolean containsOnly(Node domNode) {
        this._verifyLock();
        this.checkValidNode(domNode);
        return this._selectedNodes.size() == 1 && domNode == this.getFirstSelectedNode();
    }

    public Iterator<Node> getSelectedNodes() {
        this._verifyLock();
        return new LockAssertingUnmodifiableIterator(this._selectedNodes.iterator());
    }

    public int getSelectedNodesCount() {
        this._verifyLock();
        return this._selectedNodes.size();
    }

    public final DomRange createDomRange(DomPosition first, DomPosition second) {
        this._verifyLock();
        return DomRange.create((DomPosition)first, (DomPosition)second, (TreeTraversal)this.getModel().getTreeTraversal());
    }

    public void extendRangeSelection(DomPosition pos) {
        this.checkTransaction();
        if (!this.hasRangeSelection()) {
            throw new IllegalStateException("can't extend since there is no current range!");
        }
        TreeTraversal traversal = this.getModel().getTreeTraversal();
        DomRange oldRange = this.getRangeSelection();
        if (oldRange.compareTo(traversal, pos, true) != 0) {
            this.setRangeSelection(oldRange.getExtendedRange(traversal, pos));
        }
    }

    public void moveRangeSelectionStart(DomPosition pos) {
        this.checkTransaction();
        if (!this.hasRangeSelection()) {
            throw new IllegalStateException("can't move selection start since there is no current range!");
        }
        DomRange oldRange = this.getRangeSelection();
        DomRange changed = oldRange.getRangeWithNewStart(this.getModel().getTreeTraversal(), pos);
        this.setRangeSelection(changed);
    }

    public void moveRangeSelectionEnd(DomPosition pos) {
        this.checkTransaction();
        if (!this.hasRangeSelection()) {
            throw new IllegalStateException("can't move selection end since there is no current range!");
        }
        DomRange oldRange = this.getRangeSelection();
        DomRange changed = oldRange.getRangeWithNewEnd(this.getModel().getTreeTraversal(), pos);
        this.setRangeSelection(changed);
    }

    public void setRangeSelection(DomRange range) {
        List list;
        this.checkTransaction();
        List list2 = list = range == null ? Collections.emptyList() : range.getNodesInRange(this.getModel().getTreeTraversal());
        if (range == null || list.isEmpty()) {
            this.clear();
        } else if (!range.equals((Object)this._rangeSelection)) {
            this.set(list);
            this.setRangeSelectionImpl(range);
        }
    }

    public boolean hasRangeSelection() {
        return this._rangeSelection != null;
    }

    public DomRange getRangeSelection() {
        this._verifyLock();
        return this._rangeSelection;
    }

    public void checkValidNode(Node node) {
        Document selectionDocument;
        this._verifyLock();
        if (node == null) {
            throw new IllegalArgumentException("null node!");
        }
        Document nodeDocument = node.getOwnerDocument();
        if (nodeDocument != (selectionDocument = this.getSelectionDocument()) && node != selectionDocument) {
            throw new DOMException(4, "Not selection document:" + nodeDocument);
        }
        if (!this.getModel().isInModelDocumentHierarchy(node)) {
            throw new IllegalArgumentException("Node not in document hierarchy!");
        }
    }

    public void checkValidDomPosition(DomPosition newDomPosition) {
        this._verifyLock();
        if (newDomPosition != null) {
            this.checkValidNode(newDomPosition.getTargetNode());
        }
    }

    public String toString() {
        return super.toString() + " selection=" + this._selectedNodes;
    }

    public final void acquireModelReadLock() {
        this.getModel().acquireReadLock();
    }

    public final void releaseModelReadLock() {
        this.getModel().releaseReadLock();
    }

    protected boolean addImpl(Node domNode) {
        return Selection.addNodeDirectly(this, domNode);
    }

    protected boolean removeImpl(Node domNode) {
        return Selection.removeNodeDirectly(this, domNode);
    }

    protected Map getSnapshotState(Map snapshotState) {
        snapshotState.put("cursorLocation", this._cursorLocation);
        snapshotState.put("dropLocation", this._dropLocation);
        snapshotState.put("rangeSelection", this._rangeSelection);
        return snapshotState;
    }

    protected void restoreSnapshotState(Map snapshotState) {
        this.setCursorLocationImpl((DomPosition)snapshotState.get("cursorLocation"));
        this.setDropLocationImpl((DomPosition)snapshotState.get("dropLocation"));
        this.setRangeSelectionImpl((DomRange)snapshotState.get("rangeSelection"));
    }

    protected void addSelectionChangeListener(SetChangeListener listener) {
        this._currTransaction.addSelectionChangeListener(listener);
    }

    protected void removeSelectionChangeListener(SetChangeListener listener) {
        this._currTransaction.removeSelectionChangeListener(listener);
    }

    protected void addPropertyChangeListener(PropertyChangeListener listener) {
        this._currTransaction.addPropertyChangeListener(listener);
    }

    protected void removePropertyChangeListener(PropertyChangeListener listener) {
        this._currTransaction.removePropertyChangeListener(listener);
    }

    protected final void checkTransaction() {
        if (!this.isInTransaction()) {
            throw new IllegalStateException("No Mutation allowed outside of transaction");
        }
        this._verifyWriteLock();
    }

    protected static boolean removeNodeDirectly(Selection selection, Node node) {
        selection._verifyWriteLock();
        boolean changed = selection._selectedNodes.remove(node);
        if (changed) {
            selection._removeList.add(node);
            selection._rangeSelection = null;
        }
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "removeNode: {0} from selection {1} (model={2}) {3}", new Object[]{selection.getModel().getXmlMetadataResolver().getMediumDisplayName(node), selection, selection.getModel(), changed ? "" : " (node was already not selected)"});
        }
        return changed;
    }

    protected static boolean addNodeDirectly(Selection selection, Node node) {
        selection._verifyWriteLock();
        boolean changed = selection._selectedNodes.add(node);
        if (changed) {
            selection._addList.add(node);
            selection._rangeSelection = null;
        }
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "addNode: {0} to selection {1} (model={2}) {3}", new Object[]{selection.getModel().getXmlMetadataResolver().getMediumDisplayName(node), selection, selection.getModel(), changed ? "" : " (node was already selected)"});
        }
        return changed;
    }

    protected final void clearRangeSelectionPreservingNodes() {
        this._rangeSelection = null;
    }

    protected final void addNodeSubtreeIfWithinSelectedRange(Node node) {
        if (this.hasRangeSelection() && this.getRangeSelection().isInRange(this.getModel().getTreeTraversal(), node)) {
            this._updateNodeSubtree(node, true);
        }
    }

    protected final void handleRemovalFromModel(Node targetNode) {
        this.checkTransaction();
        DomRange oldRange = this.getRangeSelection();
        TreeTraversal traversal = this.getTreeTraversal();
        Set removedSubtreeNodes = DomUtils.getNodesInSubtree((TreeTraversal)traversal, (Node)targetNode);
        this.remove(removedSubtreeNodes);
        if (oldRange != null) {
            DomPosition oldStart = oldRange.getStart();
            Node oldStartNode = oldStart.getTargetNode();
            DomPosition oldEnd = oldRange.getEnd();
            Node oldEndNode = oldEnd.getTargetNode();
            boolean startWasDeleted = removedSubtreeNodes.contains(oldStartNode);
            boolean endWasDeleted = removedSubtreeNodes.contains(oldEndNode);
            if (startWasDeleted && endWasDeleted) {
                this.clearRangeSelectionPreservingNodes();
            } else if (!startWasDeleted && !endWasDeleted) {
                this._rangeSelection = oldRange;
            } else if (startWasDeleted) {
                Node newStartNode = this._nextNodeNotInSet(removedSubtreeNodes, oldStartNode, oldEndNode);
                if (newStartNode == null) {
                    this.clearRangeSelectionPreservingNodes();
                } else if (newStartNode == oldEndNode) {
                    if (oldEnd.isBefore()) {
                        this.clearRangeSelectionPreservingNodes();
                    } else {
                        this._rangeSelection = this.createDomRange(oldEnd.getBeforePosition(), oldEnd);
                    }
                } else {
                    this._rangeSelection = this.createDomRange(DomPositionFactory.createDomPosition((Node)newStartNode, (int)1), oldEnd);
                }
            } else if (endWasDeleted) {
                DomPosition newEnd = null;
                if (oldEndNode == targetNode) {
                    Node nextSibling = traversal.getNextSibling(oldEndNode);
                    if (nextSibling != null) {
                        newEnd = DomPositionFactory.createDomPosition((Node)nextSibling, (int)1);
                    } else {
                        Node prevSibling = traversal.getPreviousSibling(oldEndNode);
                        if (prevSibling != null) {
                            newEnd = DomPositionFactory.createDomPosition((Node)prevSibling, (int)2);
                        } else {
                            Node parent = traversal.getParentNode(oldEndNode);
                            newEnd = DomPositionFactory.createDomPosition((Node)parent, (int)0);
                        }
                    }
                }
                if (newEnd == null) {
                    this.clearRangeSelectionPreservingNodes();
                } else {
                    this._rangeSelection = this.createDomRange(oldStart, newEnd);
                }
            }
        }
    }

    protected final Document getSelectionDocument() {
        this._verifyLock();
        return this.getModel().getDocument();
    }

    protected final TreeTraversal getTreeTraversal() {
        this._verifyLock();
        return this.getModel().getTreeTraversal();
    }

    protected LinkedHashSet getSelectedNodeStorage() {
        this._verifyLock();
        if (this.isInTransaction()) {
            throw new IllegalStateException("No updating selection storage inside transaction");
        }
        return this._selectedNodes;
    }

    protected Set<Node> getSelectedNodeSet() {
        this._verifyLock();
        return this._selectedNodes;
    }

    protected final boolean isInTransaction() {
        return this._rootTransaction != this._currTransaction;
    }

    protected final void setCursorLocationImpl(DomPosition newCursorLocation) {
        this._cursorLocation = newCursorLocation;
    }

    protected final void setDropLocationImpl(DomPosition newDropLocation) {
        this._dropLocation = newDropLocation;
    }

    protected final void setRangeSelectionImpl(DomRange newRangeSelection) {
        this._rangeSelection = newRangeSelection;
    }

    void __startTransaction() {
        this.getModel().__acquireWriteLock();
        this._startTransaction();
    }

    private void _startTransaction() {
        this._currTransaction = new SelectionTransaction(this._currTransaction, this._addList.size(), this._removeList.size(), this.getSnapshotState(new HashMap(7)));
    }

    void __rollbackTransaction() {
        this._currTransaction = this._currTransaction.rollback(this, this._selectedNodes, this._addList, this._removeList);
        this.getModel().__releaseWriteLock();
    }

    protected boolean commitTransaction() {
        this._currTransaction = this._currTransaction.commit(this, this._addList, this._removeList);
        this.getModel().__releaseWriteLock();
        return this._currTransaction == this._rootTransaction;
    }

    private Node _nextNodeNotInSet(Set set, Node start, Node stopAt) {
        this._verifyLock();
        Node newStartNode = start;
        while ((newStartNode = this.getTreeTraversal().getNextNode(newStartNode)) != null && newStartNode != stopAt && set.contains(newStartNode)) {
        }
        return newStartNode;
    }

    private void _updateNodeSubtree(Node node, boolean isAdd) {
        boolean changed;
        this._verifyLock();
        if (isAdd) {
            changed = this._selectedNodes.add(node);
            if (changed) {
                this._addList.add(node);
            }
        } else {
            changed = this._selectedNodes.remove(node);
            if (changed) {
                this._removeList.add(node);
            }
        }
        TreeTraversal trav = this.getModel().getTreeTraversal();
        Node child = trav.getFirstChild(node);
        while (child != null) {
            this._updateNodeSubtree(child, isAdd);
            child = trav.getNextSibling(child);
        }
    }

    private void _verifyLock() {
        this.getModel().__verifyLock();
    }

    private void _verifyWriteLock() {
        this.getModel().__verifyWriteLock();
    }

    public class LockAssertingUnmodifiableIterator
    extends UnmodifiableIterator<Node> {
        public LockAssertingUnmodifiableIterator(Iterator<Node> real) {
            super(real);
        }

        @Override
        public Node next() {
            Selection.this._verifyLock();
            return (Node)super.next();
        }

        @Override
        public boolean hasNext() {
            Selection.this._verifyLock();
            return super.hasNext();
        }
    }
}

