/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector.editors;

import oracle.bali.xml.gui.base.inspector.editors.AbstractSimplePropretyEditor;
import oracle.bali.xml.share.FastMessageFormat;

public final class BooleanEditor
extends AbstractSimplePropretyEditor<Boolean> {
    private static final String _sTRUE = "true";
    private static final String _sFALSE = "false";
    private static final String[] _sTags = new String[]{"true", "false"};

    public BooleanEditor() {
        super(Boolean.class);
    }

    @Override
    public String[] getTags() {
        return _sTags;
    }

    @Override
    protected String getJavaInitializationStringImpl(Boolean value) {
        return this.getStringForValue(value);
    }

    @Override
    protected Boolean getValueForString(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        String trimmed = string.trim();
        if (trimmed.equalsIgnoreCase(_sTRUE)) {
            return true;
        }
        if (trimmed.equalsIgnoreCase(_sFALSE)) {
            return false;
        }
        if (trimmed.equalsIgnoreCase("1")) {
            return true;
        }
        if (trimmed.equalsIgnoreCase("0")) {
            return false;
        }
        String msg = this.getBundle().getString("BOOLEAN_EDITOR_ERROR");
        throw new IllegalArgumentException(FastMessageFormat.formatMessage(msg, string));
    }

    @Override
    protected String getStringForValue(Boolean value) {
        return value != false ? _sTRUE : _sFALSE;
    }
}

