/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.beans.PropertyEditor;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.share.beans.JavaPropertyEditorManager;
import oracle.bali.xml.dom.ElementCustomizationDetails;
import oracle.bali.xml.dom.NodeCustomizationDetails;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.binding.BaseDatabindingEditorGui;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.EnumeratedValuesInfo;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlPreferences;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.util.AttributeSetter;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.AttributeValueItemProvider;
import oracle.bali.xml.util.AttributeValueItemProvider2;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlKeyPropertyRow
extends PropertyRow {
    private Node _node;
    private final XmlKey _key;
    private static final ConcurrentHashMap<String, PropertyGroup> _sPropertyGroups = new ConcurrentHashMap(17, 0.75f, 1);

    public XmlKeyPropertyRow(BaseInspectorGui gui, XmlKey key, Node node, PropertyRowOwner owner) {
        super(gui, owner);
        if (key == null) {
            throw new IllegalArgumentException("No XMlKey for row");
        }
        this._key = key;
        this._node = node;
    }

    @Override
    protected void setDefaultRowValueImpl() {
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        Node rowNode = this.getNode();
        if (rowNode != null) {
            resolver.setNodeToDefault(rowNode);
        } else {
            Node parentNode = this.getOwner().getParentNode();
            if (parentNode != null) {
                resolver.setNodeToDefault(this.getKey(), parentNode);
            }
        }
        this.__setNode(null);
    }

    public Node getNode() {
        return this._node;
    }

    public XmlKey getKey() {
        return this._key;
    }

    @Override
    protected Object getColumnValueImpl(int columnIndex) {
        Node ownerNode = this.getOwner().getParentNode();
        XmlKey ownerKey = this.getOwner().getParentKey();
        Object result = null;
        XmlKey key = this.__getQueryKey();
        Node node = this.__getQueryNode();
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        switch (columnIndex) {
            case 0: {
                result = this.__createPropertyId();
                break;
            }
            case 25: 
            case 39: {
                result = this.getKey();
                break;
            }
            case 1: {
                if (node != null) {
                    result = this.getPropertyDisplayName(resolver, node);
                    break;
                }
                result = this.getPropertyDisplayName(resolver, key, ownerNode, ownerKey);
                break;
            }
            case 4: {
                Object piValue = this.getColumnValue(2);
                if (piValue == null) {
                    return this.getRowValueAsString(true);
                }
                boolean isDefault = !this.isSet();
                result = node != null ? resolver.getDisplayValue(node, piValue, isDefault) : resolver.getDisplayValue(key, ownerNode, piValue, isDefault);
                if (result == null) break;
                result = result.toString();
                break;
            }
            case 2: {
                result = this._convertRowValueToObject(false);
                break;
            }
            case 37: {
                Object pe = this._getPropertyEditor();
                PropertyEditorFactory2 pef2 = AttributeValueItemPropertyEditor.create(this, this.getPEF2(pe));
                result = pef2;
                break;
            }
            case 5: {
                result = this.isSet();
                break;
            }
            case 14: {
                result = key.getLocalName();
                break;
            }
            case 20: {
                result = resolver.getJavaType(key, this.getRowValueAsString(true));
                break;
            }
            case 6: {
                result = XmlKeyPropertyRow.__getPropertyGroup(key, resolver);
                break;
            }
            case 7: {
                result = resolver.isExpert(key);
                break;
            }
            case 8: {
                boolean showExpert;
                if (resolver.isDeprecated(key) && this._convertRowValueToObject(false) == null) {
                    return true;
                }
                Node inspectableNode = this.getOwner().getTargetNode();
                boolean isHidden = this._isHidden();
                if (!(this.getView().getBaseModel().isInModelDocumentHierarchy(inspectableNode) && !XmlModelUtils.isConvertCustomizerRunning() || isHidden)) {
                    isHidden = !this.isCommon(key) || this.getOwner().getPromotionPath().size() > 1;
                }
                result = isHidden;
                if (isHidden || (showExpert = Boolean.TRUE.equals(this.getView().getContext().getPreferenceValue(XmlPreferences.SHOW_EXPERT_ITEMS))) || !resolver.isExpert(key)) break;
                result = true;
                break;
            }
            case 9: {
                result = this.isReadable();
                break;
            }
            case 10: {
                result = this.isWritable();
                break;
            }
            case 11: {
                result = resolver.getShortDescription(key);
                break;
            }
            case 12: {
                result = this.__isDrillable();
                break;
            }
            case 13: {
                if (!this.__isDrillable()) break;
                result = this._createDrilledPropertyModel();
                break;
            }
            case 15: {
                result = resolver.getSupportsDatabinding(key) && resolver.isDatabindingSupported();
                break;
            }
            case 16: {
                GuiXmlContext context = this.getGui().getGuiContext();
                BaseDatabindingEditorGui bdeg = (BaseDatabindingEditorGui)context.getGui(XmlUsage.DATABINDING_PROPERTY_EDITOR);
                if (bdeg == null) {
                    result = false;
                    break;
                }
                if (node != null) {
                    result = bdeg.isDatabound(node, ownerNode);
                    break;
                }
                result = bdeg.isDatabound(key, ownerNode, this.getRowValueAsString(true));
                break;
            }
            case 17: {
                result = node;
                break;
            }
            case 18: {
                result = this.getGui().getHelpTopic(node, key);
                break;
            }
            case 19: {
                result = this.isRequired();
                break;
            }
            case 21: {
                result = this.isCommon(key);
                break;
            }
            case 22: {
                result = resolver.getDisplayOrder(key);
                break;
            }
            case 23: {
                result = resolver.isPreferred(key);
                break;
            }
            case 24: {
                result = resolver.isFavoriteProperty((Element)ownerNode, ownerKey, this.getNode(), key);
                break;
            }
            case 26: {
                result = resolver.isDeprecated(key);
                break;
            }
            case 27: {
                if (node == null) {
                    result = this.getGui().getNodeMessageList(ownerNode, key);
                    break;
                }
                result = this.getGui().getNodeMessageList(node);
                break;
            }
            case 28: {
                if (node == null) {
                    result = this.getGui().getNodeToolTip(ownerNode, key);
                    break;
                }
                result = this.getGui().getNodeToolTip(node);
                break;
            }
            case 30: {
                result = this.getActionGroups();
                break;
            }
            case 31: {
                result = this._createEnumeratedValuesInfo();
                break;
            }
            case 32: {
                result = this.getDefaultValue();
                break;
            }
            case 33: {
                result = this.isCustomizedAtTip();
                break;
            }
            case 38: {
                ContextualAttributeValueItemProvider cavip = resolver.getContextualAttributeValueItemProvider(key);
                if (cavip != null) {
                    result = cavip;
                    break;
                }
                Object pe = this._getPropertyEditor();
                if (pe instanceof AttributeValueItemProvider || pe instanceof AttributeValueItemProvider2) {
                    result = pe;
                }
                if (result != null) break;
                result = resolver.getAttributeValueProvider(key);
                break;
            }
        }
        return result;
    }

    public String toString() {
        String baseString = super.toString() + ", key=" + this._key;
        String value = this.getRowValueAsString(false);
        if (value != null) {
            baseString = baseString + ", value=" + value;
        }
        return baseString;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getGui().__clearNodeMessages(this.getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isWritable() {
        PropertyRowOwner owner = this.getOwner();
        XmlKey key = this.getKey();
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        this.getView().acquireReadLock();
        try {
            Node nearestAncestor = owner.getNearestAncestor();
            boolean bl = resolver.isValueModifable(key, this.getNode(), owner.getParentKey(), owner.getParentNode(), this.getGui().getView().getNodeXmlKey(nearestAncestor), nearestAncestor);
            return bl;
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    protected boolean isReadable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isCustomizedAtTip() {
        boolean isCustomizedAtTip = false;
        Node node = this.getNode();
        if (node != null) {
            this.getView().acquireReadLock();
            try {
                NodeCustomizationDetails ncd = this.getView().getBaseModel().getCustomizationDetails(node);
                if (ncd == null) return isCustomizedAtTip;
                isCustomizedAtTip = ncd.isCustomizedAtTip();
                return isCustomizedAtTip;
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
        Node parentNode = this.getOwner().getParentNode();
        if (parentNode == null) return isCustomizedAtTip;
        this.getView().acquireReadLock();
        try {
            void var6_11;
            NodeCustomizationDetails ncd = this.getView().getBaseModel().getCustomizationDetails(parentNode);
            if (!(ncd instanceof ElementCustomizationDetails)) return isCustomizedAtTip;
            ElementCustomizationDetails ecd = (ElementCustomizationDetails)ncd;
            Object var6_8 = null;
            QualifiedName qn = null;
            if (this.getKey().getNodeType() == 2) {
                qn = this.getKey().getAttributeQName();
                Set<QualifiedName> set = ecd.getRemovedAttributes();
            } else if (this.getKey().getNodeType() == 1) {
                qn = this.getKey().getElementQName();
                List<QualifiedName> list = ecd.getRemovedChildElements();
            }
            if (var6_11 == null) return isCustomizedAtTip;
            isCustomizedAtTip = var6_11.contains(qn);
            return isCustomizedAtTip;
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    @Override
    protected boolean isSet() {
        XmlKey key = this.getKey();
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        return resolver.isSet(this.getNode(), key, this.getOwner().getParentNode());
    }

    protected boolean isCommon(XmlKey key) {
        if (key.getNodeType() == 2) {
            boolean isFavorite = (Boolean)this.getColumnValue(24);
            boolean common = isFavorite || this.isRequired() || this.getView().getXmlMetadataResolver().isPreferred(key);
            return common;
        }
        return false;
    }

    protected boolean isRequired() {
        XmlKey key = this.__getQueryKey();
        PropertyRowOwner owner = this.getOwner();
        Node ownerNode = owner.getParentNode();
        if (ownerNode == null || !this.getView().getBaseModel().isInModelDocumentHierarchy(ownerNode)) {
            return this.getView().getXmlMetadataResolver().isRequired(key, owner.getParentKey());
        }
        return this.getView().getXmlMetadataResolver().isRequired(key, ownerNode);
    }

    private Object _getPropertyEditor() {
        Node node = this.__getQueryNode();
        XmlKey key = this.__getQueryKey();
        short nodeType = key.getNodeType();
        Object pe = null;
        if (nodeType == 2) {
            pe = this.getAttrPropertyEditor(key);
        } else if (nodeType == 1) {
            if (Boolean.TRUE.equals(this.getColumnValue(15))) {
                pe = this.getDatabindingEditor(key, node, this.getOwner().getParentNode());
            }
            if (pe == null) {
                pe = this.getPropertyEditor(key, node);
            }
        } else {
            pe = this.getPropertyEditor(key, node);
        }
        XmlView view = this.getView();
        PropertyRowOwner owner = this.getOwner();
        PropertyEditorContext.setContext(pe, PropertyEditorContext.create(view.getContext(), key, node, owner.getParentNode(), owner.getParentKey(), owner.getNearestAncestor(), owner.getTargetNode()));
        return pe;
    }

    protected Object getAttrPropertyEditor(XmlKey attrKey) {
        Object pe = null;
        if (((Boolean)this.getColumnValue(15)).booleanValue() && ((Boolean)this.getColumnValue(16)).booleanValue()) {
            pe = this.getDatabindingEditor(attrKey, this.getNode(), this.getOwner().getParentNode());
        }
        if (pe == null) {
            pe = this.getPropertyEditor(attrKey, this.getNode());
        }
        return pe;
    }

    protected Object getDatabindingEditor(XmlKey xmlKey, Node node, Node parentNode) {
        PropertyEditor pe = null;
        GuiXmlContext context = this.getGui().getGuiContext();
        BaseDatabindingEditorGui bdeg = (BaseDatabindingEditorGui)context.getGui(XmlUsage.DATABINDING_PROPERTY_EDITOR);
        if (bdeg != null) {
            pe = bdeg.getDatabindingPropertyEditor(context, xmlKey, node, parentNode);
        }
        return pe;
    }

    protected Object getPropertyEditor(XmlKey attrKey, Node node) {
        PropertyEditor pe = this.getGui().getPropertyEditor(node, attrKey, this.getRowValueAsString(true));
        if (pe == null) {
            pe = JavaPropertyEditorManager.findEditor(String.class);
        }
        return pe;
    }

    protected Object createElementFactory(Object pe, int columnIndex) {
        if (37 == columnIndex) {
            return new ElementFactory2(pe);
        }
        return new ElementFactory(pe);
    }

    protected Object createCharacterDataFactory(Object pe, int columnIndex) {
        if (37 == columnIndex) {
            return new CharacterDataFactory2(pe);
        }
        return new CharacterDataFactory(pe);
    }

    @Override
    protected PropertyRow.UpdateResult setRowValueImpl(Object newValue) {
        PropertyRow.UpdateResult result = PropertyRow.UpdateResult.INVALIDATE_MODEL;
        try {
            if (newValue instanceof Node) {
                this._syncNode((Node)newValue);
                return PropertyRow.UpdateResult.INVALIDATE_MODEL;
            }
            String oldStringValue = this._getStringRepresentation(this.getColumnValue(2));
            String newStringValue = this._getStringRepresentation(newValue);
            boolean isSet = Boolean.TRUE.equals(this.getColumnValue(5));
            if (!isSet || !newStringValue.equals(oldStringValue)) {
                boolean required;
                boolean newEmpty;
                XmlKey rowKey = this.getKey();
                XmlView view = this.getView();
                XmlMetadataResolver resolver = view.getXmlMetadataResolver();
                Node modelNode = view.viewToModel(this.getOwner().getParentNode());
                Node rowNode = this.getNode();
                boolean isAttr = rowKey.getNodeType() == 2;
                boolean removed = false;
                boolean bl = newEmpty = !ModelUtil.hasLength((String)newStringValue);
                if (rowNode != null && newEmpty && !(required = this.isRequired())) {
                    if (isAttr) {
                        removed = resolver.setAttributeEmptyString((Attr)rowNode, newValue);
                        result = removed ? PropertyRow.UpdateResult.INVALIDATE_MODEL : PropertyRow.UpdateResult.INVALIDATE_CELL;
                    } else {
                        result = this.setRowValueAsString(null);
                        boolean bl2 = removed = result == PropertyRow.UpdateResult.INVALIDATE_MODEL;
                    }
                }
                if (!removed) {
                    resolver.validateValue(rowKey, modelNode, newValue);
                } else {
                    this.__setNode(null);
                }
                if (rowNode != null) {
                    if (!removed) {
                        if (isAttr) {
                            QualifiedName attrQName = rowKey.getAttributeQName();
                            Element ownerElement = (Element)modelNode;
                            AttributeSetter as = this._getAttributeSetter(rowKey, (Attr)this.getNode());
                            if (as != null) {
                                boolean changed = as.setAttribute(this.getGui().getGuiContext(), rowKey, (Attr)this.getNode(), modelNode, newStringValue);
                                result = XmlKeyPropertyRow._booleanToResult(changed, PropertyRow.UpdateResult.INVALIDATE_MODEL);
                            } else {
                                DomUtils.setAttribute((Element)ownerElement, (String)attrQName.getNamespace(), (String)attrQName.getName(), (String)newStringValue);
                                result = PropertyRow.UpdateResult.INVALIDATE_CELL;
                            }
                            this.__setNode(DomUtils.getAttribute((Element)ownerElement, (QualifiedName)attrQName));
                        } else {
                            result = this.setRowValueAsString(newStringValue);
                        }
                    }
                } else if (isAttr) {
                    QualifiedName attrQName = rowKey.getAttributeQName();
                    Element ownerElement = (Element)modelNode;
                    AttributeSetter as = this._getAttributeSetter(rowKey, (Attr)this.getNode());
                    if (as != null) {
                        boolean changed = as.setAttribute(this.getGui().getGuiContext(), rowKey, (Attr)this.getNode(), modelNode, newStringValue);
                        result = changed ? PropertyRow.UpdateResult.INVALIDATE_MODEL : PropertyRow.UpdateResult.NO_UPDATE;
                    } else {
                        String prefix = null;
                        if (rowKey.getNamespace() != null) {
                            XmlKey grammarKey = ImmutableXmlKey.createNamespaceKey((String)rowKey.getNamespace());
                            prefix = resolver.getPreferredPrefix(grammarKey);
                        }
                        if (prefix != null) {
                            DomUtils.setAttribute((Element)ownerElement, (String)attrQName.getNamespace(), (String)attrQName.getName(), (String)newStringValue, (String)prefix);
                        } else {
                            DomUtils.setAttribute((Element)ownerElement, (String)attrQName.getNamespace(), (String)attrQName.getName(), (String)newStringValue);
                        }
                        result = PropertyRow.UpdateResult.INVALIDATE_CELL;
                    }
                    this.__setNode(DomUtils.getAttribute((Element)ownerElement, (QualifiedName)attrQName));
                } else {
                    result = this.setRowValueAsString(newStringValue);
                }
            }
        }
        catch (Exception e) {
            this.getGui().showError(this.getKey(), newValue, e);
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    protected String getRowValueAsString(boolean useDefault) {
        Node rowNode = this.getNode();
        if (rowNode != null) {
            return rowNode.getNodeValue();
        }
        if (useDefault) {
            return this.getDefaultValue();
        }
        return null;
    }

    protected String getDefaultValue() {
        if (this.isRequired()) {
            return null;
        }
        return this.getGui().getView().getXmlMetadataResolver().getDefaultValue(this.getOwner(), this.__getQueryNode(), this.__getQueryKey());
    }

    protected PropertyRow.UpdateResult setRowValueAsString(String s) {
        boolean changed = false;
        Node node = this.getNode();
        if (node != null) {
            String old = node.getNodeValue();
            boolean bl = changed = old != s && (old == null || !old.equals(s));
            if (s == null) {
                s = "";
            }
            XmlKey key = this.getKey();
            short type = key.getNodeType();
            switch (type) {
                case 4: {
                    if (0 <= s.indexOf("]]>")) {
                        String description = this.getGui().getTranslatedString("CDATA_ERROR_NESTED");
                        throw new IllegalArgumentException(description);
                    }
                }
                case 3: 
                case 8: {
                    if (!"".equals(s)) break;
                    node.getParentNode().removeChild(this.getNode());
                    this.__setNode(null);
                    return PropertyRow.UpdateResult.INVALIDATE_MODEL;
                }
                case 7: {
                    if (0 > s.indexOf("?>") && 0 > s.indexOf("<?")) break;
                    String description = this.getGui().getTranslatedString("PROCESSINGINSTRUCTION_ERROR_NESTED");
                    throw new IllegalArgumentException(description);
                }
            }
            node.setNodeValue(s);
        }
        return XmlKeyPropertyRow._booleanToResult(changed, PropertyRow.UpdateResult.INVALIDATE_CELL);
    }

    protected PropertyRow.UpdateResult setDataboundValue(Object newValue) {
        boolean invalidateData = false;
        int isDataBindableIndex = 15;
        if (Boolean.TRUE.equals(this.getColumnValue(isDataBindableIndex))) {
            boolean setDatabound = Boolean.TRUE.equals(newValue);
            boolean isDatabound = Boolean.TRUE.equals(this.getColumnValue(16));
            if (isDatabound != setDatabound) {
                try {
                    PropertyRowOwner owner = this.getOwner();
                    owner.createMissingAncestors();
                    Node rowNode = this.getNode();
                    GuiXmlContext context = this.getGui().getGuiContext();
                    BaseDatabindingEditorGui bdeg = (BaseDatabindingEditorGui)context.getGui(XmlUsage.DATABINDING_PROPERTY_EDITOR);
                    bdeg.setDatabound(rowNode, this.getKey(), owner.getParentNode(), setDatabound);
                    invalidateData = true;
                }
                catch (Exception e) {
                    this.getGui().showError(this.getKey(), newValue, e);
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return XmlKeyPropertyRow._booleanToResult(invalidateData, PropertyRow.UpdateResult.INVALIDATE_MODEL);
    }

    @Override
    protected boolean inlineEditingDisabled() {
        this.getView().acquireReadLock();
        try {
            boolean bl = this.getView().getXmlMetadataResolver().inlineEditingDisabled(this.__getQueryNode(), this.__getQueryKey());
            return bl;
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    Object __createPropertyId() {
        return this.getGui().__getPropertyId(this._key, this.getOwner());
    }

    XmlKey __getQueryKey() {
        return this.getKey();
    }

    Node __getQueryNode() {
        return this.getNode();
    }

    void __setNode(Node node) {
        this._node = node;
    }

    String getPropertyDisplayName(XmlMetadataResolver resolver, Node n) {
        String displayName = resolver.getPropertyDisplayName(n, this.__getQueryKey(), this.getOwner().getParentNode(), this.getOwner().getParentKey());
        if (this.isRequired()) {
            displayName = displayName + " *";
        }
        return displayName;
    }

    String getPropertyDisplayName(XmlMetadataResolver resolver, XmlKey key, Node ownerNode, XmlKey ownerKey) {
        String displayName = resolver.getPropertyDisplayName(key, ownerNode, ownerKey);
        if (this.isRequired()) {
            displayName = displayName + " *";
        }
        return displayName;
    }

    boolean __isDrillable() {
        return this.getGui().isDrillable(this.getKey(), this.getNode(), this.getOwner().getParentKey(), this.getOwner().getParentNode());
    }

    static PropertyGroup __getPropertyGroup(XmlKey key, XmlMetadataResolver resolver) {
        PropertyGroup propertyGroup;
        String groupName = null;
        if (key.getNodeType() == 2) {
            groupName = resolver.getGroup(key);
        } else if (key.getNodeType() == 1) {
            // empty if block
        }
        String generalGroup = resolver.getModel().getTranslatedString("General");
        if (groupName == null || groupName.equals(generalGroup)) {
            groupName = resolver.getModel().getTranslatedString("OtherGroup");
        }
        if ((propertyGroup = _sPropertyGroups.get(groupName)) == null) {
            propertyGroup = XmlKeyPropertyRow.getFixedPropertyGroup(groupName);
            _sPropertyGroups.put(groupName, propertyGroup);
        }
        return propertyGroup;
    }

    private String _getStringRepresentation(Object newValue) throws GrammarException {
        return this.getGui().getView().getXmlMetadataResolver().getStringRepresentation(this.__getQueryKey(), newValue);
    }

    private PropertyModel _createDrilledPropertyModel() {
        return this.getGui().createDrilledPropertyModel(this.getKey(), this.getNode(), this.getOwner().getParentKey(), this.getOwner().getParentNode());
    }

    private static PropertyRow.UpdateResult _booleanToResult(boolean val, PropertyRow.UpdateResult ifTrue) {
        if (val) {
            return ifTrue;
        }
        return PropertyRow.UpdateResult.NO_UPDATE;
    }

    private Object _convertRowValueToObject(boolean useDefault) {
        Object piValue;
        block6: {
            piValue = this.getRowValueAsString(useDefault);
            Node rowNode = this.getNode();
            XmlKey nodeKey = this.__getQueryKey();
            XmlMetadataResolver resolver = this.getGui().getView().getXmlMetadataResolver();
            Class type = resolver.getJavaType(nodeKey, piValue);
            if (type != String.class) {
                if ("".equals(piValue)) {
                    piValue = null;
                }
                if (piValue != null) {
                    SimpleType modifiedType = resolver.getModifiedSimpleType(rowNode, nodeKey, piValue);
                    try {
                        if (type != null) {
                            piValue = JavaTypeManager.getInstance().convertToJavaType((String)piValue, modifiedType);
                        }
                    }
                    catch (GrammarException ge) {
                        if (!this.getGui().getLogger().isLoggable(Level.FINER)) break block6;
                        this.getGui().getLogger().log(Level.FINER, "couldn't convert attribute " + nodeKey, ge);
                    }
                }
            }
        }
        return piValue;
    }

    private AttributeSetter _getAttributeSetter(XmlKey key, Attr attr) {
        return attr != null ? this.getView().getXmlMetadataResolver().getAttributeSetter(attr) : this.getView().getXmlMetadataResolver().getAttributeSetter(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _syncNode(Node newNode) {
        XmlView view = this.getView();
        XmlMetadataResolver resolver = view.getXmlMetadataResolver();
        view.acquireReadLock();
        try {
            resolver.syncNode(this.getOwner().getParentNode(), newNode, this.getOwner().getParentKey(), this.getKey());
        }
        finally {
            view.releaseReadLock();
        }
    }

    private EnumeratedValuesInfo _createEnumeratedValuesInfo() {
        Object value = this.getColumnValue(2);
        XmlKey key = this.__getQueryKey();
        Node node = this.__getQueryNode();
        PropertyRowOwner owner = this.getOwner();
        Set<AttributeValueItem> items = this.getGui().getAttributeValues(key, node, value, owner);
        boolean editable = this.getGui().isAttributeValueEditable(node, key, owner, value);
        return new EnumeratedValuesInfo(items, !editable);
    }

    private boolean _isHidden() {
        Node node = this.__getQueryNode();
        XmlKey key = this.__getQueryKey();
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        if (node == null) {
            return resolver.isHidden(key);
        }
        return resolver.isHidden(node);
    }

    private static class CharacterDataFactory2
    extends JavaBeansPropertyEditorAdapter {
        CharacterDataFactory2(Object pe) {
            super((PropertyEditor)pe);
        }
    }

    private static class CharacterDataFactory
    extends PropertyEditorAdapter {
        CharacterDataFactory(Object pe) {
            super((PropertyEditor)pe);
        }
    }

    private static class ElementFactory2
    extends JavaBeansPropertyEditorAdapter {
        ElementFactory2(Object pe) {
            super((PropertyEditor)pe);
        }
    }

    private static class ElementFactory
    extends PropertyEditorAdapter {
        ElementFactory(Object pe) {
            super((PropertyEditor)pe);
        }
    }
}

