/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.base.inspector.AnnotationPropertyRow;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.BasePropertyRowCreator;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.model.annotation.AnnotationGrammar;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.annotation.AnnotationProperty;
import oracle.bali.xml.model.annotation.AnnotationPropertyDef;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import org.w3c.dom.Node;

class AnnotationPropertyRowCreator
extends BasePropertyRowCreator<QualifiedName, AnnotationPropertyDef, AnnotationProperty> {
    AnnotationPropertyRowCreator() {
    }

    @Override
    protected QualifiedName getKeyForRowInfo(AnnotationPropertyDef info) {
        return info.getName();
    }

    @Override
    protected List<AnnotationPropertyDef> getGrammarBasedRowInfos(BaseInspectorGui gui, PropertyRowOwner owner) {
        Collection<AnnotationPropertyDef> propertyDefs = this._getGrammar(gui).getAnnotationPropertyDefs(owner.getParentNode());
        return new ArrayList<AnnotationPropertyDef>(propertyDefs);
    }

    @Override
    protected Map<QualifiedName, AnnotationProperty> getModelObjects(BaseInspectorGui gui, PropertyRowOwner owner) {
        AnnotationProvider annotationProvider = this._getModel(gui).getAnnotationProvider(owner.getParentNode());
        Collection<AnnotationProperty> properties = annotationProvider.getAnnotationProperties();
        HashMap<QualifiedName, AnnotationProperty> map = new HashMap<QualifiedName, AnnotationProperty>(properties.size());
        for (AnnotationProperty ap : properties) {
            map.put(ap.getName(), ap);
        }
        return map;
    }

    @Override
    protected PropertyRow createRow(BaseInspectorGui gui, PropertyRowOwner owner, QualifiedName key, AnnotationPropertyDef grammarInfo, AnnotationProperty modelObj) {
        return new AnnotationPropertyRow(gui, key, owner, grammarInfo, modelObj, this._getAnnotationProvider(gui, owner));
    }

    @Override
    protected boolean supportsAnyProperties(BaseInspectorGui gui, PropertyRowOwner owner) {
        return this._getAnnotationProvider(gui, owner) != null;
    }

    @Override
    public boolean isAppended() {
        return true;
    }

    private AnnotationGrammar _getGrammar(BaseInspectorGui gui) {
        return gui.getView().getContext().getAnnotationGrammar();
    }

    private AnnotationModel _getModel(BaseInspectorGui gui) {
        return gui.getView().getContext().getAnnotationModel();
    }

    private AnnotationProvider _getAnnotationProvider(BaseInspectorGui gui, PropertyRowOwner owner) {
        Node ownerNode = owner.getParentNode();
        if (ownerNode == null) {
            return null;
        }
        return this._getModel(gui).getAnnotationProvider(ownerNode);
    }
}

