/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.ContextualActionProvider;
import org.w3c.dom.Node;

public class BaseContextualActionsGui
extends XmlGui {
    private transient Node _leadNode;
    private transient List<Action> _actions = null;
    private transient List<Action> _lastActions = Collections.emptyList();

    public BaseContextualActionsGui(XmlView view) {
        super(view);
    }

    public List<Action> getContextualActions() {
        if (this._actions == null) {
            this._updateActions(false);
        }
        if (this._actions == null) {
            this._actions = Collections.emptyList();
        }
        return this._actions;
    }

    @Override
    protected void postCreationHook() {
        super.postCreationHook();
        this.getGuiContext().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("activeGui")) {
                    BaseContextualActionsGui.this._updateActions(true);
                }
            }
        });
    }

    @Override
    protected void handleModelInvalidateEvent(XmlModelEvent e) {
        if (this._eventRequiresUpdate(e)) {
            this._lastActions = this._actions == null ? Collections.EMPTY_LIST : this._actions;
            this._actions = null;
        }
    }

    @Override
    protected void handleModelChangeEvent(XmlModelEvent event) {
        super.handleModelChangeEvent(event);
        if (this._eventRequiresUpdate(event)) {
            this._updateActions(event.isDomTreeChanged());
        }
    }

    private boolean _eventRequiresUpdate(XmlModelEvent event) {
        return event.isSelectionChanged() || event.isDomTreeChanged();
    }

    protected void actionsChanged(List<Action> oldActions, List<Action> newActions) {
    }

    protected List<Action> getGuiActions(Node domNode) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _updateActions(boolean force) {
        this.getView().acquireReadLock();
        try {
            Selection viewSelection = this.getView().getSelection();
            Node newLeadNode = viewSelection.getFirstSelectedNode();
            if (newLeadNode != null && !viewSelection.containsOnly(newLeadNode)) {
                newLeadNode = null;
            }
            if (force || newLeadNode != this._leadNode) {
                this._leadNode = newLeadNode;
                List<Action> oldActions = this._lastActions;
                this._actions = this._getActions(newLeadNode);
                if (!oldActions.isEmpty() || this._actions != null && !this._actions.isEmpty()) {
                    this.actionsChanged(oldActions, this._actions);
                }
            }
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    private List<Action> _getActions(Node domNode) {
        if (domNode != null) {
            XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
            XmlKey key = resolver.getNodeXmlKey(domNode);
            ArrayList<Action> combinedList = new ArrayList<Action>();
            this._addActions(combinedList, resolver.getContextualActionProvider(domNode), key, domNode);
            combinedList.addAll(this.getGuiActions(domNode));
            for (ContextualActionProvider provider : this.getGuiContext().getGlobalContextualActionProviders()) {
                this._addActions(combinedList, provider, key, domNode);
            }
            return combinedList;
        }
        return Collections.emptyList();
    }

    private void _addActions(List<Action> out, ContextualActionProvider provider, XmlKey key, Node node) {
        List<Action> actions;
        if (provider != null && (actions = provider.getContextualActions(this.getGuiContext(), key, node)) != null) {
            out.addAll(actions);
        }
    }
}

