/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceResult;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;

public final class ReplaceWhitespaceMode
extends WhitespaceMode {
    protected ReplaceWhitespaceMode() {
        super("replace");
    }

    @Override
    public Boolean allowsAddingExtraWhitespace(DomPosition pos) {
        return Boolean.FALSE;
    }

    @Override
    protected WhitespaceResult applyImpl(String input) {
        WhitespaceResult result = new WhitespaceResult();
        boolean didReplace = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != ' ' && WhitespaceUtils.isXmlWhitespaceChar(c)) {
                result.appendToValue(' ');
                didReplace = true;
                continue;
            }
            result.appendToValue(c);
        }
        if (!didReplace) {
            return null;
        }
        return result;
    }
}

