/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.BufferDomRelatedChange;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;

class CharsLocatorChange
extends BufferDomRelatedChange {
    private final int _offset;
    private final int _length;
    private static final Logger _LOGGER = Logger.getLogger(CharsLocatorChange.class.getName());

    public CharsLocatorChange(int offset, int length) {
        this._offset = offset;
        this._length = length;
    }

    @Override
    protected void preUndoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._length < 0) {
            plugin.getLocatorManager().charactersAdded(this._offset, -this._length);
        } else {
            plugin.getLocatorManager().charactersRemoved(this._offset, this._length);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    @Override
    protected void postRedoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._length > 0) {
            plugin.getLocatorManager().charactersAdded(this._offset, this._length);
        } else {
            plugin.getLocatorManager().charactersRemoved(this._offset, -this._length);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }
}

