/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ReformatPCWrapper;
import oracle.bali.xml.dom.buffer.SyncToTextDomChangeHandler;
import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.textsync.BufferChange;
import oracle.bali.xml.dom.buffer.textsync.Reformatter;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.share.ReverseListIterator;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.events.MutationEvent;

public class BufferDomTextSync {
    private final List _bufferChanges = new ArrayList();
    private final Reformatter _reformatter = new Reformatter();
    private final BufferDomModel _model;
    private static final Logger _LOGGER = Logger.getLogger(BufferDomTextSync.class.getName());
    private static int _MAX_AUTO_REFORMAT_LENGTH = 160000;

    public BufferDomTextSync(BufferDomModel model) {
        this._model = model;
    }

    public void handleChange(DomChange domChange, MutationEvent mEvent) {
        this._model.getContext().getWhitespaceHandler().beginCacheablePeriod();
        TextSyncContext context = new TextSyncContext(this._model, mEvent, domChange);
        SyncToTextDomChangeHandler handler = new SyncToTextDomChangeHandler(context);
        try {
            domChange.process(handler);
            this._reformatter.trackChange(domChange, context);
        }
        catch (RuntimeException re) {
            LogUtils.log((Logger)_LOGGER, (Level)Level.SEVERE, (String)"Exception in text sync! model={0} change={1} event={2}", (Object[])new Object[]{this._model, domChange, mEvent}, (Throwable)re);
            throw re;
        }
        finally {
            this._bufferChanges.add(context.getBufferChange());
            this._model.getContext().getWhitespaceHandler().endCacheablePeriod();
        }
    }

    public void preRollbackChange(DomChange change) {
        int lastIdx = this._bufferChanges.size() - 1;
        BufferChange bufChange = (BufferChange)this._bufferChanges.get(lastIdx);
        DomChange domChange = bufChange.getCorrespondingDomChange();
        if (change != domChange) {
            throw new IllegalStateException("Asked to rollback DOM change " + change + " but last buffer change does not " + "correspond! Buffer change=" + bufChange);
        }
        this._reformatter.untrackChange(domChange);
    }

    public void postRollbackChange(DomChange change) {
        int lastIdx = this._bufferChanges.size() - 1;
        BufferChange bufChange = (BufferChange)this._bufferChanges.get(lastIdx);
        if (change != bufChange.getCorrespondingDomChange()) {
            throw new IllegalStateException("Asked to rollback DOM change " + change + " but last buffer change does not " + "correspond! Buffer change=" + bufChange);
        }
        this._bufferChanges.remove(lastIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit applyChanges() {
        UndoableEdit edit;
        this._model.getContext().getWhitespaceHandler().beginCacheablePeriod();
        this._buffer().beginEdit();
        try {
            BufferChange change = null;
            long combinedInsertionLength = 0L;
            this._debugBuffer("before starting to apply changes");
            for (int i = 0; i < this._bufferChanges.size(); ++i) {
                change = (BufferChange)this._bufferChanges.get(i);
                change.apply(this._buffer());
                combinedInsertionLength += (long)change.getInsertionLength();
                this._debugBuffer("after change #" + i);
            }
            if (change != null) {
                ParserConfiguration pConfig = this._model.getParserConfiguration();
                if (combinedInsertionLength < (long)_MAX_AUTO_REFORMAT_LENGTH || pConfig instanceof ReformatPCWrapper) {
                    ReformatTextSyncContext context = new ReformatTextSyncContext(this._model, change.getCorrespondingDomChange());
                    this._reformatter.doReformatting(context, this._buffer());
                } else {
                    _LOGGER.log(Level.FINE, "BufferDomTextSync: Skipping automatic reformat of inserted text");
                }
            }
        }
        finally {
            edit = this._buffer().endEdit();
            this._bufferChanges.clear();
            this._reformatter.reset();
            this._model.getContext().getWhitespaceHandler().endCacheablePeriod();
        }
        return edit;
    }

    private void _debugBuffer(String label) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "--- buffer {0} below ---\n{1}\n--- buffer {0} above ---", new Object[]{label, this._buffer().getString(0, this._buffer().getLength())});
        }
    }

    private TextBuffer _buffer() {
        return this._model.getTextBuffer();
    }

    static {
        try {
            int maxAutoReformatLength;
            String sysProp = System.getProperty("oracle.bali.xml.dom.buffer.maxAutoReformatLength");
            if (sysProp != null && (maxAutoReformatLength = Integer.parseInt(sysProp)) > 100) {
                _MAX_AUTO_REFORMAT_LENGTH = maxAutoReformatLength;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class ReformatRelatedChange
    extends RelatedChange {
        private final List _realChanges = new ArrayList(2);

        private ReformatRelatedChange() {
        }

        public void add(RelatedChange related) {
            this._realChanges.add(related);
        }

        @Override
        public void postRedo(DomModel model, DomChange domChange) {
            for (RelatedChange rel : this._realChanges) {
                rel.preRedo(model, domChange);
                rel.postRedo(model, domChange);
            }
        }

        @Override
        public void preUndo(DomModel model, DomChange domChange) {
            ReverseListIterator itor = new ReverseListIterator(this._realChanges);
            while (itor.hasNext()) {
                RelatedChange rel = (RelatedChange)itor.next();
                rel.preUndo(model, domChange);
                rel.postUndo(model, domChange);
            }
        }
    }

    private static class ReformatTextSyncContext
    extends TextSyncContext {
        private final ReformatRelatedChange _relatedHandler = new ReformatRelatedChange();

        public ReformatTextSyncContext(BufferDomModel model, DomChange change) {
            super(model, null, change);
            change.addRelatedChange(this._relatedHandler);
        }

        @Override
        public void addRelatedChange(RelatedChange related) {
            this._relatedHandler.add(related);
        }
    }
}

