/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomParseProblem;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.buffer.BufferDomDocumentParser;
import oracle.bali.xml.dom.buffer.BufferDomFragmentParser;
import oracle.bali.xml.dom.buffer.BufferDomParseCancelledException;
import oracle.bali.xml.dom.buffer.BufferDomTextSync;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.LocatorAwareDomModelPlugin;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ReformatPCWrapper;
import oracle.bali.xml.dom.buffer.TextSyncConfiguration;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.impl.DomModelPluginContext;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.services.VersionControlService;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.TextBufferSource;
import oracle.bali.xml.share.UndoableEditWrapper;
import oracle.bali.xml.share.WeakListenerProxy;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.NamedTimer;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public final class BufferDomModel
extends LocatorAwareDomModelPlugin {
    private final Reference _bufferDomPluginRef = new WeakReference<BufferDomModel>(this);
    private static final int _DEFAULT_INDENTATION_SIZE = 2;
    private static final int _TIMER_DELAY = 750;
    private static final String BEGIN_COMMENT = "<!--";
    private static final String END_COMMENT = "-->";
    private static final int BEGIN_COMMENT_SIZE = "<!--".length();
    private static final int END_COMMENT_SIZE = "-->".length();
    private static Timer _updateTimer = new NamedTimer("BufferDomModel background parse thread", 1, true);
    private static final Object updateTimerLock = new Object();
    private volatile UpdateTimerTask _currentTask = null;
    private volatile boolean _forceParse = true;
    private volatile boolean _textSyncInProgress = false;
    private volatile int _synchedChangeCount;
    private volatile boolean _immediateParseInProgress = false;
    private volatile boolean _documentChangeInProgress = false;
    private volatile boolean _reparseAfterDocumentChange = false;
    private final TextBufferSource _textBufferSource;
    private TextBuffer _textBuffer;
    private int _indentationSize = 2;
    private LocatorManager _manager;
    private HashMap _locatorMap;
    private List _wfErrors;
    private XmlDeclarationInfo _xmlDeclarationInfo = null;
    private boolean _isNonDomMutatingTransaction = false;
    private final ReadWriteLock _optionalTextBufferLock;
    private boolean _recomputeIndentSize = true;
    private boolean _inSetUnspecifiedAttribute = false;
    private ParserConfiguration _reformatPC = null;
    private TextBufferListener _weakTextBufferListenerWrapper;
    private final ParserConfiguration _parserConfiguration;
    private final DocumentScannerFactory _docScannerFactory;
    private final BufferDomDocumentParser _parser;
    private final BufferDomTextSync _textSync = new BufferDomTextSync(this);
    private final Comparator _nodeComparatorByLocator = new NodeComparatorByLocator();
    private final TextBufferListener _textBufferListener = new TextBufferChangeListener();

    public BufferDomModel(DomModelPluginContext context, TextBufferSource textBufferSource, DOMImplementation domImpl, ParserConfiguration parserConfiguration, DocumentScannerFactory docScannerFactory) {
        super(context);
        this._textBufferSource = textBufferSource;
        this._textBuffer = this._textBufferSource.getTextBuffer();
        this._optionalTextBufferLock = this._textBufferSource.getUnderlyingReadWriteLock();
        this._parser = new BufferDomDocumentParser(domImpl, parserConfiguration, docScannerFactory, context.getWhitespaceHandler());
        this._locatorMap = new HashMap();
        this._manager = new LocatorManager(this._textBuffer.getLineMap());
        this._attachTextBufferListener();
        this._parserConfiguration = parserConfiguration;
        this._docScannerFactory = docScannerFactory;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this._parser.getDOMImplementation();
    }

    @Override
    protected void ensureDocumentAvailable() {
        if (this._forceParse) {
            this._ensureSynchronizedImmediate();
        }
    }

    @Override
    protected int getDocumentLength() {
        return this._textBuffer.getLength();
    }

    @Override
    public boolean isReadOnly() {
        boolean isReadOnly;
        this.getContext().verifyLock();
        try {
            VersionControlService vcs;
            isReadOnly = this._textBuffer.isReadOnly();
            if (isReadOnly && (!this.getContext().isInTransaction() || this._isNonDomMutatingTransaction) && (vcs = (VersionControlService)this.getContext().getDomModelContext().getService("oracle.bali.xml.model.services.VersionControlService")) != null) {
                isReadOnly = !vcs.supportsCheckOut(this._textBufferSource);
            }
        }
        catch (ExpiredTextBufferException e) {
            isReadOnly = true;
            this.getContext().getLogger().log(Level.INFO, "ExpiredTextBufferException encountered by DomModel.isReadOnly(), tolerating and returning true");
        }
        return isReadOnly;
    }

    public int getIndentSize() {
        this.getContext().verifyLock();
        int override = this.getParserConfiguration().getTextSyncOptions().getIndentOverride();
        if (override != -1) {
            return override;
        }
        return this._indentationSize;
    }

    public final Reference getBufferDomPluginReference() {
        return this._bufferDomPluginRef;
    }

    public DeclarationLocator getXMLDeclarationLocator() {
        this.getContext().verifyLock();
        return (DeclarationLocator)this._locatorMap.get(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY);
    }

    @Override
    public boolean isUnspecifiedAttribute(Attr attr) {
        TextSyncConfiguration config;
        this.getContext().verifyLock();
        AttributeLocator loc = (AttributeLocator)this._getLocatorDirectly(attr);
        if (loc == null && !(config = this._parserConfiguration.getTextSyncConfiguration()).allowsAttributes(attr.getOwnerElement())) {
            return true;
        }
        return !loc.isSpecified();
    }

    @Override
    protected boolean canAddAttribute(Element parent, String attributeNamespace, String attributeLocalName) {
        ElementLocator loc = (ElementLocator)this._getLocatorDirectly(parent);
        TextSyncConfiguration config = this._parserConfiguration.getTextSyncConfiguration();
        return (loc == null || !this._isFakeElementLocator(loc)) && config.allowsAttributes(parent);
    }

    private boolean _isFakeElementLocator(ElementLocator loc) {
        return loc != null && loc.getStartTagLocator().getLength() == 0;
    }

    @Override
    protected void acquireReadLockDirectly() {
        this._textBuffer.readLock();
    }

    @Override
    protected void releaseReadLockDirectly() {
        this._textBuffer.readUnlock();
    }

    @Override
    protected void acquireWriteLockDirectly() {
        this._textBuffer.writeLock(false);
    }

    @Override
    protected void releaseWriteLockDirectly() {
        this._textBuffer.writeUnlock();
    }

    @Override
    public int getLockStatus() {
        return this._textBuffer.getLockStatus();
    }

    @Override
    public List getCurrentDomParseProblems() {
        if (this._wfErrors == null) {
            this._doWfCheck();
        }
        return Collections.unmodifiableList(this._wfErrors);
    }

    @Override
    public DomModel.FragmentParseResult parseFragment(Document document, Node contextNode, Map predefinedPrefixes, String text) {
        BufferDomFragmentParser parser;
        DocumentFragment fragment;
        if (document != null && (fragment = (parser = new BufferDomFragmentParser(this.getDOMImplementation(), this.getParserConfiguration(), this.getDocumentScannerFactory(), this.getContext().getWhitespaceHandler())).parseFragment(document, contextNode, predefinedPrefixes, text)) != null) {
            return new DomModel.FragmentParseResult(fragment);
        }
        return null;
    }

    @Override
    protected XmlDeclarationInfo getXmlDeclarationInfo() {
        this.getContext().verifyLock();
        return this._xmlDeclarationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UndoableEdit setXmlDeclarationInfo(XmlDeclarationInfo info) {
        StringBuffer insertionBuffer = null;
        DeclarationLocator oldDeclLocator = this.getXMLDeclarationLocator();
        if (info == null) {
            if (oldDeclLocator == null) {
                return null;
            }
        } else {
            if (oldDeclLocator != null && ((Locator)oldDeclLocator).getStartOffset() == 0 && info.equals(this._xmlDeclarationInfo)) {
                return null;
            }
            insertionBuffer = info.getAsXml();
            insertionBuffer.append('\n');
        }
        UndoableEdit edit = null;
        this._textSyncInProgress = true;
        this._textBuffer.beginEdit();
        try {
            if (oldDeclLocator != null) {
                Node firstChild;
                int start = ((Locator)oldDeclLocator).getStartOffset();
                int end = ((Locator)oldDeclLocator).getEndOffset();
                Document doc = this.getContext().getDocument();
                Node node = firstChild = doc == null ? null : doc.getFirstChild();
                if (firstChild != null) {
                    Locator fcLoc = this._getLocatorDirectly(firstChild);
                    end = Math.max(end, fcLoc.getStartOffset());
                }
                this._textBuffer.remove(start, end - start);
            }
            if (insertionBuffer != null) {
                this._textBuffer.insert(0, insertionBuffer.toString().toCharArray());
            }
        }
        finally {
            edit = this._textBuffer.endEdit();
            this._textSyncInProgress = false;
        }
        if (edit != null) {
            this._ensureSynchronizedImmediate();
            return new ForceReparseUndoableEditWrapper(this, edit);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reformatSubtree(String undoLabel, Node node, Object options) {
        this.getContext().startTransaction(undoLabel);
        this.acquireWriteLockDirectly();
        try {
            boolean indentOverride = false;
            if (DomUtils.isDocument((Node)node) || node.getParentNode() == node.getOwnerDocument()) {
                indentOverride = true;
            }
            this._reformatPC = new ReformatPCWrapper(this._parserConfiguration, this, node, indentOverride, options);
            if (DomUtils.isDocument((Node)node)) {
                NodeList children;
                Element root = ((Document)node).getDocumentElement();
                ElementLocator rootLocator = (ElementLocator)this._getLocatorDirectly(root);
                if (rootLocator.getNameLocator().getLength() == 0) {
                    node = root;
                }
                if ((children = node.getChildNodes()).getLength() > 0) {
                    Node child;
                    int i;
                    Node[] removedChildren = new Node[children.getLength()];
                    Map<Attr, Element> attrMap = Collections.emptyMap();
                    for (i = 0; i < children.getLength(); ++i) {
                        child = children.item(i);
                        if (child.getNodeType() == 10) continue;
                        removedChildren[i] = child;
                        attrMap = this._removeUnspecifiedAttributes(child);
                    }
                    for (i = 0; i < removedChildren.length; ++i) {
                        child = removedChildren[i];
                        if (child == null) continue;
                        node.removeChild(child);
                    }
                    for (i = 0; i < removedChildren.length; ++i) {
                        child = removedChildren[i];
                        if (child == null) continue;
                        DomUtils.insertChildAtIndex((Node)child, (Node)node, (int)i);
                    }
                    this._reAddUnspecifiedAttributes(attrMap);
                }
            } else {
                Node parent = node.getParentNode();
                Node nextSibling = node.getNextSibling();
                Map<Attr, Element> attrMap = Collections.emptyMap();
                if (node.getNodeType() != 10) {
                    attrMap = this._removeUnspecifiedAttributes(node);
                }
                parent.removeChild(node);
                parent.insertBefore(node, nextSibling);
                this._reAddUnspecifiedAttributes(attrMap);
            }
            this.getContext().commitTransaction();
        }
        finally {
            this._recomputeIndentSize = true;
            this._reformatPC = null;
            this.releaseWriteLockDirectly();
        }
    }

    @Override
    protected void refreshModel(boolean force) {
        if (this.getContext().getLogger().isLoggable(Level.FINER)) {
            this.getContext().getLogger().log(Level.FINER, "refreshModel syncedCount={0} thread={1}", new Object[]{IntegerUtils.getInteger((int)this._synchedChangeCount), Thread.currentThread()});
        }
        if (force) {
            if (this._documentChangeInProgress) {
                this._reparseAfterDocumentChange = true;
                return;
            }
            this._forceParse = true;
        }
        this._ensureSynchronizedImmediate();
    }

    @Override
    public boolean needsReparse() {
        return this._isOutOfSync();
    }

    @Override
    protected HashMap getLocatorMap() {
        return this._locatorMap;
    }

    protected LocatorManager getLocatorManager() {
        return this._manager;
    }

    protected void mapNodeToLocator(Node node, Locator locator) {
        if (node != null) {
            if (locator == null) {
                this._locatorMap.remove(node);
            } else {
                this._locatorMap.put(node, locator);
            }
        }
    }

    protected void nodeSubtreeInserted(Node newNode) {
        Locator locator = this._getLocatorDirectly(newNode);
        if (locator == null) {
            throw new IllegalArgumentException("Nodes must be mapped to Locators prior to calling this method.");
        }
        this._attachNodeLocators(newNode, false);
        this._manager.charactersAdded(locator.getStartOffset(), locator.getLength());
        this._attachNodeLocators(newNode, true);
    }

    protected void nodeSubtreeRemoved(Node oldNode) {
        Locator locator = this._getLocatorDirectly(oldNode);
        if (locator == null) {
            throw new IllegalArgumentException("Nodes must be mapped to Locators prior to calling this method.");
        }
        this._attachNodeLocators(oldNode, false);
        this._manager.charactersRemoved(locator.getStartOffset(), locator.getLength());
    }

    protected SortedSet getSortedAttributesSet(Node node) {
        TreeSet<Node> set = new TreeSet<Node>(this.getNodeByLocatorComparator());
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                set.add(attrs.item(i));
            }
        }
        return set;
    }

    protected Comparator getNodeByLocatorComparator() {
        return this._nodeComparatorByLocator;
    }

    @Override
    protected void preStartTopLevelTransactionHook(TransactionOptions transOptions) {
        if (!transOptions.isNonDomMutatingTransaction()) {
            this._isNonDomMutatingTransaction = false;
            this._checkoutTextBufferSourceIfNeeded(true);
        } else {
            this._isNonDomMutatingTransaction = true;
        }
    }

    @Override
    protected void handleUncommittedMutationEventHook(DomChange domChange, MutationEvent mEvent, boolean modifiesUndoStack) {
        super.handleUncommittedMutationEventHook(domChange, mEvent, modifiesUndoStack);
        if (this._recomputeIndentSize) {
            this._recomputeIndentSize = false;
            Node target = (Node)((Object)mEvent.getTarget());
            this._updateIndentationSize(DomUtils.getOwnerDocument((Node)target));
        }
        if (modifiesUndoStack) {
            this._textSync.handleChange(domChange, mEvent);
        }
    }

    @Override
    protected void handleChangeRollbackPreHook(DomChange change) {
        super.handleChangeRollbackPreHook(change);
        this._textSync.preRollbackChange(change);
    }

    @Override
    protected void handleChangeRollbackPostHook(DomChange change) {
        super.handleChangeRollbackPostHook(change);
        this._textSync.postRollbackChange(change);
    }

    @Override
    protected void handleCommittedDomChanges(DomChangesUndoableEdit domChanges) {
        this._textSyncInProgress = true;
        UndoableEdit textEdit = this._textSync.applyChanges();
        if (textEdit != null) {
            domChanges.addSubEdit(textEdit);
        }
        this._synchedChangeCount = this._textBuffer.getChangeId();
        this._textSyncInProgress = false;
    }

    @Override
    protected void handleUndoOccuredPreHook(DomChangesUndoableEdit edit) {
        this._checkoutTextBufferSourceIfNeeded(false);
        this._textSyncInProgress = true;
    }

    @Override
    protected void handleUndoOccuredPostHook(DomChangesUndoableEdit edit) {
        this._synchedChangeCount = this._textBuffer.getChangeId();
        this._textSyncInProgress = false;
    }

    @Override
    protected void handleRedoOccuredPreHook(DomChangesUndoableEdit edit) {
        this._checkoutTextBufferSourceIfNeeded(false);
        this._textSyncInProgress = true;
    }

    @Override
    protected void handleRedoOccuredPostHook(DomChangesUndoableEdit edit) {
        this._synchedChangeCount = this._textBuffer.getChangeId();
        this._textSyncInProgress = false;
    }

    protected TextBuffer getTextBuffer() {
        return this._textBuffer;
    }

    @Override
    protected Map getExtraPropertyChanges(Node changeTarget, int changeFlags, boolean isNestedTransaction, boolean isUndoRedoTransaction) {
        Logger log = this.getContext().getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "WFCheck getExtraProps: nested={0} target={1} flags={2}", new Object[]{isNestedTransaction, changeTarget, new Integer(changeFlags)});
        }
        if (!isNestedTransaction && (changeFlags & 0x1F) > 0) {
            List oldErrs = this._wfErrors;
            if (!isUndoRedoTransaction && oldErrs != null && oldErrs.isEmpty() && changeTarget != null && changeTarget.getNodeType() != 9) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "WFCheck skipped: target={0} oldErrs={1} flags={2}", new Object[]{changeTarget, oldErrs, new Integer(changeFlags)});
                }
            } else {
                if (oldErrs != null && !oldErrs.isEmpty()) {
                    for (DomParseProblem problem : oldErrs) {
                        problem.dispose();
                    }
                }
                this._doWfCheck();
                Collections.sort(this._wfErrors);
                PropertyChange change = new PropertyChange("parseProblems", oldErrs, this._wfErrors);
                return Collections.singletonMap(change.getPropertyName(), change);
            }
        }
        return null;
    }

    protected final DocumentScannerFactory getDocumentScannerFactory() {
        return this._docScannerFactory;
    }

    protected final ParserConfiguration getParserConfiguration() {
        ParserConfiguration reformatPC = this._reformatPC;
        if (reformatPC != null) {
            return reformatPC;
        }
        return this._parserConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UndoableEdit removeDocType() {
        Locator doctypeLocator = this.getDocumentTypeLocator();
        if (doctypeLocator != null) {
            Locator firstLoc;
            Node firstNode;
            int start = doctypeLocator.getStartOffset();
            int end = doctypeLocator.getEndOffset();
            DocumentType doctype = this._getDocType();
            if (doctype != null && (firstNode = doctype.getNextSibling()) != null && (firstLoc = this._getLocatorDirectly(firstNode)) != null) {
                end = firstLoc.getStartOffset();
            }
            this._textBuffer.beginEdit();
            this._textSyncInProgress = true;
            UndoableEdit edit = null;
            try {
                this._textBuffer.remove(start, end - start);
            }
            finally {
                edit = this._textBuffer.endEdit();
                this._textSyncInProgress = false;
            }
            if (edit != null) {
                this._ensureSynchronizedImmediate();
                return new ForceReparseUndoableEditWrapper(this, edit);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UndoableEdit setDocType(String qualifiedName, String publicId, String systemId) {
        int quoteChar = 34;
        StringBuffer buf = new StringBuffer(300);
        buf.append("<!DOCTYPE ");
        buf.append(qualifiedName);
        if (systemId != null) {
            buf.append(" ");
            if (publicId != null) {
                buf.append("PUBLIC ");
                buf.append('\"');
                buf.append(publicId);
                buf.append('\"');
            } else {
                buf.append("SYSTEM");
            }
            buf.append(" ");
            buf.append('\"');
            buf.append(systemId);
            buf.append('\"');
        } else if (publicId != null) {
            this.getContext().getLogger().log(Level.WARNING, "Tried to set public ID to ''{0}'' with no system id!", publicId);
        }
        buf.append(">");
        UndoableEdit textEdit = null;
        this._textSyncInProgress = true;
        this._textBuffer.beginEdit();
        try {
            int insertOffset;
            Locator oldDoctypeLocator = this.getDocumentTypeLocator();
            if (oldDoctypeLocator != null) {
                insertOffset = oldDoctypeLocator.getStartOffset();
                this._textBuffer.remove(insertOffset, oldDoctypeLocator.getLength());
            } else {
                DeclarationLocator xmlDeclLocator = this.getXMLDeclarationLocator();
                if (xmlDeclLocator != null) {
                    buf.insert(0, '\n');
                    insertOffset = ((Locator)xmlDeclLocator).getEndOffset();
                } else {
                    insertOffset = 0;
                    buf.append('\n');
                }
            }
            this._textBuffer.insert(insertOffset, buf.toString().toCharArray());
        }
        finally {
            this._textSyncInProgress = false;
            textEdit = this._textBuffer.endEdit();
        }
        this._ensureSynchronizedImmediate();
        if (textEdit == null) {
            return null;
        }
        return new ForceReparseUndoableEditWrapper(this, textEdit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Attr setUnspecifiedAttribute(Element owner, String namespaceURI, String qname, String value) {
        this._inSetUnspecifiedAttribute = true;
        try {
            Attr attr = super.setUnspecifiedAttribute(owner, namespaceURI, qname, value);
            return attr;
        }
        finally {
            this._inSetUnspecifiedAttribute = false;
        }
    }

    @Override
    protected void dispose() {
        this.getBufferDomPluginReference().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UndoableEdit commentOut(DomRange range, boolean escapeDashDash) {
        XmlModel model = ((XmlContext)this.getContext().getDomModelContext()).getModel();
        TreeTraversal traversal = ((AbstractModel)model).getTreeTraversal();
        List<Node> nodes = this._ensureSiblingNodes(this._getNodesFromRange(range, traversal));
        List<int[]> sections = this._computeCommentSections(nodes, traversal, range);
        UndoableEdit textEdit = null;
        if (this._textBuffer.isReadOnly()) {
            this._checkoutTextBufferSourceIfNeeded(true);
        }
        try {
            this._textSyncInProgress = true;
            this._textBuffer.beginEdit();
        }
        catch (ReadOnlyException ex) {
            this._textSyncInProgress = false;
            throw ex;
        }
        try {
            for (int i = sections.size() - 1; i >= 0; --i) {
                String escapedText;
                String text;
                int[] section = sections.get(i);
                int start = section[0];
                int end = section[1];
                this._textBuffer.insert(end, END_COMMENT.toCharArray());
                if (escapeDashDash && (text = this._textBuffer.getString(start, end - start)) != (escapedText = this._escapeDashDash(text))) {
                    this._textBuffer.remove(start, end - start);
                    this._textBuffer.insert(start, escapedText.toCharArray());
                }
                this._textBuffer.insert(start, BEGIN_COMMENT.toCharArray());
            }
        }
        finally {
            this._textSyncInProgress = false;
            textEdit = this._textBuffer.endEdit();
        }
        this._ensureSynchronizedImmediate();
        if (textEdit == null) {
            return null;
        }
        return new ForceReparseUndoableEditWrapper(this, textEdit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UndoableEdit uncomment(DomRange range) {
        XmlModel model = ((XmlContext)this.getContext().getDomModelContext()).getModel();
        TreeTraversal traversal = ((AbstractModel)model).getTreeTraversal();
        List<Node> nodes = this._getNodesFromRange(range, traversal);
        List<int[]> sections = this._computeUncommentSections(nodes, traversal);
        UndoableEdit textEdit = null;
        if (this._textBuffer.isReadOnly()) {
            this._checkoutTextBufferSourceIfNeeded(true);
        }
        try {
            this._textSyncInProgress = true;
            this._textBuffer.beginEdit();
        }
        catch (ReadOnlyException ex) {
            this._textSyncInProgress = false;
            throw ex;
        }
        try {
            for (int i = sections.size() - 1; i >= 0; --i) {
                int[] section = sections.get(i);
                this._textBuffer.remove(section[1] - END_COMMENT_SIZE, END_COMMENT_SIZE);
                this._textBuffer.remove(section[0], BEGIN_COMMENT_SIZE);
            }
        }
        finally {
            this._textSyncInProgress = false;
            textEdit = this._textBuffer.endEdit();
        }
        this._ensureSynchronizedImmediate();
        if (textEdit == null) {
            return null;
        }
        return new ForceReparseUndoableEditWrapper(this, textEdit);
    }

    boolean __isInSetUnspecifiedAttribute() {
        return this._inSetUnspecifiedAttribute;
    }

    private void _checkoutTextBufferSourceIfNeeded(boolean canModifyUndoStack) {
        boolean success;
        VersionControlService vcs = (VersionControlService)this.getContext().getDomModelContext().getService("oracle.bali.xml.model.services.VersionControlService");
        if (vcs != null && vcs.supportsCheckOut(this._textBufferSource) && !(success = vcs.performCheckOut(this._textBufferSource, canModifyUndoStack))) {
            this.getContext().getLogger().fine("BufferDomModel: Auto Checkout failed for: " + this._textBufferSource);
        }
    }

    private void _attachTextBufferListener() {
        if (this._textBuffer != null) {
            this._weakTextBufferListenerWrapper = (TextBufferListener)WeakListenerProxy.create(TextBufferListener.class, (Object)this._textBufferListener, TextBuffer.class, (Object)this._textBuffer, (String)"removeTextBufferListener");
            this._textBuffer.addTextBufferListener(this._weakTextBufferListenerWrapper);
        }
    }

    private void _detachTextBufferListener() {
        if (this._textBuffer != null && this._weakTextBufferListenerWrapper != null) {
            this._textBuffer.removeTextBufferListener(this._weakTextBufferListenerWrapper);
            this._weakTextBufferListenerWrapper = null;
        }
    }

    private DocumentType _getDocType() {
        Document doc = this.getContext().getDocument();
        if (doc != null) {
            return doc.getDoctype();
        }
        return null;
    }

    private void _ensureSynchronizedImmediate() {
        if (this._immediateParseInProgress) {
            return;
        }
        if (this._textSyncInProgress) {
            return;
        }
        try {
            this._immediateParseInProgress = true;
            this._realEnsureSynchronizedImmediate();
        }
        finally {
            this._immediateParseInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _realEnsureSynchronizedImmediate() {
        Object object = updateTimerLock;
        synchronized (object) {
            if (this._currentTask != null) {
                this._currentTask.cancel();
                this._currentTask = null;
            }
        }
        if (this._isOutOfSync()) {
            this._forceParse = false;
            Integer[] changeCounts = new Integer[2];
            changeCounts[0] = IntegerUtils.getInteger((int)this._synchedChangeCount);
            long before = System.currentTimeMillis();
            LocatorManager manager = new LocatorManager(this._textBuffer.getLineMap());
            HashMap locatorMap = new HashMap();
            Document newDocument = null;
            try {
                newDocument = BufferDomModel._parseCurrentTextBuffer(this._parser, this._textBuffer, manager, locatorMap, changeCounts, this.getContext().getLogger(), null);
            }
            catch (BufferDomParseCancelledException parseCancelledEx) {
                throw new IllegalStateException("BufferDomModel: Parse cancelled during ensureSynchronizedImmediate");
            }
            long after = System.currentTimeMillis();
            Logger log = this.getContext().getLogger();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "BufferDom parse time (foreground): {0}ms file={1}", new Object[]{new Long(after - before), this});
            }
            this._changeDocument(newDocument, this._parser.__getXmlDeclarationInfo(), manager, locatorMap, changeCounts);
        }
    }

    private void _ensureSynchronizedThreaded() {
        if (this._isOutOfSync()) {
            BufferDomDocumentParser parser = new BufferDomDocumentParser(this._parser.getDOMImplementation(), this._parser.getParserConfiguration(), this._parser.getDocumentScannerFactory(), this._parser.getWhitespaceHandler());
            LocatorManager manager = new LocatorManager(this._textBuffer.getLineMap());
            HashMap locatorMap = new HashMap();
            Integer[] changeCounts = new Integer[2];
            changeCounts[0] = IntegerUtils.getInteger((int)this._synchedChangeCount);
            long before = System.currentTimeMillis();
            Document newDocument = null;
            boolean parseCancelled = false;
            try {
                newDocument = BufferDomModel._parseCurrentTextBuffer(parser, this._textBuffer, manager, locatorMap, changeCounts, this.getContext().getLogger(), this._optionalTextBufferLock);
            }
            catch (BufferDomParseCancelledException parseCancelledEx) {
                parseCancelled = true;
            }
            long after = System.currentTimeMillis();
            Logger log = this.getContext().getLogger();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "BufferDom parse time (background, cancelled={0}, thread={1}): {2}ms file={3}", new Object[]{parseCancelled, Thread.currentThread(), new Long(after - before), this});
            }
            if (!parseCancelled) {
                this._changeDocument(newDocument, parser.__getXmlDeclarationInfo(), manager, locatorMap, changeCounts);
            }
        }
    }

    private boolean _isOutOfSync() {
        if (this._textSyncInProgress) {
            return false;
        }
        if (this._forceParse) {
            return true;
        }
        return this._synchedChangeCount != this._textBuffer.getChangeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document _parseCurrentTextBuffer(BufferDomDocumentParser parser, TextBuffer textBuffer, LocatorManager manager, HashMap locatorMap, Integer[] changeCounts, Logger logger, ReadWriteLock optionalLockUsedToCancelParse) throws BufferDomParseCancelledException {
        Document document = null;
        manager.clear();
        locatorMap.clear();
        ParseCancelListener parseCancelListener = new ParseCancelListener(parser);
        try {
            textBuffer.readLock();
            if (optionalLockUsedToCancelParse != null) {
                optionalLockUsedToCancelParse.addWriteLockRequestListener((WriteLockRequestListener)parseCancelListener);
            }
            changeCounts[1] = IntegerUtils.getInteger((int)textBuffer.getChangeId());
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "About to parse; oldCount={0} newCount={1} thread={2}", new Object[]{changeCounts[0], changeCounts[1], Thread.currentThread().getName()});
            }
            if (parseCancelListener.isCancelled()) {
                throw new BufferDomParseCancelledException();
            }
            document = parser.parse((ReadTextBuffer)textBuffer, manager, locatorMap);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "DONE parse; oldCount={0} newCount={1} thread={2}", new Object[]{changeCounts[0], changeCounts[1], Thread.currentThread().getName()});
            }
        }
        catch (BufferDomParseCancelledException parseCancelled) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "CANCELLED parse; oldCount={0} newCount={1} thread={2}", new Object[]{changeCounts[0], changeCounts[1], Thread.currentThread().getName()});
            }
            throw parseCancelled;
        }
        catch (RuntimeException unexpected) {
            logger.log(Level.SEVERE, "BufferDomModel parse failed with unexpected exception", unexpected);
            document = null;
        }
        finally {
            if (optionalLockUsedToCancelParse != null) {
                optionalLockUsedToCancelParse.removeWriteLockRequestListener((WriteLockRequestListener)parseCancelListener);
            }
            textBuffer.readUnlock();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _changeDocument(Document document, XmlDeclarationInfo xmlDecl, LocatorManager manager, HashMap locatorMap, Integer[] changeCounts) {
        assert (BufferDomModel._assertLocatorStateAfterReparse(document, xmlDecl, manager, locatorMap));
        if (changeCounts[0] == this._synchedChangeCount) {
            this.acquireWriteLockDirectly();
            this._documentChangeInProgress = true;
            try {
                this._synchedChangeCount = changeCounts[1];
                this.getContext().firePropertyChange("textBufferModified", Boolean.FALSE, Boolean.TRUE);
                if (this._manager != manager) {
                    this._manager.clear();
                    this._manager = manager;
                }
                if (this._locatorMap != locatorMap) {
                    this._locatorMap.clear();
                    this._locatorMap = locatorMap;
                }
                this._xmlDeclarationInfo = xmlDecl;
                this.getContext().replaceDocument(document);
                if (this._reparseAfterDocumentChange) {
                    this._reparseAfterDocumentChange = false;
                    this._documentChangeInProgress = false;
                    this._forceParse = true;
                    this._realEnsureSynchronizedImmediate();
                }
            }
            finally {
                this._reparseAfterDocumentChange = false;
                this._documentChangeInProgress = false;
                this.releaseWriteLockDirectly();
            }
        }
    }

    @Override
    protected void postReplaceDocument(Document newDocument) {
        this._recomputeIndentSize = true;
        if (newDocument == null) {
            this._manager.clear();
            this._locatorMap.clear();
            this._forceParse = true;
        }
    }

    private void _attachNodeLocators(Node node, boolean attach) {
        Locator locator = this._getLocatorDirectly(node);
        Locator.attach(this._manager, attach, locator);
        if (node.getNodeType() == 1) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this._attachNodeLocators(child, attach);
            }
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                int numAttributes = attributes.getLength();
                for (int i = 0; i < numAttributes; ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    if (attr == null) continue;
                    this._attachNodeLocators(attr, attach);
                }
            }
        }
    }

    private void _updateIndentationSize(Document document) {
        Element root;
        if (document != null && (root = document.getDocumentElement()) != null) {
            int[] frequencies = new int[8];
            ElementLocator rootLocator = (ElementLocator)this._getLocatorDirectly(root);
            this._findIndentationSizeForChildren(root, rootLocator, frequencies);
            int maxFrequency = 0;
            int maxIndentValue = -1;
            for (int i = 0; i < frequencies.length; ++i) {
                if (frequencies[i] <= maxFrequency) continue;
                maxIndentValue = i + 1;
                maxFrequency = frequencies[i];
            }
            if (maxIndentValue != -1) {
                this._indentationSize = maxIndentValue;
            }
        }
    }

    private void _findIndentationSizeForChildren(Element parent, ElementLocator parentLocator, int[] frequencies) {
        this._findIndentationSizeForChildrenHelper(parent, parentLocator, frequencies, 0);
    }

    private void _findIndentationSizeForChildrenHelper(Element parent, ElementLocator parentLocator, int[] frequencies, int depth) {
        if (depth >= 8) {
            return;
        }
        if (parentLocator == null) {
            return;
        }
        SimpleLocator parentStartLocator = parentLocator.getStartTagLocator();
        int childIndex = 0;
        for (Node child = parent.getFirstChild(); child != null && childIndex < 10; child = child.getNextSibling(), ++childIndex) {
            int childIndent;
            Locator childLocator = this._getLocatorDirectly(child);
            if (childLocator == null) continue;
            if (DomUtils.isElement((Node)child)) {
                Element childElem = (Element)child;
                ElementLocator childElemLocator = (ElementLocator)childLocator;
                childIndent = this._getIndentationBetweenLocators(parentStartLocator, childElemLocator.getStartTagLocator());
                this._findIndentationSizeForChildrenHelper(childElem, childElemLocator, frequencies, depth + 1);
            } else {
                childIndent = this._getIndentationBetweenLocators(parentStartLocator, childLocator);
            }
            if (childIndent <= 0 || childIndent > 8) continue;
            int n = childIndent - 1;
            frequencies[n] = frequencies[n] + 1;
        }
    }

    private int _getIndentationBetweenLocators(Locator parent, Locator child) {
        if (parent.getStartLineNumber() == child.getStartLineNumber()) {
            return 0;
        }
        return child.getStartColumnNumber() - parent.getStartColumnNumber();
    }

    private void _doWfCheck() {
        List wfErrors = Collections.EMPTY_LIST;
        try {
            wfErrors = this._parserConfiguration.doWellFormednessCheck(this, this.getTextBuffer());
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getContext().getLogger().log(Level.WARNING, "Exception in well-formedness check!", t);
        }
        finally {
            this._wfErrors = wfErrors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reAddUnspecifiedAttributes(Map<Attr, Element> attrMap) {
        this._inSetUnspecifiedAttribute = true;
        try {
            for (Map.Entry<Attr, Element> entry : attrMap.entrySet()) {
                Attr attr = entry.getKey();
                Element owner = entry.getValue();
                owner.setAttributeNodeNS(attr);
            }
        }
        finally {
            this._inSetUnspecifiedAttribute = false;
        }
    }

    private Map<Attr, Element> _removeUnspecifiedAttributes(Node node) {
        Node walk;
        HashMap<Attr, Element> attrMap = new HashMap<Attr, Element>();
        NodeIterator itor = ((DocumentTraversal)((Object)DomUtils.getOwnerDocument((Node)node))).createNodeIterator(node, 1, null, false);
        ArrayList<Attr> attrsToRemove = new ArrayList<Attr>(5);
        while ((walk = itor.nextNode()) != null) {
            NamedNodeMap attrs = walk.getAttributes();
            if (attrs == null) continue;
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (!this.isUnspecifiedAttribute(attr)) continue;
                attrsToRemove.add(attr);
            }
        }
        for (int i = 0; i < attrsToRemove.size(); ++i) {
            Attr attr = (Attr)attrsToRemove.get(i);
            Element elem = attr.getOwnerElement();
            attrMap.put(attr, elem);
            attr.getOwnerElement().removeAttributeNode(attr);
        }
        itor.detach();
        return attrMap;
    }

    private static boolean _assertLocatorStateAfterReparse(Document document, XmlDeclarationInfo xmlDecl, LocatorManager manager, Map locatorMap) {
        assert (document != null);
        assert (manager != null);
        assert (locatorMap != null);
        BufferDomModel._assertLocatorStateForNode(document, manager, locatorMap);
        if (xmlDecl != null) {
            BufferDomModel._assertLocatorOK(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY, locatorMap, manager);
        }
        return true;
    }

    private static void _assertLocatorStateForNode(Node node, LocatorManager manager, Map locatorMap) {
        BufferDomModel._assertLocatorOK(node, locatorMap, manager);
        if (node.getNodeType() != 2) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                BufferDomModel._assertLocatorStateForNode(child, manager, locatorMap);
            }
            NamedNodeMap attrs = node.getAttributes();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    BufferDomModel._assertLocatorStateForNode(attrs.item(i), manager, locatorMap);
                }
            }
        }
    }

    private static void _assertLocatorOK(Object key, Map locatorMap, LocatorManager manager) {
        if (key instanceof DocumentType) {
            key = BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY;
        } else if (key instanceof Document) {
            return;
        }
        Object loc = locatorMap.get(key);
        assert (loc != null) : "locator null for key " + key;
        assert (loc instanceof Locator) : "locator has wrong type for key " + key;
    }

    private static Node _getAncestorNode(Node a, Node b) {
        boolean areNodesSame = a.isSameNode(b);
        Node bigNode = null;
        if (areNodesSame || DomUtils.isDescendant((Node)b, (Node)a)) {
            bigNode = a;
        } else if (DomUtils.isDescendant((Node)a, (Node)b)) {
            bigNode = b;
        }
        return bigNode;
    }

    private List<Node> _getNodesFromRange(DomRange range, TreeTraversal traversal) {
        DomPosition start = range.getStart();
        DomPosition end = range.getEnd();
        if (end.isAfter() && DomUtils.isDescendant((TreeTraversal)traversal, (Node)start.getTargetNode(), (Node)end.getTargetNode())) {
            range = range.getRangeWithNewStart(traversal, end.getBeforePosition());
        }
        List nodes = range.getNodesInRange(traversal);
        HashSet<Node> eliminatedNodes = new HashSet<Node>();
        LinkedHashSet<Node> acceptedNodes = new LinkedHashSet<Node>();
        for (Node n : nodes) {
            Node parent = n.getParentNode();
            if (!eliminatedNodes.contains(parent) && !acceptedNodes.contains(parent)) {
                acceptedNodes.add(n);
                continue;
            }
            eliminatedNodes.add(n);
        }
        return new ArrayList<Node>(acceptedNodes);
    }

    private List<Node> _ensureSiblingNodes(List<Node> nodes) {
        if (nodes.size() > 1) {
            Node firstNode = nodes.get(0);
            Node lastNodeParent = nodes.get(nodes.size() - 1).getParentNode();
            while (firstNode.getParentNode() != lastNodeParent) {
                firstNode = firstNode.getParentNode();
            }
            nodes.set(0, firstNode);
        }
        return nodes;
    }

    private List<int[]> _computeCommentSections(List<Node> nodes, TreeTraversal traversal, DomRange range) {
        Node n;
        ArrayList<int[]> sections = new ArrayList<int[]>();
        int[] section = null;
        if (nodes.size() == 1 && (n = nodes.get(0)) instanceof XMLText) {
            section = new int[]{this.getTextOffset(range.getStart()), this.getTextOffset(range.getEnd())};
            return Collections.singletonList(section);
        }
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node n2;
            Node walk = n2 = iterator.next();
            do {
                if (walk instanceof XMLComment) {
                    if (section == null) continue;
                    section[1] = this.getLocator(walk).getStartOffset();
                    if (section[0] < section[1]) {
                        sections.add(section);
                        section = new int[2];
                    }
                    section[0] = this.getLocator(walk).getEndOffset();
                    continue;
                }
                if (section != null) continue;
                section = new int[2];
                section[0] = this.getLocator(walk).getStartOffset();
            } while ((walk = traversal.getNextNode(walk)) != null && DomUtils.isDescendant((TreeTraversal)traversal, (Node)walk, (Node)n2));
        }
        if (section != null) {
            section[1] = this.getLocator(nodes.get(nodes.size() - 1)).getEndOffset();
            if (section[0] < section[1]) {
                sections.add(section);
            }
        }
        return sections;
    }

    private List<int[]> _computeUncommentSections(List<Node> nodes, TreeTraversal traversal) {
        ArrayList<int[]> sections = new ArrayList<int[]>();
        int[] section = null;
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node n;
            Node walk = n = iterator.next();
            do {
                if (!(walk instanceof XMLComment)) continue;
                section = new int[]{this.getLocator(walk).getStartOffset(), this.getLocator(walk).getEndOffset()};
                sections.add(section);
            } while ((walk = traversal.getNextNode(walk)) != null && DomUtils.isDescendant((TreeTraversal)traversal, (Node)walk, (Node)n));
        }
        return sections;
    }

    private String _escapeDashDash(String text) {
        String regexp = "[-]{2}";
        String sub = "-+-";
        String escapedText = text.replaceAll("[-]{2}", "-+-");
        if (text != escapedText) {
            escapedText = escapedText.replaceAll("[-]{2}", "-+-");
        }
        if (escapedText.startsWith("-")) {
            escapedText = "+" + escapedText;
        }
        if (escapedText.endsWith("-")) {
            escapedText = escapedText + "+";
        }
        return escapedText;
    }

    private static class ParseCancelListener
    implements WriteLockRequestListener {
        private final BufferDomDocumentParser _parser;
        private volatile boolean _isCancelled = false;

        public ParseCancelListener(BufferDomDocumentParser parser) {
            this._parser = parser;
        }

        public void writeRequested(ReadWriteLock lock) {
            this._isCancelled = true;
            this._parser.cancelParse();
        }

        public boolean isCancelled() {
            return this._isCancelled;
        }
    }

    private static class ForceReparseUndoableEditWrapper
    extends UndoableEditWrapper {
        private final UndoableEdit _textEdit;
        private final Reference _pluginRef;

        public ForceReparseUndoableEditWrapper(BufferDomModel plugin, UndoableEdit textEdit) {
            this._textEdit = textEdit;
            this._pluginRef = plugin.getBufferDomPluginReference();
        }

        @Override
        protected UndoableEdit getBaseEdit() {
            return this._textEdit;
        }

        @Override
        public void redo() throws CannotRedoException {
            BufferDomModel plugin = (BufferDomModel)this._pluginRef.get();
            if (plugin == null) {
                super.redo();
            } else {
                plugin._textSyncInProgress = true;
                try {
                    super.redo();
                }
                finally {
                    plugin._textSyncInProgress = false;
                }
                plugin._ensureSynchronizedImmediate();
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            BufferDomModel plugin = (BufferDomModel)this._pluginRef.get();
            if (plugin == null) {
                super.undo();
            } else {
                plugin._textSyncInProgress = true;
                try {
                    super.undo();
                }
                finally {
                    plugin._textSyncInProgress = false;
                }
                plugin._ensureSynchronizedImmediate();
            }
        }
    }

    private static class UpdateTimerTask
    extends TimerTask {
        private final Reference _pluginRef;

        public UpdateTimerTask(BufferDomModel bufferDomPlugin) {
            this._pluginRef = bufferDomPlugin.getBufferDomPluginReference();
        }

        @Override
        public void run() {
            BufferDomModel bufferDomPlugin = (BufferDomModel)this._pluginRef.get();
            if (bufferDomPlugin != null) {
                bufferDomPlugin._ensureSynchronizedThreaded();
            }
        }
    }

    private class NodeComparatorByLocator
    implements Comparator {
        private NodeComparatorByLocator() {
        }

        public int compare(Object a, Object b) {
            if (a == b) {
                return 0;
            }
            return this._compare((Node)a, (Node)b);
        }

        private int _compare(Node a, Node b) {
            Locator aLoc = BufferDomModel.this._getLocatorDirectly(a);
            Locator bLoc = BufferDomModel.this._getLocatorDirectly(b);
            if (aLoc == null) {
                return -1;
            }
            if (bLoc == null) {
                return 1;
            }
            int startDiff = aLoc.getStartOffset() - bLoc.getStartOffset();
            if (startDiff == 0) {
                return aLoc.getEndOffset() - bLoc.getEndOffset();
            }
            return startDiff;
        }
    }

    private class TextBufferChangeListener
    implements TextBufferListener {
        private TextBufferChangeListener() {
        }

        public void insertUpdate(TextBuffer buffer, int startOffset, int length, char[] chars) {
            this._onTextBufferModification();
        }

        public void removeUpdate(TextBuffer buffer, int startOffset, int length, char[] chars) {
            this._onTextBufferModification();
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            if (attribute == 2) {
                BufferDomModel.this.getContext().handleReadOnlyStatusChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _onTextBufferModification() {
            if (!BufferDomModel.this._textSyncInProgress) {
                Object object = updateTimerLock;
                synchronized (object) {
                    if (BufferDomModel.this._currentTask != null) {
                        BufferDomModel.this._currentTask.cancel();
                    }
                    BufferDomModel.this._currentTask = new UpdateTimerTask(BufferDomModel.this);
                    try {
                        if (_updateTimer == null) {
                            _updateTimer = (Timer)new NamedTimer("BufferDomModel background parse thread", 1, true);
                        }
                        _updateTimer.schedule((TimerTask)BufferDomModel.this._currentTask, 750L);
                    }
                    catch (Exception e) {
                        _updateTimer = null;
                    }
                }
            }
        }
    }
}

