/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl.handlers.element.list;

import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import oracle.bali.xml.beanmodel.BeanBaseRegistry;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.beanmodel.impl.handlers.element.ElementInvocationHandler;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.validator.prospective.ProspectiveValidationContext;
import oracle.bali.xml.validator.prospective.ProspectiveValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementListInvocationHandler
extends ElementInvocationHandler {
    protected final <T> List<T> createChildList(DynamicProxyContext context, Element parent, List<QualifiedName> childNames, Type listItemType) {
        return new ListImpl(context, parent, childNames, listItemType);
    }

    private class DynamicProxyProspectiveValidationContext
    extends ProspectiveValidationContext {
        private final DynamicProxyContext _context;

        public DynamicProxyProspectiveValidationContext(DynamicProxyContext context) {
            this._context = context;
        }

        public XmlKey getNodeXmlKey(Node node) {
            return this._context.getXmlModel().getNodeXmlKey(node);
        }

        public GrammarComponent getGrammarComponent(XmlKey xmlKey) {
            return this._context.getXmlModel().getGrammarComponent(xmlKey);
        }

        public Comparator getInsertionComparator(Node node) {
            return this._context.getXmlModel().getXmlMetadataResolver().getInsertionComparator(node);
        }

        public GrammarResolver getGrammarResolver() {
            return this._context.getGrammarResolver();
        }
    }

    private class ListImpl<T>
    extends AbstractList<T> {
        private final DynamicProxyContext _context;
        private final Element _parent;
        private final List<QualifiedName> _childNames;
        private final Type _listItemType;
        private volatile List<Element> _currentChildList = null;
        private Object _currentChildListCreationLock = new Object();
        private final DynamicProxyProspectiveValidationContext _prospectiveValidationContext;
        private final QualifiedName ANY_TYPE_QN = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)"anyType");

        public ListImpl(DynamicProxyContext context, Element parent, List<QualifiedName> childNames, Type listItemType) {
            if (context == null || parent == null || childNames == null || listItemType == null) {
                throw new IllegalArgumentException("ElementList constructor passed null parameter (all params are required to have non null values)");
            }
            this._context = context;
            this._parent = parent;
            this._childNames = childNames;
            this._listItemType = listItemType;
            this._prospectiveValidationContext = new DynamicProxyProspectiveValidationContext(this._context);
        }

        @Override
        public T get(int index) {
            this._verifyContextState(false);
            Element childElement = this._getChildList().get(index);
            return this._convertToListItemType(childElement);
        }

        @Override
        public int size() {
            this._verifyContextState(false);
            return this._getChildList().size();
        }

        @Override
        public T remove(int index) {
            this._verifyContextState(true);
            Element childElement = this._getChildList().remove(index);
            this._parent.removeChild(childElement);
            ++this.modCount;
            return this._convertToListItemType(childElement);
        }

        @Override
        public T set(int index, T listItem) {
            this._verifyContextState(true);
            Element newChildElement = this._getOrCreateUnderlyingElement(listItem);
            List<Element> childList = this._getChildList();
            if (index < 0 || index >= childList.size()) {
                throw new IndexOutOfBoundsException("Invalid index passed to set method.  Invalid index: " + index + ",  current list size: " + childList.size());
            }
            if (childList.contains(newChildElement)) {
                throw new IllegalArgumentException("Set method passed instance that is already contained in this List.  Duplicate elements of type " + this._listItemType + " are not supported by this list implementation.");
            }
            T previous = this.remove(index);
            this.add(index, listItem);
            return previous;
        }

        @Override
        public void add(int index, T listItem) {
            this._verifyContextState(true);
            Element newChildElement = this._getOrCreateUnderlyingElement(listItem);
            List<Element> childList = this._getChildList();
            if (index < 0 || index > childList.size()) {
                throw new IndexOutOfBoundsException("Invalid index passed to add method.  Invalid index: " + index + ",  current list size: " + childList.size());
            }
            if (childList.contains(newChildElement)) {
                throw new IllegalArgumentException("Add method passed instance that is already contained in this List.  Duplicate elements of type " + this._listItemType + " are not supported by this list implementation.");
            }
            DomPosition firstAcceptablePosition = null;
            DomPosition lastAcceptablePosition = null;
            int previousIndex = index - 1;
            if (previousIndex >= 0) {
                firstAcceptablePosition = DomPositionFactory.after((Node)childList.get(previousIndex));
            }
            if (index < childList.size()) {
                lastAcceptablePosition = DomPositionFactory.before((Node)childList.get(index));
            }
            DomPosition requestedPosition = DomPositionFactory.inside((Node)this._parent);
            if (lastAcceptablePosition != null) {
                requestedPosition = lastAcceptablePosition;
            } else if (firstAcceptablePosition != null) {
                requestedPosition = firstAcceptablePosition;
            }
            XmlKey newChildKey = this._context.getXmlModel().getElementKey(this._context.getXmlKey(), DomUtils.getQualifiedName((Node)newChildElement));
            Set validPositions = ProspectiveValidator.findValidInsertionPositions((ProspectiveValidationContext)this._prospectiveValidationContext, (XmlKey)newChildKey, (Node)newChildElement, (DomPosition)requestedPosition, (XmlKey)this._context.getXmlKey());
            DomPosition bestPosition = requestedPosition;
            if (validPositions != null && !DomUtils.containsPositionOrEquivalent((TreeTraversal)DocumentTreeTraversal.INSTANCE, (Set)validPositions, (DomPosition)bestPosition)) {
                for (DomPosition validPosition : validPositions) {
                    if (firstAcceptablePosition != null && validPosition.compare((TreeTraversal)DocumentTreeTraversal.INSTANCE, firstAcceptablePosition) < 0 || lastAcceptablePosition != null && validPosition.compare((TreeTraversal)DocumentTreeTraversal.INSTANCE, lastAcceptablePosition) > 0) continue;
                    bestPosition = validPosition;
                }
            }
            childList.add(index, newChildElement);
            XmlModel model = this._context.getXmlModel();
            if (model.isInModelDocumentHierarchy(this._parent)) {
                model.fixPrefixes(this._parent, newChildElement);
            }
            DomUtils.insertNodeAtPosition((DomPosition)bestPosition, (Node)newChildElement);
            ++this.modCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Element> _getChildList() {
            if (this._currentChildList == null) {
                Object object = this._currentChildListCreationLock;
                synchronized (object) {
                    if (this._currentChildList == null) {
                        List<Element> newList = this._createMutableChildList(this._parent, this._childNames);
                        this._currentChildList = newList;
                    }
                }
            }
            return this._currentChildList;
        }

        private T _convertToListItemType(Element element) {
            Type returnType = null;
            QualifiedName childName = DomUtils.getQualifiedName((Node)element);
            XmlKey newChildKey = this._context.getXmlModel().getElementKey(this._context.getXmlKey(), childName);
            if (newChildKey.getElementQNamePath().size() == 1) {
                List<BeanBaseRegistry> registries = this._context.getXmlModel().getContext().getBeanRegistries();
                for (BeanBaseRegistry registry : registries) {
                    Class type = registry.getClassForQualifiedName(childName);
                    if (type == null) continue;
                    returnType = type;
                    break;
                }
            }
            if (returnType == null) {
                returnType = this._listItemType;
            }
            return (T)ElementListInvocationHandler.this.convertToType(returnType, this._context, element, newChildKey);
        }

        private List<Element> _createMutableChildList(Element parent, List<QualifiedName> names) {
            ArrayList<Element> list = new ArrayList<Element>();
            for (Node currChild = parent.getFirstChild(); currChild != null; currChild = currChild.getNextSibling()) {
                if (!this.isListItem(currChild, names)) continue;
                list.add((Element)currChild);
            }
            return list;
        }

        private Element _getOrCreateUnderlyingElement(T listItem) {
            if (listItem instanceof XmlBaseType) {
                XmlBaseType listItemBean = (XmlBaseType)listItem;
                Node node = listItemBean.getDomNode();
                if (!DomUtils.isElement((Node)node)) {
                    throw new IllegalStateException("Expected node to be of Element type, but found: " + node);
                }
                Element element = (Element)node;
                QualifiedName elementName = DomUtils.getQualifiedName((Node)element);
                if (!this._childNames.contains(elementName) && !this._childNames.contains(this.ANY_TYPE_QN)) {
                    throw new UnsupportedOperationException("Attempt to set a child that was created with a conflicting qualified name.");
                }
                return element;
            }
            QualifiedName childName = this._childNames.get(0);
            XmlKey newChildKey = this._context.getXmlModel().getElementKey(this._context.getXmlKey(), childName);
            String stringValue = ElementListInvocationHandler.this.convertSimpleTypeToString(this._context.getXmlModel(), newChildKey, listItem);
            Document document = this._context.getXmlModel().getDocument();
            Element newElement = document.createElementNS(childName.getNamespace(), childName.getName());
            boolean preferCDATA = this._context.getXmlModel().getXmlMetadataResolver().getPrefersCDATAValue(newChildKey);
            DomUtils.setTextContent((Node)newElement, (String)stringValue, (boolean)preferCDATA);
            return newElement;
        }

        private void _verifyContextState(boolean isWrite) {
            if (this._context.isExpired()) {
                throw new IllegalStateException("XMLEF Bean Model List implementation called with expired DynamicProxyContext. Beans can only be used within the task they were created");
            }
            if (isWrite) {
                this._context.getXmlModel().getDomModel().verifyWriteLock();
            } else {
                this._context.getXmlModel().getDomModel().verifyLock();
            }
        }

        private boolean isListItem(Node node, List<QualifiedName> names) {
            if (DomUtils.isElement((Node)node)) {
                List wildcards;
                Wildcard wildcard;
                ElementDef elemDef;
                ElementDef childDef;
                QualifiedName qName = DomUtils.getQualifiedName((Node)node);
                if (names.contains(qName)) {
                    return true;
                }
                if (names.contains(this.ANY_TYPE_QN) && (childDef = (elemDef = (ElementDef)this._context.getXmlModel().getGrammarComponent(this._context.getXmlKey())).getElementDefByName(qName)) == null && (wildcard = TypeUtils.getMatchingWildcard((List)(wildcards = TypeUtils.getElementWildcards((ElementDef)elemDef)), (String)qName.getNamespace())) != null && TypeUtils.wildcardAllowsName((Wildcard)wildcard, (QualifiedName)qName)) {
                    if (wildcard.getProcessingRule() == 0) {
                        Grammar g = this._context.getGrammarResolver().getGrammarForNamespace(qName.getNamespace());
                        if (g != null && g.getElementDefByName(qName.getName()) != null) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

