/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl.handlers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.beanmodel.annotation.MethodIdentifier;
import oracle.bali.xml.beanmodel.impl.handlers.MethodInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.attribute.AttributeGetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.attribute.AttributeIsSetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.attribute.AttributeSetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.attribute.AttributeUnsetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.element.ElementCreateInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.element.ElementGetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.element.ElementSetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.element.ElementUnsetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.element.list.ElementAddListInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.element.list.ElementGetListInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.element.list.ElementWildcardGetListInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.type.TypeGetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.type.TypeGetTextInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.type.TypeSetInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.type.TypeSetTextInvocationHandler;

public class MethodInvocationHandlerRegistry {
    private static MethodInvocationHandlerRegistry _sInstance = null;
    private static ConcurrentHashMap<MethodIdentifier, MethodInvocationHandler> _methodInvocationHandlerMap = new ConcurrentHashMap();
    private static final Logger _sLogger = Logger.getLogger(MethodInvocationHandlerRegistry.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodInvocationHandlerRegistry getInstance() {
        if (_sInstance != null) return _sInstance;
        Class<MethodInvocationHandlerRegistry> clazz = MethodInvocationHandlerRegistry.class;
        synchronized (MethodInvocationHandlerRegistry.class) {
            if (_sInstance != null) return _sInstance;
            MethodInvocationHandlerRegistry registry = new MethodInvocationHandlerRegistry();
            registry.registerMethodInvocationHandler(new AttributeGetInvocationHandler());
            registry.registerMethodInvocationHandler(new AttributeSetInvocationHandler());
            registry.registerMethodInvocationHandler(new AttributeUnsetInvocationHandler());
            registry.registerMethodInvocationHandler(new AttributeIsSetInvocationHandler());
            registry.registerMethodInvocationHandler(new ElementGetInvocationHandler());
            registry.registerMethodInvocationHandler(new ElementSetInvocationHandler());
            registry.registerMethodInvocationHandler(new ElementUnsetInvocationHandler());
            registry.registerMethodInvocationHandler(new ElementCreateInvocationHandler());
            registry.registerMethodInvocationHandler(new ElementGetListInvocationHandler());
            registry.registerMethodInvocationHandler(new ElementAddListInvocationHandler());
            registry.registerMethodInvocationHandler(new ElementWildcardGetListInvocationHandler());
            registry.registerMethodInvocationHandler(new TypeGetInvocationHandler());
            registry.registerMethodInvocationHandler(new TypeSetInvocationHandler());
            registry.registerMethodInvocationHandler(new TypeGetTextInvocationHandler());
            registry.registerMethodInvocationHandler(new TypeSetTextInvocationHandler());
            _sInstance = registry;
            // ** MonitorExit[var0] (shouldn't be in output)
            return _sInstance;
        }
    }

    public void registerMethodInvocationHandler(MethodInvocationHandler handler) {
        MethodInvocationHandler previous = _methodInvocationHandlerMap.putIfAbsent(handler.getMethodIdentifier(), handler);
        if (previous != null) {
            _sLogger.log(Level.SEVERE, "Duplicate Bean Method Invocation Handler registered for " + handler.getMethodIdentifier());
        }
    }

    public MethodInvocationHandler getMethodInvocationHandler(MethodIdentifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("getMethodInvocationHandler called with null identifier");
        }
        return _methodInvocationHandlerMap.get(identifier);
    }

    private MethodInvocationHandlerRegistry() {
    }
}

