/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration.ant.task;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.beanmodel.apigeneration.GenerationManager;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.EnumOverride;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.GenerationPathInfo;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.MetadataCollection;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.PathCollection;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.SkipNamespace;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.TreatTypeAsSimple;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.TypeMapping;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataProvider;
import oracle.bali.xml.model.grammar.DirectoryEntityResolver;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.apache.tools.ant.BuildException;
import org.xml.sax.EntityResolver;

public final class TaskUtils {
    private static final Map<String, Long> _timingMap = new HashMap<String, Long>(5);
    private static final Logger _LOGGER = Logger.getLogger(TaskUtils.class.getName());
    private static final String _SPACE = " ";

    private TaskUtils() {
    }

    public static void startTimeTracking(String key, String msg) {
        _timingMap.put(key, System.currentTimeMillis());
        TaskUtils.log(msg);
    }

    public static void endTimeTracking(String key, String msg) {
        Long start = _timingMap.get(key);
        if (start == null) {
            return;
        }
        long time = System.currentTimeMillis() - start;
        StringBuffer sb = new StringBuffer();
        sb.append(msg);
        sb.append(_SPACE);
        sb.append("in");
        sb.append(_SPACE);
        sb.append(time).append("ms");
        TaskUtils.log(sb.toString());
    }

    public static void log(String msg) {
        _LOGGER.info(msg);
    }

    static URL getGenSrcDir(GenerationPathInfo info) throws BuildException {
        String errMsg = TaskUtils._getGenPathErrMsg(info);
        if (errMsg != null) {
            throw new BuildException(errMsg);
        }
        String genSrcDir = info.getGenSrcPath();
        if (genSrcDir == null) {
            genSrcDir = info.getOracleHome() + "/" + "built" + "/" + info.getModuleName() + "/" + "gen-src";
        }
        return URLFactory.newURL((String)genSrcDir);
    }

    static GrammarProvider createGrammarProvider(PathCollection schemasPath, PathCollection dirsPath) throws Exception {
        Set<File> schemas = TaskUtils._getResources(schemasPath);
        if (schemas.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("No paths to schema files specified under the");
            sb.append(_SPACE);
            sb.append(schemasPath.getElementName());
            sb.append(_SPACE);
            sb.append("element!");
            throw new BuildException(sb.toString());
        }
        SchemaGrammarProvider sgp = new SchemaGrammarProvider((EntityResolver)TaskUtils.getEntityResolver(dirsPath));
        for (File f : schemas) {
            sgp.addSchema(URLFactory.newURL((String)f.getAbsolutePath()));
        }
        return sgp;
    }

    static MetadataProvider createMetadataProvider(PathCollection metadataPath, GrammarProvider gp) throws StandaloneMetadataFileException {
        Set<File> mdFiles = TaskUtils._getResources(metadataPath);
        GrammarResolver gResolver = new GrammarResolver(gp);
        GrammarMetadataProvider mProvider = new GrammarMetadataProvider(gResolver);
        StandaloneMetadataFileRegistry registry = new StandaloneMetadataFileRegistry();
        for (File f : mdFiles) {
            registry.addStandaloneMetadataFile(OracleStandaloneMetadataFactory.createStandaloneMetadataFile((URL)URLFactory.newURL((String)f.getAbsolutePath())));
        }
        return new StandaloneMetadataProvider((MetadataProvider)mProvider, registry);
    }

    static DirectoryEntityResolver getEntityResolver(PathCollection path) {
        Set<File> dirs = TaskUtils._getResources(path);
        HashSet<URL> urls = new HashSet<URL>(dirs.size());
        for (File f : dirs) {
            URL url = URLFactory.newURL((String)f.getAbsolutePath());
            urls.add(url);
        }
        return new DirectoryEntityResolver(urls);
    }

    static List<String> getMetadataCollection(MetadataCollection mc) {
        if (mc == null) {
            return Collections.emptyList();
        }
        return mc.getValues();
    }

    static String validateResource(String path, boolean isDir) {
        return TaskUtils.validateResource(URLFactory.newDirURL((String)path), isDir);
    }

    static String validateResource(URL path, boolean isDir) {
        if (path == null) {
            return "Path cannot be null!";
        }
        if (!URLFileSystem.exists((URL)path)) {
            return "Resource does not exist!";
        }
        if (isDir && !URLFileSystem.isDirectory((URL)path)) {
            return "Path does not point to a directory!";
        }
        return null;
    }

    static void addSkipNamespaces(GenerationManager gm, List<SkipNamespace> namespaces) {
        String skipNamespace = "<skipNamespace>";
        for (SkipNamespace sns : namespaces) {
            String ns = sns.getNamespace();
            if (ns != null) {
                gm.addSkipNamespace(ns);
                continue;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Found an entry for");
            sb.append(_SPACE);
            sb.append(skipNamespace);
            sb.append(_SPACE);
            sb.append("but namesapce not specified. Ignoring entry!");
            TaskUtils.log(sb.toString());
        }
    }

    static void addTreatAsSimpleTypes(GenerationManager gm, List<TreatTypeAsSimple> simpleTypes) {
        String treatAsSimpleType = "<treatTypeAsSimple>";
        for (TreatTypeAsSimple ttas : simpleTypes) {
            String type = ttas.getType();
            if (type != null) {
                gm.addTreatAsSimple(type);
                continue;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Found an entry for");
            sb.append(_SPACE);
            sb.append(treatAsSimpleType);
            sb.append(_SPACE);
            sb.append("but type name not specified. Ignoring entry!");
            TaskUtils.log(sb.toString());
        }
    }

    static void addTypeMappings(GenerationManager gm, List<TypeMapping> typeMappings) {
        String typeMappingType = "<typeMapping>";
        for (TypeMapping typeMapping : typeMappings) {
            String fromType = typeMapping.getFromType();
            String toType = typeMapping.getToType();
            if (fromType != null && toType != null) {
                gm.addTypeMapping(fromType, toType);
                continue;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Found an entry for");
            sb.append(_SPACE);
            sb.append(typeMappingType);
            sb.append(_SPACE);
            sb.append("but fromType or toType name not specified. Ignoring entry!");
            TaskUtils.log(sb.toString());
        }
    }

    static void addEnumOverrides(GenerationManager gm, List<EnumOverride> enumOverrides) {
        String enumOverrideTag = "<enumOverride>";
        for (EnumOverride enumOverride : enumOverrides) {
            HashSet<String> enumValues = new HashSet<String>(3);
            String values = enumOverride.getValues();
            StringTokenizer tokenizer = new StringTokenizer(values);
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                enumValues.add(value);
            }
            String enumOverrideType = enumOverride.getEnumType();
            if (enumOverrideType != null && !enumValues.isEmpty()) {
                gm.addEnumOverride(enumOverride.getEnumType(), enumValues);
                continue;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Found an entry for");
            sb.append(_SPACE);
            sb.append(enumOverrideTag);
            sb.append(_SPACE);
            sb.append("but enumType or values not specified. Ignoring entry!");
            TaskUtils.log(sb.toString());
        }
    }

    private static Set<File> _getResources(PathCollection path) {
        if (path == null) {
            return Collections.emptySet();
        }
        return path.getResources();
    }

    private static String _getGenPathErrMsg(GenerationPathInfo info) {
        String genPathElementName = "<generationPathInfo>";
        if (info == null) {
            return "Please specify source generation path information using " + genPathElementName;
        }
        String oracleHome = info.getOracleHome();
        String msg = TaskUtils.validateResource(oracleHome, true);
        if (msg != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Issue with oracle home path");
            sb.append(_SPACE);
            sb.append(oracleHome);
            sb.append(_SPACE);
            sb.append("in");
            sb.append(_SPACE);
            sb.append(genPathElementName);
            sb.append(":");
            sb.append(_SPACE);
            sb.append(msg);
            return sb.toString();
        }
        String moduleName = info.getModuleName();
        if (moduleName == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Please specify module name");
            sb.append(_SPACE);
            sb.append("in");
            sb.append(_SPACE);
            sb.append(genPathElementName);
            return sb.toString();
        }
        return null;
    }

    static {
        _LOGGER.setUseParentHandlers(false);
        _LOGGER.addHandler(new AssertHandler());
    }

    private static class AssertFormatter
    extends Formatter {
        private AssertFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder b = new StringBuilder();
            b.append(record.getMessage());
            b.append("\n");
            return b.toString();
        }
    }

    private static class AssertHandler
    extends ConsoleHandler {
        AssertHandler() {
            this.setLevel(Level.INFO);
            this.setFormatter(new AssertFormatter());
        }
    }
}

