/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration.ant.task;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.beanmodel.apigeneration.GenerationManager;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.EnumOverride;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.GenerateAttrDefaultValues;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.GenerateModelGroups;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.GenerationPathInfo;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.ImportSchemaPath;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.MetadataPath;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.PathCollection;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.SchemaPath;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.SkipNamespace;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.TaskUtils;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.TreatTypeAsSimple;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.TypeMapping;
import oracle.bali.xml.grammar.GrammarProvider;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class APIGenerationTask
extends Task {
    private GenerationPathInfo _info;
    private PathCollection _schemaPath;
    private PathCollection _metadataPath;
    private PathCollection _importSchemaPath;
    private GenerateAttrDefaultValues _generateAttrDefaultValues;
    private GenerateModelGroups _generateModelGroups;
    private final List<SkipNamespace> _skipNamespaces = new ArrayList<SkipNamespace>(5);
    private List<TreatTypeAsSimple> _treatAsSimpleTypes = new ArrayList<TreatTypeAsSimple>(5);
    private List<TypeMapping> _typeMappings = new ArrayList<TypeMapping>(5);
    private List<EnumOverride> _enumOverrides = new ArrayList<EnumOverride>(5);

    public void addGenerationPathInfo(GenerationPathInfo info) {
        this._info = info;
    }

    public void addSchemaPath(SchemaPath path) {
        this._schemaPath = path;
    }

    public void addMetadataPath(MetadataPath path) {
        this._metadataPath = path;
    }

    public void addImportSchemaPath(ImportSchemaPath path) {
        this._importSchemaPath = path;
    }

    public void addGenerateAttrDefaultValues(GenerateAttrDefaultValues generateAttrDefaultValues) {
        this._generateAttrDefaultValues = generateAttrDefaultValues;
    }

    public void addGenerateModelGroups(GenerateModelGroups generateModelGroups) {
        this._generateModelGroups = generateModelGroups;
    }

    public void addSkipNamespace(SkipNamespace skipNamespace) {
        this._skipNamespaces.add(skipNamespace);
    }

    public void addTreatTypeAsSimple(TreatTypeAsSimple treatTypeAsSimple) {
        this._treatAsSimpleTypes.add(treatTypeAsSimple);
    }

    public void addTypeMapping(TypeMapping typeMapping) {
        this._typeMappings.add(typeMapping);
    }

    public void addEnumOverride(EnumOverride enumOverride) {
        this._enumOverrides.add(enumOverride);
    }

    public void execute() throws BuildException {
        try {
            TaskUtils.startTimeTracking("APIGenerationTask.execute", "Executing APIGenerationTask");
            URL dir = TaskUtils.getGenSrcDir(this._info);
            GenerationManager gm = GenerationManager.getInstance();
            GrammarProvider gp = TaskUtils.createGrammarProvider(this._schemaPath, this._importSchemaPath);
            gm.setGrammarProvider(gp);
            gm.setMetadataProvider(TaskUtils.createMetadataProvider(this._metadataPath, gp));
            gm.setSourceDirectory(dir);
            gm.setClassPath(this._info.getClassPath());
            gm.reset();
            if (this._generateAttrDefaultValues != null) {
                gm.setGenerateAttrDefaultValues(this._generateAttrDefaultValues.getBoolValue());
            }
            if (this._generateModelGroups != null) {
                gm.setGenerateModelGroups(this._generateModelGroups.getBoolValue());
            }
            TaskUtils.addSkipNamespaces(gm, this._skipNamespaces);
            TaskUtils.addTreatAsSimpleTypes(gm, this._treatAsSimpleTypes);
            TaskUtils.addTypeMappings(gm, this._typeMappings);
            TaskUtils.addEnumOverrides(gm, this._enumOverrides);
            gm.generate();
        }
        catch (Exception e) {
            BuildException be = null;
            be = e instanceof BuildException ? (BuildException)e : new BuildException(e.getMessage());
            throw be;
        }
    }
}

